/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.crafttweaker.ingredient;

import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.api.data.IData;
import com.blamejared.crafttweaker.api.data.JSONConverter;
import com.blamejared.crafttweaker.api.fluid.IFluidStack;
import com.blamejared.crafttweaker.impl.tag.MCTag;
import com.blamejared.crafttweaker.impl.tag.MCTagWithAmount;
import com.blamejared.crafttweaker.impl.tag.manager.TagManagerFluid;
import com.blamejared.crafttweaker_annotations.annotations.NativeTypeRegistration;
import com.google.gson.JsonElement;
import mekanism.api.recipes.inputs.FluidStackIngredient;
import mekanism.api.recipes.inputs.InputIngredient;
import mekanism.common.integration.crafttweaker.ingredient.CrTIngredientHelper;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.tags.ITag;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@NativeTypeRegistration(value=FluidStackIngredient.class, zenCodeName="mods.mekanism.api.ingredient.FluidStackIngredient")
public class CrTFluidStackIngredient {
    private CrTFluidStackIngredient() {
    }

    @ZenCodeType.StaticExpansionMethod
    public static FluidStackIngredient from(Fluid fluid, int amount) {
        CrTIngredientHelper.assertValidAmount("FluidStackIngredients", amount);
        if (fluid == Fluids.field_204541_a) {
            throw new IllegalArgumentException("FluidStackIngredients cannot be created from an empty fluid.");
        }
        return FluidStackIngredient.from(fluid, amount);
    }

    @ZenCodeType.StaticExpansionMethod
    public static FluidStackIngredient from(IFluidStack instance) {
        if (instance.isEmpty()) {
            throw new IllegalArgumentException("FluidStackIngredients cannot be created from an empty stack.");
        }
        return FluidStackIngredient.from(instance.getImmutableInternal());
    }

    @ZenCodeType.StaticExpansionMethod
    public static FluidStackIngredient from(MCTag<Fluid> fluidTag, int amount) {
        ITag tag = CrTIngredientHelper.assertValidAndGet(fluidTag, amount, arg_0 -> ((TagManagerFluid)TagManagerFluid.INSTANCE).getInternal(arg_0), "FluidStackIngredients");
        return FluidStackIngredient.from(tag, amount);
    }

    @ZenCodeType.StaticExpansionMethod
    public static FluidStackIngredient from(MCTagWithAmount<Fluid> fluidTag) {
        return CrTFluidStackIngredient.from((MCTag<Fluid>)fluidTag.getTag(), fluidTag.getAmount());
    }

    @ZenCodeType.StaticExpansionMethod
    public static FluidStackIngredient createMulti(FluidStackIngredient ... ingredients) {
        return (FluidStackIngredient)CrTIngredientHelper.createMulti((String)"FluidStackIngredients", FluidStackIngredient::createMulti, (InputIngredient[])ingredients);
    }

    @ZenCodeType.Method
    @ZenCodeType.Caster(implicit=true)
    public static IData asIData(FluidStackIngredient _this) {
        return JSONConverter.convert((JsonElement)_this.serialize());
    }

    @ZenCodeType.Method
    @ZenCodeType.Operator(value=ZenCodeType.OperatorType.OR)
    public static FluidStackIngredient or(FluidStackIngredient _this, FluidStackIngredient other) {
        return FluidStackIngredient.createMulti(_this, other);
    }
}

