/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.computer.computercraft;

import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.MethodResult;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.DoublePredicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import mekanism.api.Coord4D;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.math.FloatingLong;
import mekanism.api.text.EnumColor;
import mekanism.common.content.filter.BaseFilter;
import mekanism.common.content.filter.FilterType;
import mekanism.common.content.filter.IFilter;
import mekanism.common.content.filter.IItemStackFilter;
import mekanism.common.content.filter.IMaterialFilter;
import mekanism.common.content.filter.IModIDFilter;
import mekanism.common.content.filter.ITagFilter;
import mekanism.common.content.miner.MinerFilter;
import mekanism.common.content.oredictionificator.OredictionificatorFilter;
import mekanism.common.content.oredictionificator.OredictionificatorItemFilter;
import mekanism.common.content.qio.filter.QIOFilter;
import mekanism.common.content.qio.filter.QIOItemStackFilter;
import mekanism.common.content.transporter.SorterFilter;
import mekanism.common.content.transporter.SorterItemStackFilter;
import mekanism.common.integration.computer.ComputerArgumentHandler;
import mekanism.common.lib.frequency.Frequency;
import mekanism.common.tile.machine.TileEntityOredictionificator;
import mekanism.common.util.text.InputValidator;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.ByteArrayNBT;
import net.minecraft.nbt.ByteNBT;
import net.minecraft.nbt.CollectionNBT;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.DoubleNBT;
import net.minecraft.nbt.EndNBT;
import net.minecraft.nbt.FloatNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntArrayNBT;
import net.minecraft.nbt.IntNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.LongArrayNBT;
import net.minecraft.nbt.LongNBT;
import net.minecraft.nbt.NumberNBT;
import net.minecraft.nbt.ShortNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistryEntry;
import org.jetbrains.annotations.VisibleForTesting;

public class CCArgumentWrapper
extends ComputerArgumentHandler<LuaException, MethodResult> {
    private static final double MAX_FLOATING_LONG_AS_DOUBLE = Double.parseDouble(FloatingLong.MAX_VALUE.toString());
    @VisibleForTesting
    static final String TYPE_HINT_KEY = "typeHint";
    @VisibleForTesting
    static final Double TYPE_HINT_VALUE_KEY = 0.0;
    private final IArguments arguments;

    CCArgumentWrapper(IArguments arguments) {
        this.arguments = arguments;
    }

    @Override
    public int getCount() {
        return this.arguments.count();
    }

    @Override
    public LuaException error(String messageFormat, Object ... args) {
        return new LuaException(this.formatError(messageFormat, args));
    }

    @Override
    @Nullable
    public Object getArgument(int index) {
        return this.arguments.get(index);
    }

    @Override
    public Object sanitizeArgument(Class<?> expectedType, Class<?> argumentType, Object argument) {
        Object sanitized;
        if (argumentType == Double.class) {
            double d = (Double)argument;
            if (Double.isFinite(d)) {
                Enum[] enumConstants;
                if (expectedType == Byte.TYPE || expectedType == Byte.class) {
                    if (d >= -128.0 && d <= 127.0) {
                        return (byte)d;
                    }
                } else if (expectedType == Short.TYPE || expectedType == Short.class) {
                    if (d >= -32768.0 && d <= 32767.0) {
                        return (short)d;
                    }
                } else if (expectedType == Integer.TYPE || expectedType == Integer.class) {
                    if (d >= -2.147483648E9 && d <= 2.147483647E9) {
                        return (int)d;
                    }
                } else if (expectedType == Long.TYPE || expectedType == Long.class) {
                    if (d >= -9.223372036854776E18 && d <= 9.223372036854776E18) {
                        return (long)d;
                    }
                } else if (expectedType == Float.TYPE || expectedType == Float.class) {
                    if (d >= -3.4028234663852886E38 && d <= 3.4028234663852886E38) {
                        return Float.valueOf((float)d);
                    }
                } else if (expectedType == FloatingLong.class) {
                    if (d >= 0.0 && d <= MAX_FLOATING_LONG_AS_DOUBLE) {
                        return FloatingLong.createConst(d);
                    }
                } else if (expectedType.isEnum() && d >= 0.0 && d < (double)(enumConstants = (Enum[])expectedType.getEnumConstants()).length) {
                    return enumConstants[(int)d];
                }
            }
        } else if (argumentType == String.class) {
            Item item;
            if (expectedType == char[].class) {
                return ((String)argument).toCharArray();
            }
            if (expectedType == Character.TYPE || expectedType == Character.class) {
                String string = (String)argument;
                if (string.length() == 1) {
                    return Character.valueOf(string.charAt(0));
                }
            } else if (expectedType == ResourceLocation.class) {
                ResourceLocation rl = ResourceLocation.func_208304_a((String)((String)argument));
                if (rl != null) {
                    return rl;
                }
            } else if (expectedType.isEnum()) {
                Object sanitized2 = CCArgumentWrapper.sanitizeStringToEnum(expectedType, (String)argument);
                if (sanitized2 != null) {
                    return sanitized2;
                }
            } else if (Item.class.isAssignableFrom(expectedType) && expectedType.isInstance(item = CCArgumentWrapper.tryCreateItem(argument))) {
                return item;
            }
        } else if (argument instanceof Map && IFilter.class.isAssignableFrom(expectedType) && (sanitized = CCArgumentWrapper.convertMapToFilter(expectedType, (Map)argument)) != null) {
            return sanitized;
        }
        if (INBT.class.isAssignableFrom(expectedType) && (sanitized = CCArgumentWrapper.sanitizeNBT(expectedType, argumentType, argument)) != null) {
            return sanitized;
        }
        return super.sanitizeArgument(expectedType, argumentType, argument);
    }

    @Override
    public MethodResult noResult() {
        return MethodResult.of();
    }

    @Override
    public MethodResult wrapResult(Object result) {
        return MethodResult.of((Object)CCArgumentWrapper.wrapReturnType(result));
    }

    private static Object wrapReturnType(Object result) {
        if (result == null || result instanceof Number || result instanceof Boolean || result instanceof String) {
            return result;
        }
        if (result instanceof ResourceLocation || result instanceof UUID) {
            return result.toString();
        }
        if (result instanceof ForgeRegistryEntry) {
            return CCArgumentWrapper.getName((ForgeRegistryEntry)result);
        }
        if (result instanceof ChemicalStack) {
            ChemicalStack stack = (ChemicalStack)result;
            HashMap<String, Object> wrapped = new HashMap<String, Object>(2);
            wrapped.put("name", CCArgumentWrapper.getName(stack.getType()));
            wrapped.put("amount", stack.getAmount());
            return wrapped;
        }
        if (result instanceof FluidStack) {
            FluidStack stack = (FluidStack)result;
            return CCArgumentWrapper.wrapStack(stack.getFluid(), "amount", stack.getAmount(), stack.getTag());
        }
        if (result instanceof ItemStack) {
            ItemStack stack = (ItemStack)result;
            return CCArgumentWrapper.wrapStack(stack.func_77973_b(), "count", stack.func_190916_E(), stack.func_77978_p());
        }
        if (result instanceof INBT) {
            Object wrapped = CCArgumentWrapper.wrapNBT((INBT)result);
            if (wrapped != null) {
                return wrapped;
            }
        } else {
            if (result instanceof Vector3i) {
                Vector3i pos = (Vector3i)result;
                HashMap<String, Integer> wrapped = new HashMap<String, Integer>(3);
                wrapped.put("x", pos.func_177958_n());
                wrapped.put("y", pos.func_177956_o());
                wrapped.put("z", pos.func_177952_p());
                return wrapped;
            }
            if (result instanceof Coord4D) {
                Coord4D coord = (Coord4D)result;
                HashMap<String, Object> wrapped = new HashMap<String, Object>(4);
                wrapped.put("x", coord.getX());
                wrapped.put("y", coord.getY());
                wrapped.put("z", coord.getZ());
                wrapped.put("dimension", CCArgumentWrapper.wrapReturnType(coord.dimension.func_240901_a_()));
                return wrapped;
            }
            if (result instanceof Frequency) {
                Frequency.FrequencyIdentity identity = ((Frequency)result).getIdentity();
                HashMap<String, Object> wrapped = new HashMap<String, Object>(2);
                wrapped.put("key", CCArgumentWrapper.wrapReturnType(identity.getKey()));
                wrapped.put("public", identity.isPublic());
                return wrapped;
            }
            if (result instanceof Enum) {
                return ((Enum)result).name();
            }
            if (result instanceof IFilter) {
                BaseFilter filter;
                HashMap<String, Object> wrapped = new HashMap<String, Object>();
                wrapped.put("type", CCArgumentWrapper.wrapReturnType((Object)((IFilter)result).getFilterType()));
                if (result instanceof IItemStackFilter) {
                    CompoundNBT tag;
                    ItemStack stack = ((IItemStackFilter)result).getItemStack();
                    wrapped.put("item", CCArgumentWrapper.wrapReturnType(stack.func_77973_b()));
                    if (!stack.func_190926_b() && (tag = stack.func_77978_p()) != null && !tag.isEmpty()) {
                        wrapped.put("itemNBT", CCArgumentWrapper.wrapNBT((INBT)tag));
                    }
                } else if (result instanceof IMaterialFilter) {
                    wrapped.put("materialItem", CCArgumentWrapper.wrapReturnType(((IMaterialFilter)result).getMaterialItem().func_77973_b()));
                } else if (result instanceof IModIDFilter) {
                    wrapped.put("modId", ((IModIDFilter)result).getModID());
                } else if (result instanceof ITagFilter) {
                    wrapped.put("tag", ((ITagFilter)result).getTagName());
                }
                if (result instanceof MinerFilter) {
                    MinerFilter minerFilter = (MinerFilter)result;
                    wrapped.put("requiresReplacement", minerFilter.requiresReplacement);
                    wrapped.put("replaceTarget", CCArgumentWrapper.wrapReturnType(minerFilter.replaceTarget));
                } else if (result instanceof SorterFilter) {
                    SorterFilter sorterFilter = (SorterFilter)result;
                    wrapped.put("allowDefault", sorterFilter.allowDefault);
                    wrapped.put("color", CCArgumentWrapper.wrapReturnType(sorterFilter.color));
                    wrapped.put("size", sorterFilter.sizeMode);
                    wrapped.put("min", sorterFilter.min);
                    wrapped.put("max", sorterFilter.max);
                    if (sorterFilter instanceof SorterItemStackFilter) {
                        filter = (SorterItemStackFilter)sorterFilter;
                        wrapped.put("fuzzy", ((SorterItemStackFilter)filter).fuzzyMode);
                    }
                } else if (result instanceof QIOFilter) {
                    QIOFilter qioFilter = (QIOFilter)result;
                    if (qioFilter instanceof QIOItemStackFilter) {
                        filter = (QIOItemStackFilter)qioFilter;
                        wrapped.put("fuzzy", filter.fuzzyMode);
                    }
                } else if (result instanceof OredictionificatorFilter) {
                    OredictionificatorFilter filter2 = (OredictionificatorFilter)result;
                    wrapped.put("target", filter2.getFilterText());
                    wrapped.put("selected", CCArgumentWrapper.wrapReturnType(filter2.getResultElement()));
                }
                return wrapped;
            }
            if (result instanceof Map) {
                return ((Map)result).entrySet().stream().collect(Collectors.toMap(entry -> CCArgumentWrapper.wrapReturnType(entry.getKey()), entry -> CCArgumentWrapper.wrapReturnType(entry.getValue()), (a, b) -> b));
            }
            if (result instanceof Collection) {
                return ((Collection)result).stream().map(CCArgumentWrapper::wrapReturnType).collect(Collectors.toList());
            }
            if (result instanceof Object[]) {
                return Arrays.stream((Object[])result).map(CCArgumentWrapper::wrapReturnType).toArray();
            }
        }
        return result;
    }

    private static Map<String, Object> wrapStack(ForgeRegistryEntry<?> entry, String sizeKey, int amount, @Nullable CompoundNBT tag) {
        boolean hasTag = tag != null && !tag.isEmpty() && amount > 0;
        HashMap<String, Object> wrapped = new HashMap<String, Object>(hasTag ? 3 : 2);
        wrapped.put("name", CCArgumentWrapper.getName(entry));
        wrapped.put(sizeKey, amount);
        if (hasTag) {
            wrapped.put("nbt", CCArgumentWrapper.wrapNBT((INBT)tag));
        }
        return wrapped;
    }

    @Nullable
    private static Object wrapNBT(@Nullable INBT nbt) {
        if (nbt == null) {
            return null;
        }
        switch (nbt.func_74732_a()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 99: {
                return ((NumberNBT)nbt).func_209908_j();
            }
            case 0: 
            case 8: {
                return nbt.func_150285_a_();
            }
            case 7: 
            case 9: 
            case 11: 
            case 12: {
                CollectionNBT collectionNBT = (CollectionNBT)nbt;
                int size = collectionNBT.size();
                HashMap<Integer, Object> wrappedCollection = new HashMap<Integer, Object>(size);
                for (int i = 0; i < size; ++i) {
                    wrappedCollection.put(i, CCArgumentWrapper.wrapNBT((INBT)collectionNBT.get(i)));
                }
                return wrappedCollection;
            }
            case 10: {
                CompoundNBT compound = (CompoundNBT)nbt;
                HashMap<String, Object> wrappedCompound = new HashMap<String, Object>(compound.func_186856_d());
                for (String key : compound.func_150296_c()) {
                    Object value = CCArgumentWrapper.wrapNBT(compound.func_74781_a(key));
                    if (value == null) continue;
                    wrappedCompound.put(key, value);
                }
                return wrappedCompound;
            }
        }
        return null;
    }

    private static String getName(ForgeRegistryEntry<?> entry) {
        ResourceLocation registryName = entry.getRegistryName();
        return registryName == null ? null : registryName.toString();
    }

    @Nullable
    private static <ENUM extends Enum<?>> ENUM sanitizeStringToEnum(Class<? extends ENUM> expectedType, String argument) {
        if (!argument.isEmpty()) {
            Enum[] enumConstants;
            for (Enum enumConstant : enumConstants = (Enum[])expectedType.getEnumConstants()) {
                if (!argument.equalsIgnoreCase(enumConstant.name())) continue;
                return (ENUM)enumConstant;
            }
        }
        return null;
    }

    private static ItemStack tryCreateFilterItem(@Nullable Object rawName, @Nullable Object rawNBT) {
        Item item = CCArgumentWrapper.tryCreateItem(rawName);
        if (item == Items.field_190931_a) {
            return ItemStack.field_190927_a;
        }
        ItemStack stack = new ItemStack((IItemProvider)item);
        if (rawNBT != null) {
            INBT nbt = CCArgumentWrapper.sanitizeNBT(CompoundNBT.class, rawNBT.getClass(), rawNBT);
            if (!(nbt instanceof CompoundNBT)) {
                return ItemStack.field_190927_a;
            }
            stack.func_77982_d((CompoundNBT)nbt);
        }
        return stack;
    }

    private static Item tryCreateItem(@Nullable Object rawName) {
        Item item;
        ResourceLocation itemName;
        if (rawName instanceof String && (itemName = ResourceLocation.func_208304_a((String)((String)rawName))) != null && (item = (Item)ForgeRegistries.ITEMS.getValue(itemName)) != null) {
            return item;
        }
        return Items.field_190931_a;
    }

    @Nullable
    private static String tryGetFilterTag(@Nullable Object rawTag) {
        String tag;
        if (rawTag instanceof String && !(tag = (String)rawTag).isEmpty() && InputValidator.test(tag = tag.toLowerCase(Locale.ROOT), InputValidator.RESOURCE_LOCATION.or(InputValidator.WILDCARD_CHARS))) {
            return tag;
        }
        return null;
    }

    @Nullable
    private static String tryGetFilterModId(@Nullable Object rawModId) {
        String modId;
        if (rawModId instanceof String && !(modId = (String)rawModId).isEmpty() && InputValidator.test(modId = modId.toLowerCase(Locale.ROOT), InputValidator.RL_NAMESPACE.or(InputValidator.WILDCARD_CHARS))) {
            return modId;
        }
        return null;
    }

    private static boolean getBooleanFromRaw(@Nullable Object raw) {
        if (raw instanceof Boolean) {
            return (Boolean)raw;
        }
        return false;
    }

    private static int getIntFromRaw(@Nullable Object raw) {
        if (raw instanceof Number) {
            return ((Number)raw).intValue();
        }
        return 0;
    }

    @Nullable
    private static Object convertMapToFilter(Class<?> expectedType, Map<?, ?> map) {
        IFilter<?> filter;
        FilterType filterType;
        Object type = map.get("type");
        if (type instanceof String && (filterType = CCArgumentWrapper.sanitizeStringToEnum(FilterType.class, (String)type)) != null && expectedType.isInstance(filter = BaseFilter.fromType(filterType))) {
            ItemStack stack;
            if (filter instanceof IItemStackFilter) {
                stack = CCArgumentWrapper.tryCreateFilterItem(map.get("item"), map.get("itemNBT"));
                if (stack.func_190926_b()) {
                    return null;
                }
                ((IItemStackFilter)filter).setItemStack(stack);
            } else if (filter instanceof IMaterialFilter) {
                stack = CCArgumentWrapper.tryCreateFilterItem(map.get("materialItem"), null);
                if (stack.func_190926_b()) {
                    return null;
                }
                ((IMaterialFilter)filter).setMaterialItem(stack);
            } else if (filter instanceof IModIDFilter) {
                String modId = CCArgumentWrapper.tryGetFilterModId(map.get("modId"));
                if (modId == null) {
                    return null;
                }
                ((IModIDFilter)filter).setModID(modId);
            } else if (filter instanceof ITagFilter) {
                String tag = CCArgumentWrapper.tryGetFilterTag(map.get("tag"));
                if (tag == null) {
                    return null;
                }
                ((ITagFilter)filter).setTagName(tag);
            }
            if (filter instanceof MinerFilter) {
                MinerFilter minerFilter = (MinerFilter)filter;
                minerFilter.requiresReplacement = CCArgumentWrapper.getBooleanFromRaw(map.get("requiresReplacement"));
                minerFilter.replaceTarget = CCArgumentWrapper.tryCreateItem(map.get("replaceTarget"));
            } else if (filter instanceof SorterFilter) {
                SorterFilter sorterFilter = (SorterFilter)filter;
                sorterFilter.allowDefault = CCArgumentWrapper.getBooleanFromRaw(map.get("allowDefault"));
                Object rawColor = map.get("color");
                if (rawColor instanceof String) {
                    sorterFilter.color = CCArgumentWrapper.sanitizeStringToEnum(EnumColor.class, (String)rawColor);
                }
                sorterFilter.sizeMode = CCArgumentWrapper.getBooleanFromRaw(map.get("size"));
                sorterFilter.min = CCArgumentWrapper.getIntFromRaw(map.get("min"));
                sorterFilter.max = CCArgumentWrapper.getIntFromRaw(map.get("max"));
                if (sorterFilter.min < 0 || sorterFilter.max < 0 || sorterFilter.min > sorterFilter.max || sorterFilter.max > 64) {
                    return null;
                }
                if (sorterFilter instanceof SorterItemStackFilter) {
                    SorterItemStackFilter sorterItemFilter = (SorterItemStackFilter)sorterFilter;
                    sorterItemFilter.fuzzyMode = CCArgumentWrapper.getBooleanFromRaw(map.get("fuzzy"));
                }
            } else if (filter instanceof QIOFilter) {
                QIOFilter qioFilter = (QIOFilter)filter;
                if (qioFilter instanceof QIOItemStackFilter) {
                    QIOItemStackFilter qioItemFilter = (QIOItemStackFilter)qioFilter;
                    qioItemFilter.fuzzyMode = CCArgumentWrapper.getBooleanFromRaw(map.get("fuzzy"));
                }
            } else if (filter instanceof OredictionificatorFilter) {
                Item item;
                OredictionificatorFilter oredictionificatorFilter = (OredictionificatorFilter)filter;
                Object rawTag = map.get("target");
                if (!(rawTag instanceof String)) {
                    return null;
                }
                String tag = (String)rawTag;
                if (tag.isEmpty()) {
                    return null;
                }
                ResourceLocation rl = ResourceLocation.func_208304_a((String)tag);
                if (rl == null || !TileEntityOredictionificator.isValidTarget(rl)) {
                    return null;
                }
                oredictionificatorFilter.setFilter(rl);
                if (oredictionificatorFilter instanceof OredictionificatorItemFilter && (item = CCArgumentWrapper.tryCreateItem(map.get("selected"))) != Items.field_190931_a) {
                    ((OredictionificatorItemFilter)oredictionificatorFilter).setSelectedOutput(item);
                }
            }
            return filter;
        }
        return null;
    }

    @Nullable
    private static INBT sanitizeNBT(Class<?> expectedType, Class<?> argumentType, Object argument) {
        if (argumentType == Boolean.class) {
            if (expectedType == ByteNBT.class || expectedType == NumberNBT.class || expectedType == INBT.class) {
                return ByteNBT.func_229672_a_((boolean)((Boolean)argument));
            }
        } else if (argumentType == Double.class) {
            double d = (Double)argument;
            if (Double.isFinite(d)) {
                if (expectedType == ByteNBT.class) {
                    if (d >= -128.0 && d <= 127.0) {
                        return ByteNBT.func_229671_a_((byte)((byte)d));
                    }
                } else if (expectedType == ShortNBT.class) {
                    if (d >= -32768.0 && d <= 32767.0) {
                        return ShortNBT.func_229701_a_((short)((short)d));
                    }
                } else if (expectedType == IntNBT.class) {
                    if (d >= -2.147483648E9 && d <= 2.147483647E9) {
                        return IntNBT.func_229692_a_((int)((int)d));
                    }
                } else if (expectedType == LongNBT.class) {
                    if (d >= -9.223372036854776E18 && d <= 9.223372036854776E18) {
                        return LongNBT.func_229698_a_((long)((long)d));
                    }
                } else if (expectedType == FloatNBT.class) {
                    if (d >= -3.4028234663852886E38 && d <= 3.4028234663852886E38) {
                        return FloatNBT.func_229689_a_((float)((float)d));
                    }
                } else {
                    if (expectedType == DoubleNBT.class) {
                        return DoubleNBT.func_229684_a_((double)d);
                    }
                    if (expectedType == NumberNBT.class || expectedType == INBT.class) {
                        if (d == Math.floor(d) && d >= -9.223372036854776E18 && d <= 9.223372036854776E18) {
                            if (d >= -128.0 && d <= 127.0) {
                                return ByteNBT.func_229671_a_((byte)((byte)d));
                            }
                            if (d >= -32768.0 && d <= 32767.0) {
                                return ShortNBT.func_229701_a_((short)((short)d));
                            }
                            if (d >= -2.147483648E9 && d <= 2.147483647E9) {
                                return IntNBT.func_229692_a_((int)((int)d));
                            }
                            return LongNBT.func_229698_a_((long)((long)d));
                        }
                        if (d >= -3.4028234663852886E38 && d <= 3.4028234663852886E38) {
                            return FloatNBT.func_229689_a_((float)((float)d));
                        }
                        return DoubleNBT.func_229684_a_((double)d);
                    }
                }
            }
        } else if (argumentType == String.class) {
            if (expectedType == StringNBT.class || expectedType == INBT.class) {
                return StringNBT.func_229705_a_((String)((String)argument));
            }
            if (expectedType == EndNBT.class && argument.equals("END")) {
                return EndNBT.field_229686_b_;
            }
        } else if (argument instanceof Map) {
            Map map = (Map)argument;
            if (map.size() == 2) {
                double hint;
                Object value2 = map.get(TYPE_HINT_VALUE_KEY);
                Object typeHintRaw = map.get(TYPE_HINT_KEY);
                if (value2 != null && typeHintRaw instanceof Double && Double.isFinite(hint = ((Double)typeHintRaw).doubleValue()) && (hint == 99.0 || hint >= 0.0 && hint <= 12.0)) {
                    Class<? extends INBT> hinted = CCArgumentWrapper.getTypeFromHint((int)hint);
                    if (expectedType == hinted || expectedType == INBT.class) {
                        return CCArgumentWrapper.sanitizeNBT(hinted, value2.getClass(), value2);
                    }
                    if (expectedType == NumberNBT.class ? hinted == ByteNBT.class || hinted == ShortNBT.class || hinted == IntNBT.class || hinted == LongNBT.class || hinted == FloatNBT.class || hinted == DoubleNBT.class : expectedType == CollectionNBT.class && (hinted == ByteArrayNBT.class || hinted == IntArrayNBT.class || hinted == LongArrayNBT.class || hinted == ListNBT.class)) {
                        return CCArgumentWrapper.sanitizeNBT(hinted, value2.getClass(), value2);
                    }
                    return null;
                }
            }
            Set entries = map.entrySet();
            if (expectedType == ByteArrayNBT.class) {
                byte[] bytes = new byte[entries.size()];
                if (CCArgumentWrapper.sanitizeNBTCollection(entries, new ArrayElementValidator(value -> value >= -128.0 && value <= 127.0, (key, value) -> {
                    bytes[key.intValue()] = value.byteValue();
                }, 1))) {
                    return new ByteArrayNBT(bytes);
                }
            } else if (expectedType == IntArrayNBT.class) {
                int[] ints = new int[entries.size()];
                if (CCArgumentWrapper.sanitizeNBTCollection(entries, new ArrayElementValidator(value -> value >= -2.147483648E9 && value <= 2.147483647E9, (key, value) -> {
                    ints[key.intValue()] = value.intValue();
                }, 3))) {
                    return new IntArrayNBT(ints);
                }
            } else if (expectedType == LongArrayNBT.class) {
                long[] longs = new long[entries.size()];
                if (CCArgumentWrapper.sanitizeNBTCollection(entries, new ArrayElementValidator(value -> value >= -9.223372036854776E18 && value <= 9.223372036854776E18, (key, value) -> {
                    longs[key.intValue()] = value.longValue();
                }, 4))) {
                    return new LongArrayNBT(longs);
                }
            } else {
                if (expectedType == ListNBT.class) {
                    return CCArgumentWrapper.sanitizeNBTList(entries);
                }
                if (expectedType == CollectionNBT.class) {
                    return CCArgumentWrapper.sanitizeNBTCollection(entries);
                }
                if (expectedType == CompoundNBT.class) {
                    return CCArgumentWrapper.sanitizeNBTCompound(entries);
                }
                if (expectedType == INBT.class) {
                    Optional element = entries.stream().findAny();
                    if (element.isPresent() && ((Map.Entry)element.get()).getKey() instanceof Double) {
                        return CCArgumentWrapper.sanitizeNBTCollection(entries);
                    }
                    return CCArgumentWrapper.sanitizeNBTCompound(entries);
                }
            }
        }
        return null;
    }

    private static Class<? extends INBT> getTypeFromHint(int hint) {
        switch (hint) {
            case 1: {
                return ByteNBT.class;
            }
            case 2: {
                return ShortNBT.class;
            }
            case 3: {
                return IntNBT.class;
            }
            case 4: {
                return LongNBT.class;
            }
            case 5: {
                return FloatNBT.class;
            }
            case 6: {
                return DoubleNBT.class;
            }
            case 99: {
                return NumberNBT.class;
            }
            case 8: {
                return StringNBT.class;
            }
            case 7: {
                return ByteArrayNBT.class;
            }
            case 11: {
                return IntArrayNBT.class;
            }
            case 12: {
                return LongArrayNBT.class;
            }
            case 9: {
                return ListNBT.class;
            }
            case 10: {
                return CompoundNBT.class;
            }
            case 0: {
                return EndNBT.class;
            }
        }
        return INBT.class;
    }

    @Nullable
    private static CompoundNBT sanitizeNBTCompound(Set<? extends Map.Entry<?, ?>> entries) {
        CompoundNBT nbt = new CompoundNBT();
        for (Map.Entry<?, ?> entry : entries) {
            Object key = entry.getKey();
            if (!(key instanceof String)) {
                return null;
            }
            Object value = entry.getValue();
            INBT nbtValue = CCArgumentWrapper.sanitizeNBT(INBT.class, value.getClass(), value);
            if (nbtValue != null && nbt.func_218657_a((String)key, nbtValue) == null) continue;
            return null;
        }
        return nbt;
    }

    @Nullable
    private static CollectionNBT<?> sanitizeNBTCollection(Set<? extends Map.Entry<?, ?>> entries) {
        ListNBT nbtList = CCArgumentWrapper.sanitizeNBTList(entries);
        if (nbtList != null) {
            if (nbtList.func_230528_d__() == 1) {
                return new ByteArrayNBT(nbtList.stream().map(e -> ((ByteNBT)e).func_150290_f()).collect(Collectors.toList()));
            }
            if (nbtList.func_230528_d__() == 3) {
                return new IntArrayNBT(nbtList.stream().mapToInt(e -> ((IntNBT)e).func_150287_d()).toArray());
            }
            if (nbtList.func_230528_d__() == 4) {
                return new LongArrayNBT(nbtList.stream().mapToLong(e -> ((LongNBT)e).func_150291_c()).toArray());
            }
            return nbtList;
        }
        return null;
    }

    @Nullable
    private static ListNBT sanitizeNBTList(Set<? extends Map.Entry<?, ?>> entries) {
        ValidateAndConsumeListElement val = new ValidateAndConsumeListElement(entries.size());
        return CCArgumentWrapper.sanitizeNBTCollection(entries, val) ? val.toList() : null;
    }

    private static boolean sanitizeNBTCollection(Set<? extends Map.Entry<?, ?>> entries, BiFunction<Integer, Object, Boolean> validateAndConsumeValue) {
        boolean[] valuesSet = new boolean[entries.size()];
        for (Map.Entry<?, ?> entry : entries) {
            Object key = entry.getKey();
            if (!(key instanceof Double)) {
                return false;
            }
            double k = (Double)key;
            if (!Double.isFinite(k) || k < 0.0 || k >= (double)valuesSet.length) {
                return false;
            }
            int intKey = (int)k;
            if (valuesSet[intKey] || !validateAndConsumeValue.apply(intKey, entry.getValue()).booleanValue()) {
                return false;
            }
            valuesSet[intKey] = true;
        }
        return true;
    }

    private static class ValidateAndConsumeListElement
    implements BiFunction<Integer, Object, Boolean> {
        private final INBT[] elements;
        private Class<? extends INBT> desiredClass = INBT.class;
        private Class<? extends INBT> searchClass = INBT.class;

        public ValidateAndConsumeListElement(int size) {
            this.elements = new INBT[size];
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public Boolean apply(Integer key, Object value) {
            INBT element = CCArgumentWrapper.sanitizeNBT(this.searchClass, value.getClass(), value);
            if (element == null) {
                return false;
            }
            Class<?> elementClass = element.getClass();
            if (elementClass == EndNBT.class) {
                return false;
            }
            if (this.desiredClass == INBT.class) {
                this.desiredClass = elementClass;
                if (element instanceof NumberNBT) {
                    this.searchClass = NumberNBT.class;
                } else if (elementClass == ListNBT.class) {
                    this.searchClass = ((ListNBT)element).func_230528_d__() == 2 ? CollectionNBT.class : elementClass;
                } else if (element instanceof CollectionNBT) {
                    this.searchClass = CollectionNBT.class;
                } else if (!(element instanceof CompoundNBT) || !((CompoundNBT)element).isEmpty()) {
                    this.searchClass = elementClass;
                }
            } else if (this.desiredClass != elementClass) {
                if (element instanceof NumberNBT) {
                    if (ValidateAndConsumeListElement.validUpcast(this.desiredClass, elementClass)) {
                        this.desiredClass = elementClass;
                    } else if (!ValidateAndConsumeListElement.validUpcast(elementClass, this.desiredClass)) {
                        return false;
                    }
                } else if (elementClass == ByteArrayNBT.class) {
                    if (this.desiredClass != IntArrayNBT.class && this.desiredClass != LongArrayNBT.class && (this.desiredClass != ListNBT.class || this.searchClass != CollectionNBT.class)) {
                        if (this.desiredClass != CompoundNBT.class || this.searchClass != INBT.class) return false;
                        this.desiredClass = ByteArrayNBT.class;
                        this.searchClass = CollectionNBT.class;
                    }
                } else if (elementClass == IntArrayNBT.class) {
                    if (this.desiredClass == ByteArrayNBT.class || this.desiredClass == ListNBT.class && this.searchClass == CollectionNBT.class) {
                        this.desiredClass = IntArrayNBT.class;
                    } else if (this.desiredClass != LongArrayNBT.class) {
                        if (this.desiredClass != CompoundNBT.class || this.searchClass != INBT.class) return false;
                        this.desiredClass = IntArrayNBT.class;
                        this.searchClass = CollectionNBT.class;
                    }
                } else if (elementClass == LongArrayNBT.class) {
                    if (this.desiredClass == ByteArrayNBT.class || this.desiredClass == IntArrayNBT.class || this.desiredClass == ListNBT.class && this.searchClass == CollectionNBT.class) {
                        this.desiredClass = LongArrayNBT.class;
                    } else {
                        if (this.desiredClass != CompoundNBT.class || this.searchClass != INBT.class) return false;
                        this.desiredClass = LongArrayNBT.class;
                        this.searchClass = CollectionNBT.class;
                    }
                } else {
                    if (elementClass != ListNBT.class) return false;
                    byte listType = ((ListNBT)element).func_230528_d__();
                    if (this.desiredClass == ByteArrayNBT.class) {
                        if (listType != 0) {
                            this.desiredClass = ListNBT.class;
                            if (listType != 2) {
                                this.searchClass = ListNBT.class;
                            }
                        }
                    } else if (this.desiredClass == IntArrayNBT.class || this.desiredClass == LongArrayNBT.class) {
                        if (listType != 0 && listType != 2) {
                            this.desiredClass = ListNBT.class;
                            this.searchClass = ListNBT.class;
                        }
                    } else {
                        if (this.desiredClass != CompoundNBT.class || this.searchClass != INBT.class) return false;
                        this.desiredClass = ListNBT.class;
                        this.searchClass = listType == 2 ? CollectionNBT.class : ListNBT.class;
                    }
                }
            } else if (elementClass == ListNBT.class) {
                byte listType;
                if (this.searchClass == CollectionNBT.class && (listType = ((ListNBT)element).func_230528_d__()) != 0 && listType != 2) {
                    this.searchClass = ListNBT.class;
                }
            } else if (elementClass == CompoundNBT.class && !((CompoundNBT)element).isEmpty() && this.searchClass == INBT.class) {
                this.searchClass = elementClass;
            }
            this.elements[key.intValue()] = element;
            return true;
        }

        public ListNBT toList() {
            ListNBT listNBT = new ListNBT();
            if (this.desiredClass == ShortNBT.class) {
                Arrays.stream(this.elements).map(element -> element instanceof ShortNBT ? element : ShortNBT.func_229701_a_((short)((NumberNBT)element).func_150289_e())).collect(Collectors.toCollection(() -> listNBT));
            } else if (this.desiredClass == IntNBT.class) {
                Arrays.stream(this.elements).map(element -> element instanceof IntNBT ? element : IntNBT.func_229692_a_((int)((NumberNBT)element).func_150287_d())).collect(Collectors.toCollection(() -> listNBT));
            } else if (this.desiredClass == LongNBT.class) {
                Arrays.stream(this.elements).map(element -> element instanceof LongNBT ? element : LongNBT.func_229698_a_((long)((NumberNBT)element).func_150291_c())).collect(Collectors.toCollection(() -> listNBT));
            } else if (this.desiredClass == FloatNBT.class) {
                Arrays.stream(this.elements).map(element -> element instanceof FloatNBT ? element : FloatNBT.func_229689_a_((float)((NumberNBT)element).func_150288_h())).collect(Collectors.toCollection(() -> listNBT));
            } else if (this.desiredClass == DoubleNBT.class) {
                Arrays.stream(this.elements).map(element -> element instanceof DoubleNBT ? element : DoubleNBT.func_229684_a_((double)((NumberNBT)element).func_150286_g())).collect(Collectors.toCollection(() -> listNBT));
            } else if (this.desiredClass == ByteArrayNBT.class) {
                for (INBT element2 : this.elements) {
                    if (element2 instanceof ByteArrayNBT) {
                        listNBT.add((Object)element2);
                        continue;
                    }
                    if (!(element2 instanceof CompoundNBT) && !(element2 instanceof ListNBT)) continue;
                    listNBT.add((Object)new ByteArrayNBT(new byte[0]));
                }
            } else if (this.desiredClass == IntArrayNBT.class) {
                for (INBT element3 : this.elements) {
                    if (element3 instanceof IntArrayNBT) {
                        listNBT.add((Object)element3);
                        continue;
                    }
                    if (element3 instanceof ByteArrayNBT) {
                        byte[] values = ((ByteArrayNBT)element3).func_150292_c();
                        listNBT.add((Object)new IntArrayNBT(IntStream.range(0, values.length).map(i -> values[i]).toArray()));
                        continue;
                    }
                    if (element3 instanceof CompoundNBT) {
                        listNBT.add((Object)new IntArrayNBT(new int[0]));
                        continue;
                    }
                    if (!(element3 instanceof ListNBT)) continue;
                    listNBT.add((Object)new IntArrayNBT(((ListNBT)element3).stream().mapToInt(nbt -> ((ShortNBT)nbt).func_150287_d()).toArray()));
                }
            } else if (this.desiredClass == LongArrayNBT.class) {
                for (INBT element4 : this.elements) {
                    if (element4 instanceof LongArrayNBT) {
                        listNBT.add((Object)element4);
                        continue;
                    }
                    if (element4 instanceof IntArrayNBT) {
                        listNBT.add((Object)new LongArrayNBT(Arrays.stream(((IntArrayNBT)element4).func_150302_c()).asLongStream().toArray()));
                        continue;
                    }
                    if (element4 instanceof ByteArrayNBT) {
                        byte[] values = ((ByteArrayNBT)element4).func_150292_c();
                        listNBT.add((Object)new LongArrayNBT(IntStream.range(0, values.length).map(i -> values[i]).asLongStream().toArray()));
                        continue;
                    }
                    if (element4 instanceof CompoundNBT) {
                        listNBT.add((Object)new LongArrayNBT(new long[0]));
                        continue;
                    }
                    if (!(element4 instanceof ListNBT)) continue;
                    listNBT.add((Object)new LongArrayNBT(((ListNBT)element4).stream().mapToLong(nbt -> ((ShortNBT)nbt).func_150291_c()).toArray()));
                }
            } else if (this.desiredClass == ListNBT.class) {
                for (INBT element5 : this.elements) {
                    if (element5 instanceof ListNBT) {
                        listNBT.add((Object)element5);
                        continue;
                    }
                    if (element5 instanceof CompoundNBT) {
                        listNBT.add((Object)new ListNBT());
                        continue;
                    }
                    if (!(element5 instanceof CollectionNBT)) continue;
                    ListNBT byteList = new ListNBT();
                    byteList.addAll((Collection)((CollectionNBT)element5));
                    listNBT.add((Object)byteList);
                }
            } else {
                Collections.addAll(listNBT, this.elements);
            }
            return listNBT;
        }

        private static boolean validUpcast(Class<? extends INBT> argument, Class<? extends INBT> target) {
            if (argument == ByteNBT.class) {
                return target == ShortNBT.class || target == IntNBT.class || target == LongNBT.class || target == FloatNBT.class || target == DoubleNBT.class;
            }
            if (argument == ShortNBT.class) {
                return target == IntNBT.class || target == LongNBT.class || target == FloatNBT.class || target == DoubleNBT.class;
            }
            if (argument == IntNBT.class) {
                return target == LongNBT.class || target == FloatNBT.class || target == DoubleNBT.class;
            }
            if (argument == LongNBT.class) {
                return target == FloatNBT.class || target == DoubleNBT.class;
            }
            if (argument == FloatNBT.class) {
                return target == DoubleNBT.class;
            }
            return false;
        }
    }

    private static class ArrayElementValidator
    implements BiFunction<Integer, Object, Boolean> {
        private final DoublePredicate rangeValidator;
        private final BiConsumer<Integer, Double> consumeValue;
        private final int expectedType;

        public ArrayElementValidator(DoublePredicate rangeValidator, BiConsumer<Integer, Double> consumeValue, int expectedType) {
            this.rangeValidator = rangeValidator;
            this.consumeValue = consumeValue;
            this.expectedType = expectedType;
        }

        @Override
        public Boolean apply(Integer key, Object value) {
            Map map;
            if (value instanceof Double) {
                double v = (Double)value;
                if (Double.isFinite(v) && this.rangeValidator.test(v)) {
                    this.consumeValue.accept(key, v);
                    return true;
                }
            } else if (value instanceof Map && (map = (Map)value).size() == 2) {
                Object hintValue = map.get(TYPE_HINT_VALUE_KEY);
                Object typeHintRaw = map.get(CCArgumentWrapper.TYPE_HINT_KEY);
                if (hintValue != null && typeHintRaw instanceof Double && (Double)typeHintRaw == (double)this.expectedType) {
                    return this.apply(key, hintValue);
                }
            }
            return false;
        }
    }
}

