/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.sps;

import java.util.List;
import mekanism.api.math.FloatingLong;
import mekanism.common.content.sps.SPSMultiblockData;
import mekanism.common.lib.multiblock.MultiblockCache;
import mekanism.common.util.NBTUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;

public class SPSCache
extends MultiblockCache<SPSMultiblockData> {
    private double progress;
    private int inputProcessed;
    private boolean couldOperate;
    private FloatingLong receivedEnergy = FloatingLong.ZERO;
    private double lastProcessed;

    @Override
    public void merge(MultiblockCache<SPSMultiblockData> mergeCache, List<ItemStack> rejectedItems) {
        super.merge(mergeCache, rejectedItems);
        this.progress += ((SPSCache)mergeCache).progress;
        this.inputProcessed += ((SPSCache)mergeCache).inputProcessed;
        this.couldOperate |= ((SPSCache)mergeCache).couldOperate;
        this.receivedEnergy = this.receivedEnergy.add(((SPSCache)mergeCache).receivedEnergy);
        this.lastProcessed = Math.max(this.lastProcessed, ((SPSCache)mergeCache).lastProcessed);
    }

    @Override
    public void apply(SPSMultiblockData data) {
        super.apply(data);
        data.progress = this.progress;
        data.inputProcessed = this.inputProcessed;
        data.couldOperate = this.couldOperate;
        data.receivedEnergy = this.receivedEnergy;
        data.lastProcessed = this.lastProcessed;
    }

    @Override
    public void sync(SPSMultiblockData data) {
        super.sync(data);
        this.progress = data.progress;
        this.inputProcessed = data.inputProcessed;
        this.couldOperate = data.couldOperate;
        this.receivedEnergy = data.receivedEnergy;
        this.lastProcessed = data.lastProcessed;
    }

    @Override
    public void load(CompoundNBT nbtTags) {
        super.load(nbtTags);
        NBTUtils.setDoubleIfPresent(nbtTags, "progress", val -> {
            this.progress = val;
        });
        NBTUtils.setIntIfPresent(nbtTags, "processed", val -> {
            this.inputProcessed = val;
        });
        NBTUtils.setBooleanIfPresent(nbtTags, "couldOperate", val -> {
            this.couldOperate = val;
        });
        NBTUtils.setFloatingLongIfPresent(nbtTags, "energyUsage", val -> {
            this.receivedEnergy = val;
        });
        NBTUtils.setDoubleIfPresent(nbtTags, "lastProcessed", val -> {
            this.lastProcessed = val;
        });
    }

    @Override
    public void save(CompoundNBT nbtTags) {
        super.save(nbtTags);
        nbtTags.func_74780_a("progress", this.progress);
        nbtTags.func_74768_a("processed", this.inputProcessed);
        nbtTags.func_74757_a("couldOperate", this.couldOperate);
        nbtTags.func_74778_a("energyUsage", this.receivedEnergy.toString());
        nbtTags.func_74780_a("lastProcessed", this.lastProcessed);
    }
}

