/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.network.transmitter;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.providers.IBlockProvider;
import mekanism.api.text.EnumColor;
import mekanism.common.MekanismLang;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.content.network.InventoryNetwork;
import mekanism.common.content.network.transmitter.IUpgradeableTransmitter;
import mekanism.common.content.network.transmitter.LogisticalTransporterBase;
import mekanism.common.content.transporter.PathfinderCache;
import mekanism.common.content.transporter.TransporterStack;
import mekanism.common.tier.TransporterTier;
import mekanism.common.tile.transmitter.TileEntityTransmitter;
import mekanism.common.upgrade.transmitter.LogisticalTransporterUpgradeData;
import mekanism.common.upgrade.transmitter.TransmitterUpgradeData;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NBTUtils;
import mekanism.common.util.TransporterUtils;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Util;

public class LogisticalTransporter
extends LogisticalTransporterBase
implements IUpgradeableTransmitter<LogisticalTransporterUpgradeData> {
    private EnumColor color;

    public LogisticalTransporter(IBlockProvider blockProvider, TileEntityTransmitter tile) {
        super(tile, Attribute.getTier(blockProvider, TransporterTier.class));
    }

    @Override
    public TransporterTier getTier() {
        return this.tier;
    }

    @Override
    public EnumColor getColor() {
        return this.color;
    }

    public void setColor(EnumColor c) {
        this.color = c;
    }

    @Override
    public ActionResultType onConfigure(PlayerEntity player, Direction side) {
        TransporterUtils.incrementColor(this);
        PathfinderCache.onChanged((InventoryNetwork)this.getTransmitterNetwork());
        this.getTransmitterTile().sendUpdatePacket();
        EnumColor color = this.getColor();
        player.func_145747_a(MekanismUtils.logFormat(MekanismLang.TOGGLE_COLOR.translate(color == null ? MekanismLang.NONE : color.getColoredName())), Util.field_240973_b_);
        return ActionResultType.SUCCESS;
    }

    @Override
    public ActionResultType onRightClick(PlayerEntity player, Direction side) {
        EnumColor color = this.getColor();
        player.func_145747_a(MekanismUtils.logFormat(MekanismLang.CURRENT_COLOR.translate(color == null ? MekanismLang.NONE : color.getColoredName())), Util.field_240973_b_);
        return super.onRightClick(player, side);
    }

    @Override
    @Nullable
    public LogisticalTransporterUpgradeData getUpgradeData() {
        return new LogisticalTransporterUpgradeData(this.redstoneReactive, this.getConnectionTypesRaw(), this.getColor(), (Int2ObjectMap<TransporterStack>)this.transit, (Int2ObjectMap<TransporterStack>)this.needsSync, this.nextId, this.delay, this.delayCount);
    }

    @Override
    public boolean dataTypeMatches(@Nonnull TransmitterUpgradeData data) {
        return data instanceof LogisticalTransporterUpgradeData;
    }

    @Override
    public void parseUpgradeData(@Nonnull LogisticalTransporterUpgradeData data) {
        this.redstoneReactive = data.redstoneReactive;
        this.setConnectionTypesRaw(data.connectionTypes);
        this.setColor(data.color);
        this.transit.putAll(data.transit);
        this.needsSync.putAll(data.needsSync);
        this.nextId = data.nextId;
        this.delay = data.delay;
        this.delayCount = data.delayCount;
    }

    @Override
    protected void readFromNBT(CompoundNBT nbtTags) {
        super.readFromNBT(nbtTags);
        NBTUtils.setEnumIfPresent(nbtTags, "color", TransporterUtils::readColor, this::setColor);
    }

    @Override
    public void writeToNBT(CompoundNBT nbtTags) {
        super.writeToNBT(nbtTags);
        nbtTags.func_74768_a("color", TransporterUtils.getColorIndex(this.getColor()));
    }

    @Override
    @Nonnull
    public CompoundNBT getReducedUpdateTag(CompoundNBT updateTag) {
        updateTag = super.getReducedUpdateTag(updateTag);
        updateTag.func_74768_a("color", TransporterUtils.getColorIndex(this.getColor()));
        return updateTag;
    }

    @Override
    public void handleUpdateTag(@Nonnull CompoundNBT tag) {
        super.handleUpdateTag(tag);
        NBTUtils.setEnumIfPresent(tag, "color", TransporterUtils::readColor, this::setColor);
    }
}

