/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.network.distribution;

import java.util.Collection;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.math.FloatingLong;
import mekanism.common.lib.distribution.SplitInfo;
import mekanism.common.lib.distribution.Target;

public class EnergySaveTarget
extends Target<SaveHandler, FloatingLong, FloatingLong> {
    public EnergySaveTarget() {
    }

    public EnergySaveTarget(Collection<SaveHandler> allHandlers) {
        super(allHandlers);
    }

    public EnergySaveTarget(int expectedSize) {
        super(expectedSize);
    }

    @Override
    protected void acceptAmount(SaveHandler handler, SplitInfo<FloatingLong> splitInfo, FloatingLong amount) {
        handler.acceptAmount(splitInfo, amount);
    }

    @Override
    protected FloatingLong simulate(SaveHandler handler, FloatingLong energyToSend) {
        return handler.simulate(energyToSend);
    }

    public void save() {
        for (SaveHandler handler : this.handlers) {
            handler.save();
        }
    }

    public void addDelegate(IEnergyContainer delegate) {
        this.addHandler(new SaveHandler(delegate));
    }

    @ParametersAreNonnullByDefault
    @MethodsReturnNonnullByDefault
    public static class SaveHandler {
        private final IEnergyContainer delegate;
        private FloatingLong currentStored = FloatingLong.ZERO;

        public SaveHandler(IEnergyContainer delegate) {
            this.delegate = delegate;
        }

        protected void acceptAmount(SplitInfo<FloatingLong> splitInfo, FloatingLong amount) {
            amount = amount.min(this.delegate.getMaxEnergy().subtract(this.currentStored));
            this.currentStored = this.currentStored.plusEqual(amount);
            splitInfo.send(amount);
        }

        protected FloatingLong simulate(FloatingLong energyToSend) {
            return energyToSend.copy().min(this.delegate.getMaxEnergy().subtract(this.currentStored));
        }

        protected void save() {
            this.delegate.setEnergy(this.currentStored);
        }
    }
}

