/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.miner;

import mekanism.common.base.TagCache;
import mekanism.common.content.filter.FilterType;
import mekanism.common.content.filter.ITagFilter;
import mekanism.common.content.miner.MinerFilter;
import mekanism.common.lib.WildcardMatcher;
import mekanism.common.network.BasePacketHandler;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;

public class MinerTagFilter
extends MinerFilter<MinerTagFilter>
implements ITagFilter<MinerTagFilter> {
    private String tagName;

    public MinerTagFilter(String tagName) {
        this.tagName = tagName;
    }

    public MinerTagFilter() {
    }

    public MinerTagFilter(MinerTagFilter filter) {
        super(filter);
        this.tagName = filter.tagName;
    }

    @Override
    public boolean canFilter(BlockState state) {
        return state.func_177230_c().getTags().stream().anyMatch(tag -> WildcardMatcher.matches(this.tagName, tag.toString()));
    }

    @Override
    public boolean hasBlacklistedElement() {
        return TagCache.tagHasMinerBlacklisted(this.tagName);
    }

    @Override
    public CompoundNBT write(CompoundNBT nbtTags) {
        super.write(nbtTags);
        nbtTags.func_74778_a("tagName", this.tagName);
        return nbtTags;
    }

    @Override
    public void read(CompoundNBT nbtTags) {
        super.read(nbtTags);
        this.tagName = nbtTags.func_74779_i("tagName");
    }

    @Override
    public void write(PacketBuffer buffer) {
        super.write(buffer);
        buffer.func_180714_a(this.tagName);
    }

    @Override
    public void read(PacketBuffer dataStream) {
        super.read(dataStream);
        this.tagName = BasePacketHandler.readString(dataStream);
    }

    @Override
    public int hashCode() {
        int code = super.hashCode();
        code = 31 * code + this.tagName.hashCode();
        return code;
    }

    @Override
    public boolean equals(Object filter) {
        return super.equals(filter) && filter instanceof MinerTagFilter && ((MinerTagFilter)filter).tagName.equals(this.tagName);
    }

    @Override
    public MinerTagFilter clone() {
        return new MinerTagFilter(this);
    }

    @Override
    public FilterType getFilterType() {
        return FilterType.MINER_TAG_FILTER;
    }

    @Override
    public void setTagName(String name) {
        this.tagName = name;
    }

    @Override
    public String getTagName() {
        return this.tagName;
    }
}

