/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.gear.mekasuit;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.api.IIncrementalEnum;
import mekanism.api.gear.ICustomModule;
import mekanism.api.gear.IModule;
import mekanism.api.gear.config.IModuleConfigItem;
import mekanism.api.gear.config.ModuleConfigItemCreator;
import mekanism.api.gear.config.ModuleEnumData;
import mekanism.api.math.FloatingLong;
import mekanism.api.math.MathUtils;
import mekanism.api.text.IHasTextComponent;
import mekanism.api.text.TextComponentUtil;
import mekanism.common.MekanismLang;
import mekanism.common.config.MekanismConfig;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;

@ParametersAreNonnullByDefault
public class ModuleLocomotiveBoostingUnit
implements ICustomModule<ModuleLocomotiveBoostingUnit> {
    private IModuleConfigItem<SprintBoost> sprintBoost;

    @Override
    public void init(IModule<ModuleLocomotiveBoostingUnit> module, ModuleConfigItemCreator configItemCreator) {
        this.sprintBoost = configItemCreator.createConfigItem("sprint_boost", MekanismLang.MODULE_SPRINT_BOOST, new ModuleEnumData<SprintBoost>(SprintBoost.class, module.getInstalledCount() + 1, SprintBoost.LOW));
    }

    @Override
    public void changeMode(IModule<ModuleLocomotiveBoostingUnit> module, PlayerEntity player, ItemStack stack, int shift, boolean displayChangeMessage) {
        if (module.isEnabled()) {
            SprintBoost newMode = this.sprintBoost.get().adjust(shift, v -> v.ordinal() < module.getInstalledCount() + 1);
            if (this.sprintBoost.get() != newMode) {
                this.sprintBoost.set(newMode);
                if (displayChangeMessage) {
                    module.displayModeChange(player, (ITextComponent)MekanismLang.MODULE_SPRINT_BOOST.translate(new Object[0]), newMode);
                }
            }
        }
    }

    @Override
    public void tickServer(IModule<ModuleLocomotiveBoostingUnit> module, PlayerEntity player) {
        if (this.tick(module, player)) {
            module.useEnergy((LivingEntity)player, ((FloatingLong)MekanismConfig.gear.mekaSuitEnergyUsageSprintBoost.get()).multiply(this.getBoost() / 0.1f));
        }
    }

    @Override
    public void tickClient(IModule<ModuleLocomotiveBoostingUnit> module, PlayerEntity player) {
        this.tick(module, player);
    }

    private boolean tick(IModule<ModuleLocomotiveBoostingUnit> module, PlayerEntity player) {
        if (this.canFunction(module, player)) {
            float boost = this.getBoost();
            if (!player.func_233570_aj_()) {
                boost /= 5.0f;
            }
            if (player.func_70090_H()) {
                boost /= 5.0f;
            }
            player.func_213309_a(boost, new Vector3d(0.0, 0.0, 1.0));
            return true;
        }
        return false;
    }

    public boolean canFunction(IModule<ModuleLocomotiveBoostingUnit> module, PlayerEntity player) {
        return !player.func_184613_cA() && player.func_70051_ag() && module.canUseEnergy((LivingEntity)player, ((FloatingLong)MekanismConfig.gear.mekaSuitEnergyUsageSprintBoost.get()).multiply(this.getBoost() / 0.1f));
    }

    public float getBoost() {
        return this.sprintBoost.get().getBoost();
    }

    public static enum SprintBoost implements IHasTextComponent,
    IIncrementalEnum<SprintBoost>
    {
        OFF(0.0f),
        LOW(0.05f),
        MED(0.1f),
        HIGH(0.25f),
        ULTRA(0.5f);

        private static final SprintBoost[] MODES;
        private final float boost;
        private final ITextComponent label;

        private SprintBoost(float boost) {
            this.boost = boost;
            this.label = TextComponentUtil.getString(Float.toString(boost));
        }

        @Override
        @Nonnull
        public SprintBoost byIndex(int index) {
            return MathUtils.getByIndexMod(MODES, index);
        }

        @Override
        public ITextComponent getTextComponent() {
            return this.label;
        }

        public float getBoost() {
            return this.boost;
        }

        static {
            MODES = SprintBoost.values();
        }
    }
}

