/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.config.value;

import java.util.HashSet;
import java.util.Set;
import mekanism.common.Mekanism;
import mekanism.common.config.IMekanismConfig;
import net.minecraftforge.common.ForgeConfigSpec;

public abstract class CachedValue<T> {
    protected final ForgeConfigSpec.ConfigValue<T> internal;
    private Set<IConfigValueInvalidationListener> invalidationListeners;

    protected CachedValue(IMekanismConfig config, ForgeConfigSpec.ConfigValue<T> internal) {
        this.internal = internal;
        config.addCachedValue(this);
    }

    public boolean hasInvalidationListeners() {
        return this.invalidationListeners != null && !this.invalidationListeners.isEmpty();
    }

    public void addInvalidationListener(IConfigValueInvalidationListener listener) {
        if (this.invalidationListeners == null) {
            this.invalidationListeners = new HashSet<IConfigValueInvalidationListener>();
        }
        if (!this.invalidationListeners.add(listener)) {
            Mekanism.logger.warn("Duplicate invalidation listener added");
        }
    }

    public void removeInvalidationListener(IConfigValueInvalidationListener listener) {
        if (this.invalidationListeners == null) {
            Mekanism.logger.warn("Unable to remove specified invalidation listener, no invalidation listeners have been added.");
        } else if (!this.invalidationListeners.remove(listener)) {
            Mekanism.logger.warn("Unable to remove specified invalidation listener.");
        }
    }

    protected abstract boolean clearCachedValue(boolean var1);

    public void clearCache() {
        if (this.clearCachedValue(this.hasInvalidationListeners())) {
            this.invalidationListeners.forEach(Runnable::run);
        }
    }

    @FunctionalInterface
    public static interface IConfigValueInvalidationListener
    extends Runnable {
    }
}

