/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.config.value;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.common.config.IMekanismConfig;
import mekanism.common.config.value.CachedValue;
import net.minecraftforge.common.ForgeConfigSpec;

public abstract class CachedResolvableConfigValue<TYPE, REAL>
extends CachedValue<REAL> {
    @Nullable
    private TYPE cachedValue;

    protected CachedResolvableConfigValue(IMekanismConfig config, ForgeConfigSpec.ConfigValue<REAL> internal) {
        super(config, internal);
    }

    protected abstract TYPE resolve(REAL var1);

    protected abstract REAL encode(TYPE var1);

    @Nonnull
    public TYPE get() {
        if (this.cachedValue == null) {
            this.cachedValue = this.resolve(this.internal.get());
        }
        return this.cachedValue;
    }

    public void set(TYPE value) {
        this.internal.set(this.encode(value));
        this.cachedValue = value;
    }

    @Override
    protected boolean clearCachedValue(boolean checkChanged) {
        if (this.cachedValue == null) {
            return false;
        }
        TYPE oldCachedValue = this.cachedValue;
        this.cachedValue = null;
        return checkChanged && !oldCachedValue.equals(this.get());
    }
}

