/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.capabilities.radiation.item;

import java.util.Objects;
import java.util.function.ToDoubleFunction;
import mekanism.api.radiation.capability.IRadiationShielding;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.CapabilityCache;
import mekanism.common.capabilities.ItemCapabilityWrapper;
import mekanism.common.capabilities.resolver.BasicCapabilityResolver;
import net.minecraft.item.ItemStack;

public class RadiationShieldingHandler
extends ItemCapabilityWrapper.ItemCapability
implements IRadiationShielding {
    private final ToDoubleFunction<ItemStack> shieldingFunction;

    public static RadiationShieldingHandler create(ToDoubleFunction<ItemStack> shieldingFunction) {
        Objects.requireNonNull(shieldingFunction, "Shielding function cannot be null");
        return new RadiationShieldingHandler(shieldingFunction);
    }

    private RadiationShieldingHandler(ToDoubleFunction<ItemStack> shieldingFunction) {
        this.shieldingFunction = shieldingFunction;
    }

    @Override
    public double getRadiationShielding() {
        return this.shieldingFunction.applyAsDouble(this.getStack());
    }

    @Override
    protected void addCapabilityResolvers(CapabilityCache capabilityCache) {
        capabilityCache.addCapabilityResolver(BasicCapabilityResolver.constant(Capabilities.RADIATION_SHIELDING_CAPABILITY, this));
    }
}

