/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.capabilities.holder.energy;

import java.util.function.Supplier;
import javax.annotation.Nonnull;
import mekanism.api.RelativeSide;
import mekanism.api.energy.IEnergyContainer;
import mekanism.common.capabilities.holder.energy.ConfigEnergyContainerHolder;
import mekanism.common.capabilities.holder.energy.EnergyContainerHolder;
import mekanism.common.capabilities.holder.energy.IEnergyContainerHolder;
import mekanism.common.tile.component.TileComponentConfig;
import net.minecraft.util.Direction;

public class EnergyContainerHelper {
    private final IEnergyContainerHolder slotHolder;
    private boolean built;

    private EnergyContainerHelper(IEnergyContainerHolder slotHolder) {
        this.slotHolder = slotHolder;
    }

    public static EnergyContainerHelper forSide(Supplier<Direction> facingSupplier) {
        return new EnergyContainerHelper(new EnergyContainerHolder(facingSupplier));
    }

    public static EnergyContainerHelper forSideWithConfig(Supplier<Direction> facingSupplier, Supplier<TileComponentConfig> configSupplier) {
        return new EnergyContainerHelper(new ConfigEnergyContainerHolder(facingSupplier, configSupplier));
    }

    public void addContainer(@Nonnull IEnergyContainer container) {
        if (this.built) {
            throw new IllegalStateException("Builder has already built.");
        }
        if (this.slotHolder instanceof EnergyContainerHolder) {
            ((EnergyContainerHolder)this.slotHolder).addContainer(container, new RelativeSide[0]);
        } else if (this.slotHolder instanceof ConfigEnergyContainerHolder) {
            ((ConfigEnergyContainerHolder)this.slotHolder).addContainer(container);
        } else {
            throw new IllegalArgumentException("Holder does not know how to add containers");
        }
    }

    public void addContainer(@Nonnull IEnergyContainer container, RelativeSide ... sides) {
        if (this.built) {
            throw new IllegalStateException("Builder has already built.");
        }
        if (!(this.slotHolder instanceof EnergyContainerHolder)) {
            throw new IllegalArgumentException("Holder does not know how to add containers on specific sides");
        }
        ((EnergyContainerHolder)this.slotHolder).addContainer(container, sides);
    }

    public IEnergyContainerHolder build() {
        this.built = true;
        return this.slotHolder;
    }
}

