/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.block.transmitter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.common.block.BlockMekanism;
import mekanism.common.block.states.IStateFluidLoggable;
import mekanism.common.block.states.TransmitterType;
import mekanism.common.content.network.transmitter.Transmitter;
import mekanism.common.lib.transmitter.ConnectionType;
import mekanism.common.registries.MekanismItems;
import mekanism.common.tile.transmitter.TileEntityTransmitter;
import mekanism.common.util.EnumUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.MultipartUtils;
import mekanism.common.util.VoxelShapeUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public abstract class BlockTransmitter
extends BlockMekanism
implements IStateFluidLoggable {
    private static final Map<ConnectionInfo, VoxelShape> cachedShapes = new HashMap<ConnectionInfo, VoxelShape>();

    protected BlockTransmitter() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_76233_E).func_200948_a(1.0f, 6.0f));
    }

    @Nonnull
    @Deprecated
    public ActionResultType func_225533_a_(@Nonnull BlockState state, @Nonnull World world, @Nonnull BlockPos pos, PlayerEntity player, @Nonnull Hand hand, @Nonnull BlockRayTraceResult hit) {
        ItemStack stack = player.func_184586_b(hand);
        if (MekanismUtils.canUseAsWrench(stack) && player.func_225608_bj_()) {
            if (!world.field_72995_K) {
                WorldUtils.dismantleBlock(state, world, pos);
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    @Override
    public void func_180633_a(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nullable LivingEntity placer, @Nonnull ItemStack stack) {
        TileEntityTransmitter tile = WorldUtils.getTileEntity(TileEntityTransmitter.class, (IBlockReader)world, pos);
        if (tile != null) {
            tile.onAdded();
        }
    }

    @Deprecated
    public void func_220069_a(@Nonnull BlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull Block neighborBlock, @Nonnull BlockPos neighborPos, boolean isMoving) {
        TileEntityTransmitter tile = WorldUtils.getTileEntity(TileEntityTransmitter.class, (IBlockReader)world, pos);
        if (tile != null) {
            Direction side = Direction.func_176737_a((float)(neighborPos.func_177958_n() - pos.func_177958_n()), (float)(neighborPos.func_177956_o() - pos.func_177956_o()), (float)(neighborPos.func_177952_p() - pos.func_177952_p()));
            tile.onNeighborBlockChange(side);
        }
    }

    public void onNeighborChange(BlockState state, IWorldReader world, BlockPos pos, BlockPos neighbor) {
        TileEntityTransmitter tile = WorldUtils.getTileEntity(TileEntityTransmitter.class, (IBlockReader)world, pos);
        if (tile != null) {
            Direction side = Direction.func_176737_a((float)(neighbor.func_177958_n() - pos.func_177958_n()), (float)(neighbor.func_177956_o() - pos.func_177956_o()), (float)(neighbor.func_177952_p() - pos.func_177952_p()));
            tile.onNeighborTileChange(side);
        }
    }

    @Deprecated
    public boolean func_196266_a(@Nonnull BlockState state, @Nonnull IBlockReader world, @Nonnull BlockPos pos, @Nonnull PathType type) {
        return false;
    }

    @Nonnull
    @Deprecated
    public VoxelShape func_220053_a(@Nonnull BlockState state, @Nonnull IBlockReader world, @Nonnull BlockPos pos, ISelectionContext context) {
        if (!context.func_216375_a((Item)MekanismItems.CONFIGURATOR.getItem())) {
            return this.getRealShape(world, pos);
        }
        if (context.getEntity() == null) {
            return this.getRealShape(world, pos);
        }
        TileEntityTransmitter tile = WorldUtils.getTileEntity(TileEntityTransmitter.class, world, pos);
        if (tile == null) {
            return this.getCenter();
        }
        MultipartUtils.AdvancedRayTraceResult result = MultipartUtils.collisionRayTrace(context.getEntity(), pos, tile.getCollisionBoxes());
        if (result != null && result.valid()) {
            return result.bounds;
        }
        return this.getCenter();
    }

    @Nonnull
    @Deprecated
    public VoxelShape func_196247_c(@Nonnull BlockState state, @Nonnull IBlockReader world, @Nonnull BlockPos pos) {
        return this.getRealShape(world, pos);
    }

    @Nonnull
    @Deprecated
    public VoxelShape func_220071_b(@Nonnull BlockState state, @Nonnull IBlockReader world, @Nonnull BlockPos pos, @Nonnull ISelectionContext context) {
        return this.getRealShape(world, pos);
    }

    protected abstract VoxelShape getCenter();

    protected abstract VoxelShape getSide(ConnectionType var1, Direction var2);

    private VoxelShape getRealShape(IBlockReader world, BlockPos pos) {
        TileEntityTransmitter tile = WorldUtils.getTileEntity(TileEntityTransmitter.class, world, pos);
        if (tile == null) {
            return this.getCenter();
        }
        Transmitter<?, ?, ?> transmitter = tile.getTransmitter();
        ConnectionType[] connectionTypes = new ConnectionType[transmitter.getConnectionTypesRaw().length];
        for (int i = 0; i < EnumUtils.DIRECTIONS.length; ++i) {
            connectionTypes[i] = transmitter.getConnectionType(EnumUtils.DIRECTIONS[i]);
        }
        ConnectionInfo info = new ConnectionInfo(tile.getTransmitterType().getSize(), connectionTypes);
        if (cachedShapes.containsKey(info)) {
            return cachedShapes.get(info);
        }
        ArrayList<VoxelShape> shapes = new ArrayList<VoxelShape>();
        for (Direction side : EnumUtils.DIRECTIONS) {
            ConnectionType connectionType = connectionTypes[side.ordinal()];
            if (connectionType == ConnectionType.NONE) continue;
            shapes.add(this.getSide(connectionType, side));
        }
        VoxelShape center = this.getCenter();
        if (shapes.isEmpty()) {
            cachedShapes.put(info, center);
            return center;
        }
        shapes.add(center);
        VoxelShape shape = VoxelShapeUtils.combine(shapes);
        cachedShapes.put(info, shape);
        return shape;
    }

    private static class ConnectionInfo {
        private final TransmitterType.Size size;
        private final ConnectionType[] connectionTypes;

        private ConnectionInfo(TransmitterType.Size size, ConnectionType[] connectionTypes) {
            this.size = size;
            this.connectionTypes = connectionTypes;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof ConnectionInfo) {
                ConnectionInfo other = (ConnectionInfo)o;
                return this.size == other.size && Arrays.equals(this.connectionTypes, other.connectionTypes);
            }
            return false;
        }

        public int hashCode() {
            int result = Objects.hash(new Object[]{this.size});
            result = 31 * result + Arrays.hashCode(this.connectionTypes);
            return result;
        }
    }
}

