/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.block.states;

import java.util.Arrays;
import javax.annotation.Nonnull;
import mekanism.common.block.states.BlockStateHelper;
import net.minecraft.block.BlockState;
import net.minecraft.block.IBucketPickupHandler;
import net.minecraft.block.ILiquidContainer;
import net.minecraft.fluid.FlowingFluid;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;

public interface IStateFluidLoggable
extends IBucketPickupHandler,
ILiquidContainer {
    public static final Fluid[] VANILLA_FLUIDS = new Fluid[]{Fluids.field_204546_a, Fluids.field_204547_b};

    default public boolean isValidFluid(@Nonnull Fluid fluid) {
        return Arrays.stream(this.getSupportedFluids()).anyMatch(supportedFluid -> supportedFluid == fluid);
    }

    @Nonnull
    default public Fluid[] getSupportedFluids() {
        return VANILLA_FLUIDS;
    }

    @Nonnull
    default public IntegerProperty getFluidLoggedProperty() {
        return BlockStateHelper.FLUID_LOGGED;
    }

    @Nonnull
    default public FluidState getFluid(@Nonnull BlockState state) {
        int fluidLogged = (Integer)state.func_177229_b((Property)this.getFluidLoggedProperty());
        if (fluidLogged > 0) {
            Fluid fluid = this.getSupportedFluids()[fluidLogged - 1];
            if (fluid instanceof FlowingFluid) {
                return ((FlowingFluid)fluid).func_207204_a(false);
            }
            return fluid.func_207188_f();
        }
        return Fluids.field_204541_a.func_207188_f();
    }

    default public void updateFluids(@Nonnull BlockState state, @Nonnull IWorld world, @Nonnull BlockPos currentPos) {
        int fluidLogged = (Integer)state.func_177229_b((Property)this.getFluidLoggedProperty());
        if (fluidLogged > 0) {
            Fluid fluid = this.getSupportedFluids()[fluidLogged - 1];
            world.func_205219_F_().func_205360_a(currentPos, (Object)fluid, fluid.func_205569_a((IWorldReader)world));
        }
    }

    default public boolean func_204510_a(@Nonnull IBlockReader world, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull Fluid fluid) {
        return (Integer)state.func_177229_b((Property)this.getFluidLoggedProperty()) == 0 && this.isValidFluid(fluid);
    }

    default public int getSupportedFluidPropertyIndex(@Nonnull Fluid fluid) {
        int fluidLogged = 0;
        Fluid[] supportedFluids = this.getSupportedFluids();
        for (int i = 0; i < supportedFluids.length; ++i) {
            if (supportedFluids[i] != fluid) continue;
            fluidLogged = i + 1;
            break;
        }
        return fluidLogged;
    }

    default public boolean func_204509_a(@Nonnull IWorld world, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull FluidState fluidState) {
        Fluid fluid = fluidState.func_206886_c();
        if (this.func_204510_a((IBlockReader)world, pos, state, fluid)) {
            if (!world.func_201670_d()) {
                world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)this.getFluidLoggedProperty(), (Comparable)Integer.valueOf(this.getSupportedFluidPropertyIndex(fluid))), 3);
                world.func_205219_F_().func_205360_a(pos, (Object)fluid, fluid.func_205569_a((IWorldReader)world));
            }
            return true;
        }
        return false;
    }

    @Nonnull
    default public Fluid func_204508_a(@Nonnull IWorld world, @Nonnull BlockPos pos, @Nonnull BlockState state) {
        IntegerProperty fluidLoggedProperty = this.getFluidLoggedProperty();
        int fluidLogged = (Integer)state.func_177229_b((Property)fluidLoggedProperty);
        if (fluidLogged > 0) {
            world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)fluidLoggedProperty, (Comparable)Integer.valueOf(0)), 3);
            return this.getSupportedFluids()[fluidLogged - 1];
        }
        return Fluids.field_204541_a;
    }
}

