/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.transmitter;

import com.mojang.blaze3d.matrix.MatrixStack;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.api.text.EnumColor;
import mekanism.client.model.ModelTransporterBox;
import mekanism.client.render.MekanismRenderer;
import mekanism.client.render.RenderResizableCuboid;
import mekanism.client.render.transmitter.RenderTransmitterBase;
import mekanism.common.content.network.transmitter.DiversionTransporter;
import mekanism.common.content.network.transmitter.LogisticalTransporterBase;
import mekanism.common.content.transporter.TransporterStack;
import mekanism.common.item.ItemConfigurator;
import mekanism.common.lib.inventory.HashedItem;
import mekanism.common.tile.transmitter.TileEntityLogisticalTransporterBase;
import mekanism.common.util.EnumUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.TransporterUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.Atlases;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.profiler.IProfiler;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

@ParametersAreNonnullByDefault
public class RenderLogisticalTransporter
extends RenderTransmitterBase<TileEntityLogisticalTransporterBase> {
    private static final Map<Direction, MekanismRenderer.Model3D> cachedOverlays = new EnumMap<Direction, MekanismRenderer.Model3D>(Direction.class);
    private static MekanismRenderer.Model3D.SpriteInfo gunpowderIcon;
    private static MekanismRenderer.Model3D.SpriteInfo torchOffIcon;
    private static MekanismRenderer.Model3D.SpriteInfo torchOnIcon;
    private final ModelTransporterBox modelBox = new ModelTransporterBox();
    private final LazyItemRenderer itemRenderer = new LazyItemRenderer();

    public RenderLogisticalTransporter(TileEntityRendererDispatcher renderer) {
        super(renderer);
    }

    public static void onStitch(AtlasTexture map) {
        cachedOverlays.clear();
        gunpowderIcon = new MekanismRenderer.Model3D.SpriteInfo(map.func_195424_a(new ResourceLocation("minecraft", "item/gunpowder")), 16);
        torchOffIcon = new MekanismRenderer.Model3D.SpriteInfo(map.func_195424_a(new ResourceLocation("minecraft", "block/redstone_torch_off")), 16);
        torchOnIcon = new MekanismRenderer.Model3D.SpriteInfo(map.func_195424_a(new ResourceLocation("minecraft", "block/redstone_torch")), 16);
    }

    @Override
    protected void render(TileEntityLogisticalTransporterBase tile, float partialTick, MatrixStack matrix, IRenderTypeBuffer renderer, int light, int overlayLight, IProfiler profiler) {
        LogisticalTransporterBase transporter = tile.getTransmitter();
        Collection<TransporterStack> inTransit = transporter.getTransit();
        BlockPos pos = tile.func_174877_v();
        if (!inTransit.isEmpty()) {
            matrix.func_227860_a_();
            this.itemRenderer.init(tile.func_145831_w(), pos);
            float partial = partialTick * (float)transporter.tier.getSpeed();
            Collection<TransporterStack> reducedTransit = this.getReducedTransit(inTransit);
            for (TransporterStack stack : reducedTransit) {
                float[] stackPos = TransporterUtils.getStackPosition(transporter, stack, partial);
                matrix.func_227860_a_();
                matrix.func_227861_a_((double)stackPos[0], (double)stackPos[1], (double)stackPos[2]);
                matrix.func_227862_a_(0.75f, 0.75f, 0.75f);
                this.itemRenderer.renderAsStack(matrix, renderer, stack.itemStack);
                matrix.func_227865_b_();
                if (stack.color == null) continue;
                this.modelBox.render(matrix, renderer, 0xF000F0, overlayLight, stackPos[0], stackPos[1], stackPos[2], stack.color);
            }
            matrix.func_227865_b_();
        }
        if (transporter instanceof DiversionTransporter) {
            BlockRayTraceResult rayTraceResult;
            ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
            ItemStack itemStack = player.field_71071_by.func_70448_g();
            if (!itemStack.func_190926_b() && itemStack.func_77973_b() instanceof ItemConfigurator && !(rayTraceResult = MekanismUtils.rayTrace((PlayerEntity)player)).func_216346_c().equals((Object)RayTraceResult.Type.MISS) && rayTraceResult.func_216350_a().equals((Object)pos)) {
                Direction side = tile.getSideLookingAt((PlayerEntity)player, rayTraceResult.func_216354_b());
                matrix.func_227860_a_();
                matrix.func_227862_a_(0.5f, 0.5f, 0.5f);
                matrix.func_227861_a_(0.5, 0.5, 0.5);
                MekanismRenderer.renderObject(this.getOverlayModel((DiversionTransporter)transporter, side), matrix, renderer.getBuffer(Atlases.func_228785_j_()), MekanismRenderer.getColorARGB(255, 255, 255, 0.8f), 0xF000F0, overlayLight, RenderResizableCuboid.FaceDisplay.FRONT);
                matrix.func_227865_b_();
            }
        }
    }

    @Override
    protected String getProfilerSection() {
        return "logisticalTransporter";
    }

    private Collection<TransporterStack> getReducedTransit(Collection<TransporterStack> inTransit) {
        ArrayList<TransporterStack> reducedTransit = new ArrayList<TransporterStack>();
        ObjectOpenHashSet information = new ObjectOpenHashSet();
        for (TransporterStack stack : inTransit) {
            if (stack == null || stack.itemStack.func_190926_b() || !information.add(new TransportInformation(stack))) continue;
            reducedTransit.add(stack);
        }
        return reducedTransit;
    }

    private MekanismRenderer.Model3D getOverlayModel(DiversionTransporter transporter, Direction side) {
        MekanismRenderer.Model3D model = cachedOverlays.computeIfAbsent(side, face -> {
            MekanismRenderer.Model3D m = new MekanismRenderer.Model3D();
            MekanismRenderer.prepSingleFaceModelSize(m, face);
            for (Direction direction : EnumUtils.DIRECTIONS) {
                m.setSideRender(direction, direction == face);
            }
            return m;
        });
        MekanismRenderer.Model3D.SpriteInfo icon = null;
        switch (transporter.modes[side.ordinal()]) {
            case DISABLED: {
                icon = gunpowderIcon;
                break;
            }
            case HIGH: {
                icon = torchOnIcon;
                break;
            }
            case LOW: {
                icon = torchOffIcon;
            }
        }
        model.setTexture(side, icon);
        return model;
    }

    private static class LazyItemRenderer {
        @Nullable
        private ItemEntity entityItem;
        @Nullable
        private EntityRenderer<? super ItemEntity> renderer;

        private LazyItemRenderer() {
        }

        public void init(World world, BlockPos pos) {
            if (this.entityItem == null) {
                this.entityItem = new ItemEntity(EntityType.field_200765_E, world);
            } else {
                this.entityItem.field_70170_p = world;
            }
            this.entityItem.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
            this.entityItem.field_70292_b = 0;
        }

        private void renderAsStack(MatrixStack matrix, IRenderTypeBuffer buffer, ItemStack stack) {
            if (this.entityItem != null) {
                if (this.renderer == null) {
                    this.renderer = Minecraft.func_71410_x().func_175598_ae().func_78713_a((Entity)this.entityItem);
                }
                this.entityItem.func_92058_a(stack);
                this.renderer.func_225623_a_((Entity)this.entityItem, 0.0f, 0.0f, matrix, buffer, 0xF000F0);
            }
        }
    }

    private static class TransportInformation {
        @Nullable
        private final EnumColor color;
        private final HashedItem item;
        private final int progress;

        private TransportInformation(TransporterStack transporterStack) {
            this.progress = transporterStack.progress;
            this.color = transporterStack.color;
            this.item = HashedItem.create(transporterStack.itemStack);
        }

        public int hashCode() {
            int code = 1;
            code = 31 * code + this.progress;
            code = 31 * code + this.item.hashCode();
            if (this.color != null) {
                code = 31 * code + this.color.hashCode();
            }
            return code;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof TransportInformation) {
                TransportInformation other = (TransportInformation)obj;
                return this.progress == other.progress && this.color == other.color && this.item.equals(other.item);
            }
            return false;
        }
    }
}

