/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.tileentity;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.chemical.pigment.PigmentStack;
import mekanism.api.chemical.slurry.SlurryStack;
import mekanism.client.render.MekanismRenderer;
import mekanism.client.render.ModelRenderer;
import mekanism.client.render.data.ChemicalRenderData;
import mekanism.client.render.data.FluidRenderData;
import mekanism.client.render.data.RenderData;
import mekanism.client.render.tileentity.MekanismTileEntityRenderer;
import mekanism.common.content.tank.TankMultiblockData;
import mekanism.common.tile.multiblock.TileEntityDynamicTank;
import net.minecraft.client.renderer.Atlases;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.profiler.IProfiler;
import net.minecraft.util.math.BlockPos;

@ParametersAreNonnullByDefault
public class RenderDynamicTank
extends MekanismTileEntityRenderer<TileEntityDynamicTank> {
    public RenderDynamicTank(TileEntityRendererDispatcher renderer) {
        super(renderer);
    }

    @Override
    protected void render(TileEntityDynamicTank tile, float partialTick, MatrixStack matrix, IRenderTypeBuffer renderer, int light, int overlayLight, IProfiler profiler) {
        RenderData data;
        TankMultiblockData multiblock;
        if (tile.isMaster() && (multiblock = (TankMultiblockData)tile.getMultiblock()).isFormed() && multiblock.renderLocation != null && (data = this.getRenderData(multiblock)) != null) {
            data.location = multiblock.renderLocation;
            data.height = multiblock.height() - 2;
            data.length = multiblock.length();
            data.width = multiblock.width();
            matrix.func_227860_a_();
            IVertexBuilder buffer = renderer.getBuffer(Atlases.func_228785_j_());
            BlockPos pos = tile.func_174877_v();
            matrix.func_227861_a_((double)(data.location.func_177958_n() - pos.func_177958_n()), (double)(data.location.func_177956_o() - pos.func_177956_o()), (double)(data.location.func_177952_p() - pos.func_177952_p()));
            int glow = data.calculateGlowLight(MekanismRenderer.FULL_SKY_LIGHT);
            MekanismRenderer.Model3D model = ModelRenderer.getModel(data, multiblock.prevScale);
            MekanismRenderer.renderObject(model, matrix, buffer, data.getColorARGB(multiblock.prevScale), glow, overlayLight, this.getFaceDisplay(data, model));
            matrix.func_227865_b_();
            if (data instanceof FluidRenderData) {
                MekanismRenderer.renderValves(matrix, buffer, multiblock.valves, (FluidRenderData)data, pos, glow, overlayLight, this.isInsideMultiblock(data));
            }
        }
    }

    @Nullable
    private RenderData getRenderData(TankMultiblockData multiblock) {
        switch (multiblock.mergedTank.getCurrentType()) {
            case FLUID: {
                return new FluidRenderData(multiblock.getFluidTank().getFluid());
            }
            case GAS: {
                return new ChemicalRenderData.GasRenderData((GasStack)multiblock.getGasTank().getStack());
            }
            case INFUSION: {
                return new ChemicalRenderData.InfusionRenderData((InfusionStack)multiblock.getInfusionTank().getStack());
            }
            case PIGMENT: {
                return new ChemicalRenderData.PigmentRenderData((PigmentStack)multiblock.getPigmentTank().getStack());
            }
            case SLURRY: {
                return new ChemicalRenderData.SlurryRenderData((SlurryStack)multiblock.getSlurryTank().getStack());
            }
        }
        return null;
    }

    @Override
    protected String getProfilerSection() {
        return "dynamicTank";
    }

    public boolean shouldRenderOffScreen(TileEntityDynamicTank tile) {
        if (tile.isMaster()) {
            TankMultiblockData multiblock = (TankMultiblockData)tile.getMultiblock();
            return multiblock.isFormed() && !multiblock.isEmpty() && multiblock.renderLocation != null;
        }
        return false;
    }
}

