/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.entity;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.robit.RobitSkin;
import mekanism.client.RobitSpriteUploader;
import mekanism.client.model.MekanismModelCache;
import mekanism.common.Mekanism;
import mekanism.common.entity.EntityRobit;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;

public class RenderRobit
extends MobRenderer<EntityRobit, RobitModelWrapper> {
    public RenderRobit(EntityRendererManager renderManager) {
        super(renderManager, (EntityModel)new RobitModelWrapper(), 0.5f);
    }

    @Nonnull
    public ResourceLocation getTextureLocation(@Nonnull EntityRobit robit) {
        return RobitSpriteUploader.ATLAS_LOCATION;
    }

    public static class RobitModelWrapper
    extends EntityModel<EntityRobit> {
        @Nullable
        private EntityRobit robit;

        RobitModelWrapper() {
        }

        public void setupAnim(@Nonnull EntityRobit robit, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
            this.robit = robit;
        }

        public void func_225598_a_(@Nonnull MatrixStack matrix, @Nonnull IVertexBuilder builder, int light, int overlayLight, float red, float green, float blue, float alpha) {
            if (this.robit == null) {
                return;
            }
            RobitSkin skin = this.robit.getSkin();
            IBakedModel model = MekanismModelCache.INSTANCE.getRobitSkin(skin);
            if (model == null) {
                Mekanism.logger.warn("Robit with skin: {} does not have a model.", (Object)skin.getRegistryName());
            } else {
                matrix.func_227860_a_();
                matrix.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(180.0f));
                matrix.func_227861_a_(-0.5, -1.5, -0.5);
                MatrixStack.Entry last = matrix.func_227866_c_();
                for (BakedQuad quad : model.getQuads(null, null, this.robit.field_70170_p.field_73012_v, this.robit.getModelData())) {
                    builder.addVertexData(last, quad, red, green, blue, alpha, light, overlayLight);
                }
                matrix.func_227865_b_();
            }
            this.robit = null;
        }
    }
}

