/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.key;

import mekanism.client.ClientRegistrationUtil;
import mekanism.client.MekanismClient;
import mekanism.client.key.MekKeyBindingBuilder;
import mekanism.client.sound.SoundHandler;
import mekanism.common.Mekanism;
import mekanism.common.MekanismLang;
import mekanism.common.inventory.container.ModuleTweakerContainer;
import mekanism.common.item.interfaces.IModeItem;
import mekanism.common.network.to_server.PacketModeChange;
import mekanism.common.network.to_server.PacketOpenGui;
import mekanism.common.registries.MekanismSounds;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraftforge.client.settings.KeyModifier;

public class MekanismKeyHandler {
    public static final KeyBinding handModeSwitchKey = new MekKeyBindingBuilder().description(MekanismLang.KEY_HAND_MODE).conflictInGame().keyCode(78).onKeyDown((kb, isRepeat) -> {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player != null) {
            if (IModeItem.isModeItem((PlayerEntity)player, EquipmentSlotType.MAINHAND, false)) {
                Mekanism.packetHandler.sendToServer(new PacketModeChange(EquipmentSlotType.MAINHAND, player.func_225608_bj_()));
            } else if (!IModeItem.isModeItem((PlayerEntity)player, EquipmentSlotType.MAINHAND) && IModeItem.isModeItem((PlayerEntity)player, EquipmentSlotType.OFFHAND)) {
                Mekanism.packetHandler.sendToServer(new PacketModeChange(EquipmentSlotType.OFFHAND, player.func_225608_bj_()));
            }
        }
    }).build();
    public static final KeyBinding headModeSwitchKey = new MekKeyBindingBuilder().description(MekanismLang.KEY_HEAD_MODE).conflictInGame().keyCode(86).onKeyDown((kb, isRepeat) -> MekanismKeyHandler.handlePotentialModeItem(EquipmentSlotType.HEAD)).build();
    public static final KeyBinding chestModeSwitchKey = new MekKeyBindingBuilder().description(MekanismLang.KEY_CHEST_MODE).conflictInGame().keyCode(71).onKeyDown((kb, isRepeat) -> MekanismKeyHandler.handlePotentialModeItem(EquipmentSlotType.CHEST)).build();
    public static final KeyBinding legsModeSwitchKey = new MekKeyBindingBuilder().description(MekanismLang.KEY_LEGS_MODE).conflictInGame().keyCode(74).onKeyDown((kb, isRepeat) -> MekanismKeyHandler.handlePotentialModeItem(EquipmentSlotType.LEGS)).build();
    public static final KeyBinding feetModeSwitchKey = new MekKeyBindingBuilder().description(MekanismLang.KEY_FEET_MODE).conflictInGame().keyCode(66).onKeyDown((kb, isRepeat) -> MekanismKeyHandler.handlePotentialModeItem(EquipmentSlotType.FEET)).build();
    public static final KeyBinding detailsKey = new MekKeyBindingBuilder().description(MekanismLang.KEY_DETAILS_MODE).conflictInGui().keyCode(340).build();
    public static final KeyBinding descriptionKey = new MekKeyBindingBuilder().description(MekanismLang.KEY_DESCRIPTION_MODE).conflictInGui().modifier(KeyModifier.SHIFT).keyCode(78).build();
    public static final KeyBinding moduleTweakerKey = new MekKeyBindingBuilder().description(MekanismLang.KEY_MODULE_TWEAKER).conflictInGame().keyCode(92).onKeyDown((kb, isRepeat) -> {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player != null && ModuleTweakerContainer.hasTweakableItem((PlayerEntity)player)) {
            Mekanism.packetHandler.sendToServer(new PacketOpenGui(PacketOpenGui.GuiType.MODULE_TWEAKER));
        }
    }).build();
    public static final KeyBinding boostKey = new MekKeyBindingBuilder().description(MekanismLang.KEY_BOOST).conflictInGame().keyCode(341).onKeyDown((kb, isRepeat) -> MekanismClient.updateKey(kb, 1)).onKeyUp(kb -> MekanismClient.updateKey(kb, 1)).build();
    public static final KeyBinding hudKey = new MekKeyBindingBuilder().description(MekanismLang.KEY_HUD).conflictInGame().keyCode(72).onKeyDown((kb, isRepeat) -> {
        MekanismClient.renderHUD = !MekanismClient.renderHUD;
    }).build();

    public static void registerKeybindings() {
        ClientRegistrationUtil.registerKeyBindings(handModeSwitchKey, headModeSwitchKey, chestModeSwitchKey, legsModeSwitchKey, feetModeSwitchKey, detailsKey, descriptionKey, moduleTweakerKey, boostKey, hudKey);
    }

    private static void handlePotentialModeItem(EquipmentSlotType slot) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player != null && IModeItem.isModeItem((PlayerEntity)player, slot)) {
            Mekanism.packetHandler.sendToServer(new PacketModeChange(slot, player.func_225608_bj_()));
            SoundHandler.playSound(MekanismSounds.HYDRAULIC);
        }
    }
}

