/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.jei.machine;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mekanism.api.annotations.NonNull;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.math.FloatingLong;
import mekanism.api.recipes.NucleosynthesizingRecipe;
import mekanism.api.recipes.inputs.chemical.GasStackIngredient;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiInnerScreen;
import mekanism.client.gui.element.bar.GuiDynamicHorizontalRateBar;
import mekanism.client.gui.element.gauge.GaugeType;
import mekanism.client.gui.element.gauge.GuiEnergyGauge;
import mekanism.client.gui.element.gauge.GuiGasGauge;
import mekanism.client.gui.element.gauge.GuiGauge;
import mekanism.client.gui.element.slot.GuiSlot;
import mekanism.client.gui.element.slot.SlotType;
import mekanism.client.jei.BaseRecipeCategory;
import mekanism.client.jei.MekanismJEI;
import mekanism.common.MekanismLang;
import mekanism.common.inventory.container.slot.SlotOverlay;
import mekanism.common.lib.Color;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.tile.component.config.DataType;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.ingredient.IGuiIngredientGroup;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;

public class NucleosynthesizingRecipeCategory
extends BaseRecipeCategory<NucleosynthesizingRecipe> {
    private final GuiDynamicHorizontalRateBar rateBar;
    private final GuiSlot input = this.addSlot(SlotType.INPUT, 26, 40);
    private final GuiSlot extra = this.addSlot(SlotType.EXTRA, 6, 69);
    private final GuiSlot output = this.addSlot(SlotType.OUTPUT, 152, 40);
    private final GuiGauge<?> gasInput;

    public NucleosynthesizingRecipeCategory(IGuiHelper helper) {
        super(helper, MekanismBlocks.ANTIPROTONIC_NUCLEOSYNTHESIZER, 6, 18, 182, 80);
        this.addSlot(SlotType.POWER, 173, 69).with(SlotOverlay.POWER);
        this.addElement(new GuiInnerScreen(this, 45, 18, 104, 68));
        this.gasInput = this.addElement(GuiGasGauge.getDummy(GaugeType.SMALL_MED.with(DataType.INPUT), this, 5, 18));
        this.addElement(new GuiEnergyGauge(new GuiEnergyGauge.IEnergyInfoHandler(){

            @Override
            public FloatingLong getEnergy() {
                return FloatingLong.ONE;
            }

            @Override
            public FloatingLong getMaxEnergy() {
                return FloatingLong.ONE;
            }
        }, GaugeType.SMALL_MED, (IGuiWrapper)this, 172, 18));
        this.rateBar = this.addElement(new GuiDynamicHorizontalRateBar((IGuiWrapper)this, this.getBarProgressTimer(), 5, 88, 183, Color.ColorFunction.scale(Color.rgbi(60, 45, 74), Color.rgbi(100, 30, 170))));
    }

    public Class<? extends NucleosynthesizingRecipe> getRecipeClass() {
        return NucleosynthesizingRecipe.class;
    }

    public List<ITextComponent> getTooltipStrings(NucleosynthesizingRecipe recipe, double mouseX, double mouseY) {
        if (this.rateBar.func_231047_b_(mouseX, mouseY)) {
            return Collections.singletonList(MekanismLang.TICKS_REQUIRED.translate(recipe.getDuration()));
        }
        return Collections.emptyList();
    }

    public void setIngredients(NucleosynthesizingRecipe recipe, IIngredients ingredients) {
        ingredients.setInputLists(VanillaTypes.ITEM, Collections.singletonList(recipe.getItemInput().getRepresentations()));
        ingredients.setInputLists(MekanismJEI.TYPE_GAS, Collections.singletonList(((GasStackIngredient)recipe.getChemicalInput()).getRepresentations()));
        ingredients.setOutputLists(VanillaTypes.ITEM, Collections.singletonList(recipe.getOutputDefinition()));
    }

    public void setRecipe(IRecipeLayout recipeLayout, NucleosynthesizingRecipe recipe, IIngredients ingredients) {
        IGuiItemStackGroup itemStacks = recipeLayout.getItemStacks();
        this.initItem((IGuiIngredientGroup<ItemStack>)itemStacks, 0, true, this.input, recipe.getItemInput().getRepresentations());
        this.initItem((IGuiIngredientGroup<ItemStack>)itemStacks, 1, false, this.output, recipe.getOutputDefinition());
        ArrayList<ItemStack> gasItemProviders = new ArrayList<ItemStack>();
        List<@NonNull TYPE> gasInputs = ((GasStackIngredient)recipe.getChemicalInput()).getRepresentations();
        for (GasStack gas : gasInputs) {
            gasItemProviders.addAll(MekanismJEI.GAS_STACK_HELPER.getStacksFor(gas.getType(), true));
        }
        this.initItem((IGuiIngredientGroup<ItemStack>)itemStacks, 2, true, this.extra, gasItemProviders);
        this.initChemical(recipeLayout.getIngredientsGroup(MekanismJEI.TYPE_GAS), 0, true, this.gasInput, gasInputs);
    }
}

