/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.jei;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import mekanism.api.providers.IBlockProvider;
import mekanism.api.providers.IItemProvider;
import mekanism.api.recipes.MekanismRecipe;
import mekanism.api.recipes.RotaryRecipe;
import mekanism.api.recipes.inputs.ItemStackIngredient;
import mekanism.common.Mekanism;
import mekanism.common.recipe.MekanismRecipeType;
import mekanism.common.recipe.impl.NutritionalLiquifierIRecipe;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.registries.MekanismGases;
import mezz.jei.api.constants.VanillaRecipeCategoryUid;
import mezz.jei.api.recipe.vanilla.IVanillaRecipeFactory;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.item.Food;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;

public class RecipeRegistryHelper {
    private RecipeRegistryHelper() {
    }

    public static void registerCondensentrator(IRecipeRegistration registry) {
        ArrayList<RotaryRecipe> condensentratorRecipes = new ArrayList<RotaryRecipe>();
        ArrayList<RotaryRecipe> decondensentratorRecipes = new ArrayList<RotaryRecipe>();
        List<RotaryRecipe> recipes = MekanismRecipeType.ROTARY.getRecipes((World)RecipeRegistryHelper.getWorld());
        for (RotaryRecipe recipe : recipes) {
            if (recipe.hasGasToFluid()) {
                condensentratorRecipes.add(recipe);
            }
            if (!recipe.hasFluidToGas()) continue;
            decondensentratorRecipes.add(recipe);
        }
        ResourceLocation condensentrating = Mekanism.rl("rotary_condensentrator_condensentrating");
        ResourceLocation decondensentrating = Mekanism.rl("rotary_condensentrator_decondensentrating");
        registry.addRecipes(condensentratorRecipes, condensentrating);
        registry.addRecipes(decondensentratorRecipes, decondensentrating);
    }

    public static <RECIPE extends MekanismRecipe> void register(IRecipeRegistration registry, IBlockProvider mekanismBlock, MekanismRecipeType<RECIPE, ?> type) {
        RecipeRegistryHelper.register(registry, mekanismBlock.getRegistryName(), type);
    }

    public static <RECIPE extends MekanismRecipe> void register(IRecipeRegistration registry, ResourceLocation id, MekanismRecipeType<RECIPE, ?> type) {
        registry.addRecipes(type.getRecipes((World)RecipeRegistryHelper.getWorld()), id);
    }

    public static void registerNutritionalLiquifier(IRecipeRegistration registry) {
        ArrayList<NutritionalLiquifierIRecipe> list = new ArrayList<NutritionalLiquifierIRecipe>();
        for (Item item : ForgeRegistries.ITEMS.getValues()) {
            Food food;
            if (!item.func_219971_r() || (food = item.func_219967_s()) == null || food.func_221466_a() <= 0) continue;
            list.add(new NutritionalLiquifierIRecipe(item, ItemStackIngredient.from((net.minecraft.util.IItemProvider)item), MekanismGases.NUTRITIONAL_PASTE.getStack((long)food.func_221466_a() * 50L)));
        }
        registry.addRecipes(list, MekanismBlocks.NUTRITIONAL_LIQUIFIER.getRegistryName());
    }

    public static void addAnvilRecipes(IRecipeRegistration registry, IItemProvider item, Function<Item, ItemStack[]> repairMaterials) {
        IVanillaRecipeFactory factory = registry.getVanillaRecipeFactory();
        ItemStack damaged2 = item.getItemStack();
        damaged2.func_196085_b(damaged2.func_77958_k() * 3 / 4);
        ItemStack damaged3 = item.getItemStack();
        damaged3.func_196085_b(damaged3.func_77958_k() * 2 / 4);
        registry.addRecipes((Collection)ImmutableList.of((Object)factory.createAnvilRecipe(damaged2, Collections.singletonList(damaged2), Collections.singletonList(damaged3))), VanillaRecipeCategoryUid.ANVIL);
        ItemStack[] repairStacks = repairMaterials.apply(item.getItem());
        if (repairStacks != null && repairStacks.length > 0) {
            ItemStack damaged1 = item.getItemStack();
            damaged1.func_196085_b(damaged1.func_77958_k());
            registry.addRecipes((Collection)ImmutableList.of((Object)factory.createAnvilRecipe(damaged1, Arrays.asList(repairStacks), Collections.singletonList(damaged2))), VanillaRecipeCategoryUid.ANVIL);
        }
    }

    private static ClientWorld getWorld() {
        return Minecraft.func_71410_x().field_71441_e;
    }
}

