/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.window;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Pair;
import java.util.function.Consumer;
import java.util.function.Supplier;
import mekanism.client.gui.GuiMekanism;
import mekanism.client.gui.GuiUtils;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.gui.element.GuiTexturedElement;
import mekanism.client.gui.element.button.GuiCloseButton;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.inventory.container.IEmptyContainer;
import mekanism.common.inventory.container.SelectedWindowData;
import mekanism.common.lib.Color;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.text.ITextComponent;

public class GuiWindow
extends GuiTexturedElement {
    private static final Color OVERLAY_COLOR = Color.rgbai(60, 60, 60, 128);
    private final SelectedWindowData windowData;
    private boolean dragging = false;
    private double dragX;
    private double dragY;
    private int prevDX;
    private int prevDY;
    private Consumer<GuiWindow> closeListener;
    private Consumer<GuiWindow> reattachListener;
    protected InteractionStrategy interactionStrategy = InteractionStrategy.CONTAINER;

    private static Pair<Integer, Integer> calculateOpenPosition(IGuiWrapper gui, SelectedWindowData windowData, int x, int y, int width, int height) {
        int lastY;
        Pair<Integer, Integer> lastPosition = windowData.getLastPosition();
        int lastX = (Integer)lastPosition.getFirst();
        if (lastX != Integer.MAX_VALUE) {
            int guiLeft = gui.getLeft();
            if (guiLeft + lastX < 0) {
                lastX = -guiLeft;
            } else if (guiLeft + lastX + width > minecraft.func_228018_at_().func_198107_o()) {
                lastX = minecraft.func_228018_at_().func_198107_o() - guiLeft - width;
            }
        }
        if ((lastY = ((Integer)lastPosition.getSecond()).intValue()) != Integer.MAX_VALUE) {
            int guiTop = gui.getTop();
            if (guiTop + lastY < 0) {
                lastY = -guiTop;
            } else if (guiTop + lastY + height > minecraft.func_228018_at_().func_198087_p()) {
                lastY = minecraft.func_228018_at_().func_198087_p() - guiTop - height;
            }
        }
        return Pair.of((Object)(lastX == Integer.MAX_VALUE ? x : lastX), (Object)(lastY == Integer.MAX_VALUE ? y : lastY));
    }

    public GuiWindow(IGuiWrapper gui, int x, int y, int width, int height, SelectedWindowData.WindowType windowType) {
        this(gui, x, y, width, height, windowType == SelectedWindowData.WindowType.UNSPECIFIED ? SelectedWindowData.UNSPECIFIED : new SelectedWindowData(windowType));
    }

    public GuiWindow(IGuiWrapper gui, int x, int y, int width, int height, SelectedWindowData windowData) {
        this(gui, GuiWindow.calculateOpenPosition(gui, windowData, x, y, width, height), width, height, windowData);
    }

    private GuiWindow(IGuiWrapper gui, Pair<Integer, Integer> calculatedPosition, int width, int height, SelectedWindowData windowData) {
        super(GuiMekanism.BASE_BACKGROUND, gui, (int)((Integer)calculatedPosition.getFirst()), (int)((Integer)calculatedPosition.getSecond()), width, height);
        this.windowData = windowData;
        this.isOverlay = true;
        this.field_230693_o_ = true;
        if (!this.isFocusOverlay()) {
            this.addCloseButton();
        }
    }

    public void onFocusLost() {
    }

    public void onFocused() {
        this.gui().setSelectedWindow(this.windowData);
    }

    protected void addCloseButton() {
        this.addChild(new GuiCloseButton(this.gui(), this.relativeX + 6, this.relativeY + 6, this));
    }

    @Override
    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        Container c;
        boolean ret = super.func_231044_a_(mouseX, mouseY, button);
        if (this.func_231047_b_(mouseX, mouseY)) {
            if (mouseY < (double)(this.field_230691_m_ + 18)) {
                this.dragging = true;
                this.dragX = mouseX;
                this.dragY = mouseY;
                this.prevDX = 0;
                this.prevDY = 0;
            }
        } else if (!ret && this.interactionStrategy.allowContainer() && this.gui() instanceof GuiMekanism && !((c = ((GuiMekanism)this.gui()).func_212873_a_()) instanceof IEmptyContainer) && mouseX >= (double)this.getGuiLeft() && mouseX < (double)(this.getGuiLeft() + this.getGuiWidth()) && mouseY >= (double)(this.getGuiTop() + this.getGuiHeight() - 90)) {
            return false;
        }
        return ret || !this.interactionStrategy.allowAll();
    }

    @Override
    public void func_230983_a_(double mouseX, double mouseY, double mouseXOld, double mouseYOld) {
        super.func_230983_a_(mouseX, mouseY, mouseXOld, mouseYOld);
        if (this.dragging) {
            int newDX = (int)Math.round(mouseX - this.dragX);
            int newDY = (int)Math.round(mouseY - this.dragY);
            int changeX = Math.max(-this.field_230690_l_, Math.min(minecraft.func_228018_at_().func_198107_o() - (this.field_230690_l_ + this.field_230688_j_), newDX - this.prevDX));
            int changeY = Math.max(-this.field_230691_m_, Math.min(minecraft.func_228018_at_().func_198087_p() - (this.field_230691_m_ + this.field_230689_k_), newDY - this.prevDY));
            this.prevDX = newDX;
            this.prevDY = newDY;
            this.move(changeX, changeY);
        }
    }

    @Override
    public void func_231000_a__(double mouseX, double mouseY) {
        super.func_231000_a__(mouseX, mouseY);
        this.dragging = false;
    }

    @Override
    public void renderBackgroundOverlay(MatrixStack matrix, int mouseX, int mouseY) {
        if (this.isFocusOverlay()) {
            MekanismRenderer.renderColorOverlay(matrix, 0, 0, minecraft.func_228018_at_().func_198107_o(), minecraft.func_228018_at_().func_198087_p(), OVERLAY_COLOR.rgba());
        } else {
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.75f);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            GuiUtils.renderBackgroundTexture(matrix, GuiMekanism.SHADOW, 4, 4, this.getButtonX() - 3, this.getButtonY() - 3, this.getButtonWidth() + 6, this.getButtonHeight() + 6, 256, 256);
            MekanismRenderer.resetColor();
        }
        GuiWindow.minecraft.field_71446_o.func_110577_a(this.getResource());
        this.renderBackgroundTexture(matrix, this.getResource(), 4, 4);
    }

    @Override
    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        if (super.func_231046_a_(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (keyCode == 256) {
            this.close();
            return true;
        }
        return false;
    }

    public void setListenerTab(Supplier<? extends GuiElement> elementSupplier) {
        this.setTabListeners(window -> {
            ((GuiElement)elementSupplier.get()).field_230693_o_ = true;
        }, window -> {
            ((GuiElement)elementSupplier.get()).field_230693_o_ = false;
        });
    }

    public void setTabListeners(Consumer<GuiWindow> closeListener, Consumer<GuiWindow> reattachListener) {
        this.closeListener = closeListener;
        this.reattachListener = reattachListener;
    }

    @Override
    public void resize(int prevLeft, int prevTop, int left, int top) {
        super.resize(prevLeft, prevTop, left, top);
        if (this.reattachListener != null) {
            this.reattachListener.accept(this);
        }
    }

    public void renderBlur(MatrixStack matrix) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.3f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        GuiUtils.renderBackgroundTexture(matrix, GuiMekanism.BLUR, 4, 4, this.relativeX, this.relativeY, this.field_230688_j_, this.field_230689_k_, 256, 256);
        MekanismRenderer.resetColor();
    }

    public void close() {
        this.gui().removeWindow(this);
        this.children.forEach(GuiElement::onWindowClose);
        if (this.closeListener != null) {
            this.closeListener.accept(this);
        }
        this.windowData.updateLastPosition(this.relativeX, this.relativeY);
    }

    protected boolean isFocusOverlay() {
        return false;
    }

    @Override
    public void drawTitleText(MatrixStack matrix, ITextComponent text, float y) {
        if (this.isFocusOverlay()) {
            super.drawTitleText(matrix, text, y);
        } else {
            int leftShift = this.getTitlePadStart();
            int xSize = this.getXSize() - leftShift - this.getTitlePadEnd();
            int maxLength = xSize - 12;
            float textWidth = this.getStringWidth(text);
            float scale = Math.min(1.0f, (float)maxLength / textWidth);
            float left = (float)this.relativeX + (float)xSize / 2.0f;
            this.drawScaledCenteredText(matrix, text, left + (float)leftShift, (float)this.relativeY + y, this.titleTextColor(), scale);
        }
    }

    protected int getTitlePadStart() {
        return 12;
    }

    protected int getTitlePadEnd() {
        return 0;
    }

    public static enum InteractionStrategy {
        NONE,
        CONTAINER,
        ALL;


        boolean allowContainer() {
            return this != NONE;
        }

        boolean allowAll() {
            return this == ALL;
        }
    }
}

