/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.window;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Collections;
import mekanism.api.RelativeSide;
import mekanism.api.text.EnumColor;
import mekanism.client.gui.GuiMekanism;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.gui.element.GuiInnerScreen;
import mekanism.client.gui.element.button.ColorButton;
import mekanism.client.gui.element.button.MekanismImageButton;
import mekanism.client.gui.element.button.SideDataButton;
import mekanism.client.gui.element.slot.GuiSlot;
import mekanism.client.gui.element.slot.SlotType;
import mekanism.client.gui.element.window.GuiWindow;
import mekanism.common.Mekanism;
import mekanism.common.MekanismLang;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.SelectedWindowData;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.network.to_server.PacketConfigurationUpdate;
import mekanism.common.network.to_server.PacketGuiInteract;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.component.config.DataType;
import mekanism.common.tile.interfaces.ISideConfiguration;
import mekanism.common.util.text.BooleanStateDisplay;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.text.ITextComponent;

public class GuiTransporterConfig<TILE extends TileEntityMekanism>
extends GuiWindow {
    private final TILE tile;

    public GuiTransporterConfig(IGuiWrapper gui, int x, int y, TILE tile) {
        super(gui, x, y, 156, 95, SelectedWindowData.WindowType.TRANSPORTER_CONFIG);
        this.tile = tile;
        this.interactionStrategy = GuiWindow.InteractionStrategy.ALL;
        this.addChild(new GuiInnerScreen(gui, this.relativeX + 41, this.relativeY + 15, 74, 12, () -> Collections.singletonList(MekanismLang.STRICT_INPUT_ENABLED.translate(BooleanStateDisplay.OnOff.of(((ISideConfiguration)((Object)tile)).getEjector().hasStrictInput())))));
        this.addChild(new GuiSlot(SlotType.NORMAL, gui, this.relativeX + 111, this.relativeY + 48));
        this.addChild(new MekanismImageButton(gui, this.relativeX + 136, this.relativeY + 6, 14, 16, this.getButtonLocation("exclamation"), () -> Mekanism.packetHandler.sendToServer(new PacketConfigurationUpdate(this.tile.func_174877_v())), this.getOnHover(MekanismLang.STRICT_INPUT)));
        this.addChild(new ColorButton(gui, this.relativeX + 112, this.relativeY + 49, 16, 16, () -> ((ISideConfiguration)this.tile).getEjector().getOutputColor(), () -> Mekanism.packetHandler.sendToServer(new PacketConfigurationUpdate(this.tile.func_174877_v(), Screen.func_231173_s_() ? 2 : 0)), () -> Mekanism.packetHandler.sendToServer(new PacketConfigurationUpdate(this.tile.func_174877_v(), 1))));
        this.addSideDataButton(RelativeSide.BOTTOM, 44, 64);
        this.addSideDataButton(RelativeSide.TOP, 44, 34);
        this.addSideDataButton(RelativeSide.FRONT, 44, 49);
        this.addSideDataButton(RelativeSide.BACK, 29, 64);
        this.addSideDataButton(RelativeSide.LEFT, 29, 49);
        this.addSideDataButton(RelativeSide.RIGHT, 59, 49);
        Mekanism.packetHandler.sendToServer(new PacketGuiInteract(PacketGuiInteract.GuiInteraction.CONTAINER_TRACK_EJECTOR, (TileEntity)this.tile, 0));
        ((MekanismContainer)((GuiMekanism)this.gui()).func_212873_a_()).startTracking(0, ((ISideConfiguration)this.tile).getEjector());
    }

    private void addSideDataButton(RelativeSide side, int xPos, int yPos) {
        SideDataButton button = this.addChild(new SideDataButton(this.gui(), this.relativeX + xPos, this.relativeY + yPos, side, () -> ((ISideConfiguration)this.tile).getConfig().getDataType(TransmissionType.ITEM, side), () -> ((ISideConfiguration)this.tile).getEjector().getInputColor(side), (TileEntity)this.tile, () -> null, PacketConfigurationUpdate.ConfigurationPacket.INPUT_COLOR, this.getOnHover(side)));
        if (!((ISideConfiguration)this.tile).getEjector().isInputSideEnabled(side)) {
            button.field_230693_o_ = false;
        }
    }

    @Override
    public void close() {
        super.close();
        Mekanism.packetHandler.sendToServer(new PacketGuiInteract(PacketGuiInteract.GuiInteraction.CONTAINER_STOP_TRACKING, (TileEntity)this.tile, 0));
        ((MekanismContainer)((GuiMekanism)this.gui()).func_212873_a_()).stopTracking(0);
    }

    private GuiElement.IHoverable getOnHover(RelativeSide side) {
        return (onHover, matrix, xAxis, yAxis) -> {
            SideDataButton button;
            DataType dataType;
            if (onHover instanceof SideDataButton && (dataType = (button = (SideDataButton)onHover).getDataType()) != null) {
                EnumColor color = button.getColor();
                ITextComponent colorComponent = color == null ? MekanismLang.NONE.translate(new Object[0]) : color.getColoredName();
                this.displayTooltip(matrix, (ITextComponent)MekanismLang.GENERIC_WITH_PARENTHESIS.translate(colorComponent, side), xAxis, yAxis);
            }
        };
    }

    @Override
    public void renderForeground(MatrixStack matrix, int mouseX, int mouseY) {
        super.renderForeground(matrix, mouseX, mouseY);
        this.drawTitleText(matrix, (ITextComponent)MekanismLang.TRANSPORTER_CONFIG.translate(new Object[0]), 5.0f);
        this.drawCenteredText(matrix, (ITextComponent)MekanismLang.INPUT.translate(new Object[0]), this.relativeX + 51, this.relativeY + 81, this.subheadingTextColor());
        this.drawCenteredText(matrix, (ITextComponent)MekanismLang.OUTPUT.translate(new Object[0]), this.relativeX + 121, this.relativeY + 68, this.subheadingTextColor());
    }

    @Override
    protected int getTitlePadEnd() {
        return super.getTitlePadEnd() + 15;
    }
}

