/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.scroll;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Set;
import java.util.function.ObjIntConsumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.Upgrade;
import mekanism.api.text.TextComponentUtil;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.gui.element.GuiElementHolder;
import mekanism.client.gui.element.scroll.GuiScrollList;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.tile.component.TileComponentUpgrade;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.UpgradeUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;

public class GuiUpgradeScrollList
extends GuiScrollList {
    private static final ResourceLocation UPGRADE_SELECTION = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "upgrade_selection.png");
    private static final int TEXTURE_WIDTH = 58;
    private static final int TEXTURE_HEIGHT = 36;
    private final TileComponentUpgrade component;
    private final Runnable onSelectionChange;
    @Nullable
    private Upgrade selectedType;

    public GuiUpgradeScrollList(IGuiWrapper gui, int x, int y, int width, int height, TileComponentUpgrade component, Runnable onSelectionChange) {
        super(gui, x, y, width, height, 12, GuiElementHolder.HOLDER, 32);
        this.component = component;
        this.onSelectionChange = onSelectionChange;
    }

    private Set<Upgrade> getCurrentUpgrades() {
        return this.component.getInstalledTypes();
    }

    @Override
    protected int getMaxElements() {
        return this.getCurrentUpgrades().size();
    }

    @Override
    public boolean hasSelection() {
        return this.selectedType != null;
    }

    @Override
    protected void setSelected(int index) {
        Upgrade newSelection;
        Set<Upgrade> currentUpgrades = this.getCurrentUpgrades();
        if (index >= 0 && index < currentUpgrades.size() && this.selectedType != (newSelection = currentUpgrades.toArray(new Upgrade[0])[index])) {
            this.selectedType = newSelection;
            this.onSelectionChange.run();
        }
    }

    @Nullable
    public Upgrade getSelection() {
        return this.selectedType;
    }

    @Override
    public void clearSelection() {
        if (this.selectedType != null) {
            this.selectedType = null;
            this.onSelectionChange.run();
        }
    }

    @Override
    public void renderForeground(MatrixStack matrix, int mouseX, int mouseY) {
        super.renderForeground(matrix, mouseX, mouseY);
        this.forEachUpgrade((upgrade, multipliedElement) -> this.drawTextScaledBound(matrix, (ITextComponent)TextComponentUtil.build(upgrade), this.relativeX + 13, this.relativeY + 3 + multipliedElement, this.titleTextColor(), 44.0f));
    }

    @Override
    public void func_230443_a_(@Nonnull MatrixStack matrix, int mouseX, int mouseY) {
        super.func_230443_a_(matrix, mouseX, mouseY);
        if (mouseX >= this.relativeX + 1 && mouseX < this.relativeX + this.barXShift - 1) {
            this.forEachUpgrade((upgrade, multipliedElement) -> {
                if (mouseY >= this.relativeY + 1 + multipliedElement && mouseY < this.relativeY + 1 + multipliedElement + this.elementHeight) {
                    this.displayTooltip(matrix, upgrade.getDescription(), mouseX, mouseY, this.getGuiWidth());
                }
            });
        }
    }

    @Override
    public void renderElements(MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
        if (this.hasSelection() && this.component.getUpgrades(this.getSelection()) == 0) {
            this.clearSelection();
        }
        GuiUpgradeScrollList.minecraft.field_71446_o.func_110577_a(UPGRADE_SELECTION);
        this.forEachUpgrade((upgrade, multipliedElement) -> {
            int shiftedY = this.field_230691_m_ + 1 + multipliedElement;
            int j = 1;
            if (upgrade == this.getSelection()) {
                j = 2;
            } else if (mouseX >= this.field_230690_l_ + 1 && mouseX < this.barX - 1 && mouseY >= shiftedY && mouseY < shiftedY + this.elementHeight) {
                j = 0;
            }
            MekanismRenderer.color(upgrade.getColor());
            GuiUpgradeScrollList.func_238463_a_((MatrixStack)matrix, (int)(this.field_230690_l_ + 1), (int)shiftedY, (float)0.0f, (float)(this.elementHeight * j), (int)58, (int)this.elementHeight, (int)58, (int)36);
            MekanismRenderer.resetColor();
        });
        this.forEachUpgrade((upgrade, multipliedElement) -> this.gui().renderItem(matrix, UpgradeUtils.getStack(upgrade), this.field_230690_l_ + 3, this.field_230691_m_ + 3 + multipliedElement, 0.5f));
    }

    private void forEachUpgrade(ObjIntConsumer<Upgrade> consumer) {
        int index;
        Upgrade[] upgrades = this.getCurrentUpgrades().toArray(new Upgrade[0]);
        int currentSelection = this.getCurrentSelection();
        for (int i = 0; i < this.getFocusedElements() && (index = currentSelection + i) <= upgrades.length - 1; ++i) {
            consumer.accept(upgrades[index], this.elementHeight * i);
        }
    }

    @Override
    public void syncFrom(GuiElement element) {
        super.syncFrom(element);
        GuiUpgradeScrollList old = (GuiUpgradeScrollList)element;
        this.selectedType = old.selectedType;
    }
}

