/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.text;

import java.util.ArrayList;
import mekanism.api.text.APILang;
import mekanism.api.text.EnumColor;
import mekanism.api.text.IHasTextComponent;
import mekanism.api.text.IHasTranslationKey;
import net.minecraft.block.Block;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraftforge.fluids.FluidStack;

public class TextComponentUtil {
    private TextComponentUtil() {
    }

    @Deprecated
    public static IFormattableTextComponent getFormattableComponent(ITextComponent component) {
        return component.func_230532_e_();
    }

    public static IFormattableTextComponent color(IFormattableTextComponent component, int color) {
        return component.func_230530_a_(component.func_150256_b().func_240718_a_(Color.func_240743_a_((int)color)));
    }

    public static IFormattableTextComponent build(Object ... components) {
        IFormattableTextComponent result = null;
        Style cachedStyle = Style.field_240709_b_;
        for (Object component : components) {
            if (component == null) continue;
            Object current = null;
            if (component instanceof IHasTextComponent) {
                current = ((IHasTextComponent)component).getTextComponent().func_230532_e_();
            } else if (component instanceof IHasTranslationKey) {
                current = TextComponentUtil.translate(((IHasTranslationKey)component).getTranslationKey(), new Object[0]);
            } else if (component instanceof EnumColor) {
                cachedStyle = cachedStyle.func_240718_a_(((EnumColor)component).getColor());
            } else if (component instanceof ITextComponent) {
                current = ((ITextComponent)component).func_230532_e_();
            } else if (component instanceof TextFormatting) {
                cachedStyle = cachedStyle.func_240721_b_((TextFormatting)component);
            } else if (component instanceof ClickEvent) {
                cachedStyle = cachedStyle.func_240715_a_((ClickEvent)component);
            } else if (component instanceof HoverEvent) {
                cachedStyle = cachedStyle.func_240716_a_((HoverEvent)component);
            } else {
                current = component instanceof Block ? TextComponentUtil.translate(((Block)component).func_149739_a(), new Object[0]) : (component instanceof Item ? TextComponentUtil.translate(((Item)component).func_77658_a(), new Object[0]) : (component instanceof ItemStack ? ((ItemStack)component).func_200301_q().func_230532_e_() : (component instanceof FluidStack ? TextComponentUtil.translate(((FluidStack)component).getTranslationKey(), new Object[0]) : (component instanceof Fluid ? TextComponentUtil.translate(((Fluid)component).getAttributes().getTranslationKey(), new Object[0]) : (component instanceof Direction ? TextComponentUtil.getTranslatedDirection((Direction)component) : TextComponentUtil.getString(component.toString()))))));
            }
            if (current == null) continue;
            if (!cachedStyle.func_150229_g()) {
                current.func_230530_a_(cachedStyle);
                cachedStyle = Style.field_240709_b_;
            }
            if (result == null) {
                result = current;
                continue;
            }
            result.func_230529_a_((ITextComponent)current);
        }
        return result;
    }

    private static IFormattableTextComponent getTranslatedDirection(Direction direction) {
        switch (direction) {
            case DOWN: {
                return APILang.DOWN.translate(new Object[0]);
            }
            case UP: {
                return APILang.UP.translate(new Object[0]);
            }
            case NORTH: {
                return APILang.NORTH.translate(new Object[0]);
            }
            case SOUTH: {
                return APILang.SOUTH.translate(new Object[0]);
            }
            case WEST: {
                return APILang.WEST.translate(new Object[0]);
            }
            case EAST: {
                return APILang.EAST.translate(new Object[0]);
            }
        }
        return TextComponentUtil.getString(direction.toString());
    }

    public static StringTextComponent getString(String component) {
        return new StringTextComponent(TextComponentUtil.cleanString(component));
    }

    private static String cleanString(String component) {
        return component.replace("\u00a0", " ");
    }

    public static TranslationTextComponent translate(String key, Object ... args) {
        return new TranslationTextComponent(key, args);
    }

    public static TranslationTextComponent smartTranslate(String key, Object ... components) {
        if (components.length == 0) {
            return TextComponentUtil.translate(key, new Object[0]);
        }
        ArrayList<Object> args = new ArrayList<Object>();
        Style cachedStyle = Style.field_240709_b_;
        for (Object component : components) {
            if (component == null) {
                args.add(null);
                cachedStyle = Style.field_240709_b_;
                continue;
            }
            Object current = null;
            if (component instanceof IHasTextComponent) {
                current = ((IHasTextComponent)component).getTextComponent().func_230532_e_();
            } else if (component instanceof IHasTranslationKey) {
                current = TextComponentUtil.translate(((IHasTranslationKey)component).getTranslationKey(), new Object[0]);
            } else if (component instanceof Block) {
                current = TextComponentUtil.translate(((Block)component).func_149739_a(), new Object[0]);
            } else if (component instanceof Item) {
                current = TextComponentUtil.translate(((Item)component).func_77658_a(), new Object[0]);
            } else if (component instanceof ItemStack) {
                current = ((ItemStack)component).func_200301_q().func_230532_e_();
            } else if (component instanceof FluidStack) {
                current = TextComponentUtil.translate(((FluidStack)component).getTranslationKey(), new Object[0]);
            } else if (component instanceof Fluid) {
                current = TextComponentUtil.translate(((Fluid)component).getAttributes().getTranslationKey(), new Object[0]);
            } else if (component instanceof Direction) {
                current = TextComponentUtil.getTranslatedDirection((Direction)component);
            } else {
                if (component instanceof EnumColor && cachedStyle.func_240711_a_() == null) {
                    cachedStyle = cachedStyle.func_240718_a_(((EnumColor)component).getColor());
                    continue;
                }
                if (component instanceof TextFormatting && !TextComponentUtil.hasStyleType(cachedStyle, (TextFormatting)component)) {
                    cachedStyle = cachedStyle.func_240721_b_((TextFormatting)component);
                    continue;
                }
                if (component instanceof ClickEvent && cachedStyle.func_150235_h() == null) {
                    cachedStyle = cachedStyle.func_240715_a_((ClickEvent)component);
                    continue;
                }
                if (component instanceof HoverEvent && cachedStyle.func_150210_i() == null) {
                    cachedStyle = cachedStyle.func_240716_a_((HoverEvent)component);
                    continue;
                }
                if (!cachedStyle.func_150229_g()) {
                    current = component instanceof ITextComponent ? ((ITextComponent)component).func_230532_e_() : (component instanceof EnumColor ? ((EnumColor)component).getName() : TextComponentUtil.getString(component.toString()));
                } else if (component instanceof String) {
                    component = TextComponentUtil.cleanString((String)component);
                }
            }
            if (!cachedStyle.func_150229_g()) {
                if (current == null) {
                    args.add(component);
                } else {
                    args.add(current.func_230530_a_(cachedStyle));
                }
                cachedStyle = Style.field_240709_b_;
                continue;
            }
            if (current == null) {
                args.add(component);
                continue;
            }
            args.add(current);
        }
        if (!cachedStyle.func_150229_g()) {
            Object lastComponent = components[components.length - 1];
            if (lastComponent instanceof EnumColor) {
                args.add(((EnumColor)lastComponent).getName());
            } else {
                args.add(lastComponent);
            }
        }
        return TextComponentUtil.translate(key, args.toArray());
    }

    private static boolean hasStyleType(Style current, TextFormatting formatting) {
        switch (formatting) {
            case OBFUSCATED: {
                return current.func_150233_f();
            }
            case BOLD: {
                return current.func_150223_b();
            }
            case STRIKETHROUGH: {
                return current.func_150236_d();
            }
            case UNDERLINE: {
                return current.func_150234_e();
            }
            case ITALIC: {
                return current.func_150242_c();
            }
            case RESET: {
                return current.func_150229_g();
            }
        }
        return current.func_240711_a_() != null;
    }
}

