/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.recipes.cache;

import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.api.annotations.FieldsAreNonnullByDefault;
import mekanism.api.annotations.NonNull;
import mekanism.api.recipes.FluidToFluidRecipe;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.inputs.IInputHandler;
import mekanism.api.recipes.outputs.IOutputHandler;
import net.minecraftforge.fluids.FluidStack;

@FieldsAreNonnullByDefault
@ParametersAreNonnullByDefault
public class FluidToFluidCachedRecipe
extends CachedRecipe<FluidToFluidRecipe> {
    private final IOutputHandler<@NonNull FluidStack> outputHandler;
    private final IInputHandler<@NonNull FluidStack> inputHandler;
    private FluidStack recipeFluid = FluidStack.EMPTY;

    public FluidToFluidCachedRecipe(FluidToFluidRecipe recipe, IInputHandler<@NonNull FluidStack> inputHandler, IOutputHandler<@NonNull FluidStack> outputHandler) {
        super(recipe);
        this.inputHandler = Objects.requireNonNull(inputHandler, "Input handler cannot be null.");
        this.outputHandler = Objects.requireNonNull(outputHandler, "Output handler cannot be null.");
    }

    @Override
    protected int getOperationsThisTick(int currentMax) {
        if ((currentMax = super.getOperationsThisTick(currentMax)) <= 0) {
            return currentMax;
        }
        this.recipeFluid = this.inputHandler.getRecipeInput(((FluidToFluidRecipe)this.recipe).getInput());
        if (this.recipeFluid.isEmpty()) {
            return -1;
        }
        if ((currentMax = this.inputHandler.operationsCanSupport(this.recipeFluid, currentMax)) <= 0) {
            return -1;
        }
        return this.outputHandler.operationsRoomFor(((FluidToFluidRecipe)this.recipe).getOutput(this.recipeFluid), currentMax);
    }

    @Override
    public boolean isInputValid() {
        return ((FluidToFluidRecipe)this.recipe).test(this.inputHandler.getInput());
    }

    @Override
    protected void finishProcessing(int operations) {
        if (this.recipeFluid.isEmpty()) {
            return;
        }
        this.inputHandler.use(this.recipeFluid, operations);
        this.outputHandler.handleOutput(((FluidToFluidRecipe)this.recipe).getOutput(this.recipeFluid), operations);
    }
}

