/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.recipes.cache;

import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import java.util.Objects;
import java.util.function.BooleanSupplier;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import java.util.function.IntUnaryOperator;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import mekanism.api.Action;
import mekanism.api.annotations.FieldsAreNonnullByDefault;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.inventory.AutomationType;
import mekanism.api.math.FloatingLong;
import mekanism.api.math.FloatingLongConsumer;
import mekanism.api.math.FloatingLongSupplier;
import mekanism.api.recipes.MekanismRecipe;

@FieldsAreNonnullByDefault
@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public abstract class CachedRecipe<RECIPE extends MekanismRecipe> {
    protected final RECIPE recipe;
    private BooleanSupplier canHolderFunction = () -> true;
    private BooleanConsumer setActive = active -> {};
    private IntSupplier requiredTicks = () -> 1;
    private Runnable onFinish = () -> {};
    private FloatingLongSupplier perTickEnergy = () -> FloatingLong.ZERO;
    private FloatingLongSupplier storedEnergy = () -> FloatingLong.ZERO;
    private FloatingLongConsumer useEnergy = energy -> {};
    private IntUnaryOperator postProcessOperations = currentMax -> Math.min(1, currentMax);
    private int operatingTicks;
    private IntConsumer operatingTicksChanged = ticks -> {};

    protected CachedRecipe(RECIPE recipe) {
        this.recipe = (MekanismRecipe)Objects.requireNonNull(recipe, "Recipe cannot be null.");
    }

    public CachedRecipe<RECIPE> setCanHolderFunction(BooleanSupplier canHolderFunction) {
        this.canHolderFunction = Objects.requireNonNull(canHolderFunction, "Can holder function cannot be null.");
        return this;
    }

    public CachedRecipe<RECIPE> setActive(BooleanConsumer setActive) {
        this.setActive = Objects.requireNonNull(setActive, "Set active consumer cannot be null.");
        return this;
    }

    public CachedRecipe<RECIPE> setEnergyRequirements(FloatingLongSupplier perTickEnergy, IEnergyContainer energyContainer) {
        this.perTickEnergy = Objects.requireNonNull(perTickEnergy, "The per tick energy cannot be null.");
        Objects.requireNonNull(energyContainer, "Energy container cannot be null.");
        this.storedEnergy = energyContainer::getEnergy;
        this.useEnergy = energy -> energyContainer.extract(energy, Action.EXECUTE, AutomationType.INTERNAL);
        return this;
    }

    public CachedRecipe<RECIPE> setRequiredTicks(IntSupplier requiredTicks) {
        this.requiredTicks = Objects.requireNonNull(requiredTicks, "Required ticks cannot be null.");
        return this;
    }

    public CachedRecipe<RECIPE> setOperatingTicksChanged(IntConsumer operatingTicksChanged) {
        this.operatingTicksChanged = Objects.requireNonNull(operatingTicksChanged, "Operating ticks changed handler cannot be null.");
        return this;
    }

    public CachedRecipe<RECIPE> setOnFinish(Runnable onFinish) {
        this.onFinish = Objects.requireNonNull(onFinish, "On finish handling cannot be null.");
        return this;
    }

    public CachedRecipe<RECIPE> setPostProcessOperations(IntUnaryOperator postProcessOperations) {
        this.postProcessOperations = Objects.requireNonNull(postProcessOperations, "Post processing of the operation count cannot be null.");
        return this;
    }

    public void loadSavedOperatingTicks(int operatingTicks) {
        if (operatingTicks > 0 && operatingTicks < this.requiredTicks.getAsInt()) {
            this.operatingTicks = operatingTicks;
        }
    }

    public void process() {
        int operations;
        if (this.canHolderFunction.getAsBoolean()) {
            this.setupVariableValues();
            operations = this.postProcessOperations.applyAsInt(this.getOperationsThisTick(Integer.MAX_VALUE));
        } else {
            operations = 0;
        }
        if (operations > 0) {
            this.setActive.accept(true);
            this.useEnergy(operations);
            ++this.operatingTicks;
            int ticksRequired = this.requiredTicks.getAsInt();
            if (this.operatingTicks >= ticksRequired) {
                this.operatingTicks = 0;
                this.finishProcessing(operations);
                this.onFinish.run();
                this.resetCache();
            } else {
                this.useResources(operations);
            }
            if (ticksRequired > 1) {
                this.operatingTicksChanged.accept(this.operatingTicks);
            }
        } else {
            this.setActive.accept(false);
            if (operations < 0) {
                this.operatingTicks = 0;
                this.operatingTicksChanged.accept(this.operatingTicks);
                this.resetCache();
            }
        }
    }

    protected void setupVariableValues() {
    }

    public int getOperatingTicks() {
        return this.operatingTicks;
    }

    @Deprecated
    protected FloatingLong getStoredElectricity() {
        return this.storedEnergy.get();
    }

    @Deprecated
    protected FloatingLong getEnergyPerTick() {
        return this.perTickEnergy.get();
    }

    @Deprecated
    protected int getTicksRequired() {
        return this.requiredTicks.getAsInt();
    }

    protected void useResources(int operations) {
    }

    protected void resetCache() {
    }

    protected void useEnergy(int operations) {
        this.useEnergy.accept(this.perTickEnergy.get().multiply(operations));
    }

    protected int getOperationsThisTick(int currentMax) {
        if (currentMax <= 0) {
            return currentMax;
        }
        FloatingLong energyPerTick = this.perTickEnergy.get();
        if (energyPerTick.isZero()) {
            return currentMax;
        }
        return Math.min(this.storedEnergy.get().divideToInt(energyPerTick), currentMax);
    }

    @Deprecated
    public boolean canFunction() {
        return this.canHolderFunction.getAsBoolean() && this.postProcessOperations.applyAsInt(this.getOperationsThisTick(1)) > 0;
    }

    public abstract boolean isInputValid();

    protected abstract void finishProcessing(int var1);

    public RECIPE getRecipe() {
        return this.recipe;
    }
}

