/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.datagen.recipe.builder;

import com.google.gson.JsonObject;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import mekanism.api.SerializerHelper;
import mekanism.api.annotations.FieldsAreNonnullByDefault;
import mekanism.api.datagen.recipe.MekanismRecipeBuilder;
import mekanism.api.recipes.inputs.ItemStackIngredient;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

@FieldsAreNonnullByDefault
@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class SawmillRecipeBuilder
extends MekanismRecipeBuilder<SawmillRecipeBuilder> {
    private final OutputType outputType;
    private final ItemStackIngredient input;
    private final ItemStack mainOutput;
    private final ItemStack secondaryOutput;
    private final double secondaryChance;

    protected SawmillRecipeBuilder(ItemStackIngredient input, ItemStack mainOutput, ItemStack secondaryOutput, double secondaryChance, OutputType outputType) {
        super(SawmillRecipeBuilder.mekSerializer("sawing"));
        this.outputType = outputType;
        this.input = input;
        this.mainOutput = mainOutput;
        this.secondaryOutput = secondaryOutput;
        this.secondaryChance = secondaryChance;
    }

    public static SawmillRecipeBuilder sawing(ItemStackIngredient input, ItemStack mainOutput) {
        if (mainOutput.func_190926_b()) {
            throw new IllegalArgumentException("This sawing recipe requires a non empty output.");
        }
        return new SawmillRecipeBuilder(input, mainOutput, ItemStack.field_190927_a, 0.0, OutputType.PRIMARY);
    }

    public static SawmillRecipeBuilder sawing(ItemStackIngredient input, ItemStack secondaryOutput, double secondaryChance) {
        if (secondaryOutput.func_190926_b()) {
            throw new IllegalArgumentException("This sawing recipe requires a non empty secondary output.");
        }
        if (secondaryChance <= 0.0 || secondaryChance > 1.0) {
            throw new IllegalArgumentException("This sawing recipe requires a secondary output chance greater than zero and at most one.");
        }
        if (secondaryChance == 1.0) {
            throw new IllegalArgumentException("Sawing recipes with a single 100% change output should specify their output as the main output.");
        }
        return new SawmillRecipeBuilder(input, ItemStack.field_190927_a, secondaryOutput, secondaryChance, OutputType.SECONDARY);
    }

    public static SawmillRecipeBuilder sawing(ItemStackIngredient input, ItemStack mainOutput, ItemStack secondaryOutput, double secondaryChance) {
        if (mainOutput.func_190926_b() || secondaryOutput.func_190926_b()) {
            throw new IllegalArgumentException("This sawing recipe requires a non empty primary, and secondary output.");
        }
        if (secondaryChance <= 0.0 || secondaryChance > 1.0) {
            throw new IllegalArgumentException("This sawing recipe requires a secondary output chance greater than zero and at most one.");
        }
        return new SawmillRecipeBuilder(input, mainOutput, secondaryOutput, secondaryChance, OutputType.BOTH);
    }

    @Override
    protected SawmillRecipeResult getResult(ResourceLocation id) {
        return new SawmillRecipeResult(id);
    }

    private static enum OutputType {
        PRIMARY(true, false),
        SECONDARY(false, true),
        BOTH(true, true);

        private final boolean hasPrimary;
        private final boolean hasSecondary;

        private OutputType(boolean hasPrimary, boolean hasSecondary) {
            this.hasPrimary = hasPrimary;
            this.hasSecondary = hasSecondary;
        }
    }

    public class SawmillRecipeResult
    extends MekanismRecipeBuilder.RecipeResult {
        protected SawmillRecipeResult(ResourceLocation id) {
            super(id);
        }

        public void func_218610_a(@Nonnull JsonObject json) {
            json.add("input", SawmillRecipeBuilder.this.input.serialize());
            if (SawmillRecipeBuilder.this.outputType.hasPrimary) {
                json.add("mainOutput", SerializerHelper.serializeItemStack(SawmillRecipeBuilder.this.mainOutput));
            }
            if (SawmillRecipeBuilder.this.outputType.hasSecondary) {
                json.add("secondaryOutput", SerializerHelper.serializeItemStack(SawmillRecipeBuilder.this.secondaryOutput));
                json.addProperty("secondaryChance", (Number)SawmillRecipeBuilder.this.secondaryChance);
            }
        }
    }
}

