/*
 * Decompiled with CFR 0.152.
 */
package me.tepis.integratednbt;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.tepis.integratednbt.Additions;
import me.tepis.integratednbt.ItemGroups;
import me.tepis.integratednbt.NBTExtractor;
import me.tepis.integratednbt.network.PacketHandler;
import me.tepis.integratednbt.network.serverbound.NBTExtractorRemoteRequestMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.PacketDistributor;

public class NBTExtractorRemote
extends Item {
    public static final String REGISTRY_NAME = "nbt_extractor_remote";

    public NBTExtractorRemote() {
        super(new Item.Properties().func_200916_a(ItemGroups.ITEM_GROUP).func_200917_a(1));
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, @Nonnull Hand hand) {
        if (world.field_72995_K) {
            this.clientUse(player.func_184586_b(hand), player);
        }
        return super.func_77659_a(world, player, hand);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void clientUse(ItemStack itemStack, PlayerEntity player) {
        CompoundNBT nbt = this.getModNBT(itemStack);
        if (!nbt.func_74764_b("world")) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent("integratednbt:nbt_extractor_remote.need_bind"), Util.field_240973_b_);
            return;
        }
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        if (world == null) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent("integratednbt:nbt_extractor_remote.invalid_bind"), Util.field_240973_b_);
            return;
        }
        if (!world.func_234923_W_().func_240901_a_().toString().equals(nbt.func_74779_i("world"))) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent("integratednbt:nbt_extractor_remote.require_dim"), Util.field_240973_b_);
            return;
        }
        BlockPos pos = new BlockPos(nbt.func_74762_e("x"), nbt.func_74762_e("y"), nbt.func_74762_e("z"));
        if (!world.isAreaLoaded(pos, 1)) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent("integratednbt:nbt_extractor_remote.require_load_client"), Util.field_240973_b_);
            return;
        }
        if (world.func_180495_p(pos).func_177230_c() != Additions.NBT_EXTRACTOR_BLOCK.get()) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent("integratednbt:nbt_extractor_remote.invalid_bind"), Util.field_240973_b_);
            return;
        }
        PacketHandler.INSTANCE.send(PacketDistributor.SERVER.noArg(), (Object)new NBTExtractorRemoteRequestMessage());
    }

    public CompoundNBT getModNBT(ItemStack itemStack) {
        return itemStack.func_190925_c("integratednbt");
    }

    public void serverUse(ItemStack itemStack, ServerPlayerEntity player) {
        CompoundNBT nbt = this.getModNBT(itemStack);
        if (!nbt.func_74764_b("world")) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent("integratednbt:nbt_extractor_remote.need_bind"), Util.field_240973_b_);
            return;
        }
        RegistryKey dimensionKey = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation(nbt.func_74779_i("world")));
        MinecraftServer server = player.func_184102_h();
        if (server == null) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent("integratednbt:nbt_extractor_remote.invalid_bind"), Util.field_240973_b_);
            return;
        }
        ServerWorld world = server.func_71218_a(dimensionKey);
        if (world == null) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent("integratednbt:nbt_extractor_remote.invalid_bind"), Util.field_240973_b_);
            return;
        }
        BlockPos pos = new BlockPos(nbt.func_74762_e("x"), nbt.func_74762_e("y"), nbt.func_74762_e("z"));
        if (!world.isAreaLoaded(pos, 1)) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent("integratednbt:nbt_extractor_remote.require_load_server"), Util.field_240973_b_);
            return;
        }
        if (world.func_180495_p(pos).func_177230_c() != Additions.NBT_EXTRACTOR_BLOCK.get()) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent("integratednbt:nbt_extractor_remote.invalid_bind"), Util.field_240973_b_);
            return;
        }
        ((NBTExtractor)Additions.NBT_EXTRACTOR_BLOCK.get()).playerAccess((World)world, pos, player);
    }

    @Nonnull
    public ActionResultType func_195939_a(ItemUseContext itemUseContext) {
        World world = itemUseContext.func_195991_k();
        BlockPos pos = itemUseContext.func_195995_a();
        PlayerEntity player = itemUseContext.func_195999_j();
        if (player == null) {
            return ActionResultType.FAIL;
        }
        Hand hand = itemUseContext.func_221531_n();
        if (world.func_180495_p(pos).func_177230_c() == Additions.NBT_EXTRACTOR_BLOCK.get()) {
            if (!world.field_72995_K) {
                ((NBTExtractorRemote)Additions.NBT_EXTRACTOR_REMOTE.get()).bindBlock(player.func_184586_b(hand), world, pos);
                player.func_145747_a((ITextComponent)new TranslationTextComponent("integratednbt:nbt_extractor_remote.bind_successful", new Object[]{String.valueOf(pos.func_177958_n()), String.valueOf(pos.func_177956_o()), String.valueOf(pos.func_177952_p())}), Util.field_240973_b_);
            }
        } else if (world.field_72995_K) {
            this.clientUse(player.func_184586_b(hand), player);
        }
        return ActionResultType.SUCCESS;
    }

    public void bindBlock(ItemStack itemStack, World world, BlockPos pos) {
        CompoundNBT nbt = this.getModNBT(itemStack);
        nbt.func_74778_a("world", world.func_234923_W_().func_240901_a_().toString());
        nbt.func_74768_a("x", pos.func_177958_n());
        nbt.func_74768_a("y", pos.func_177956_o());
        nbt.func_74768_a("z", pos.func_177952_p());
    }

    public void func_77624_a(ItemStack itemStack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        super.func_77624_a(itemStack, world, tooltip, flag);
        CompoundNBT nbt = this.getModNBT(itemStack);
        if (nbt.func_74764_b("world")) {
            tooltip.add((ITextComponent)new TranslationTextComponent("integratednbt:nbt_extractor_remote.tooltip.bound", new Object[]{String.valueOf(nbt.func_74762_e("x")), String.valueOf(nbt.func_74762_e("y")), String.valueOf(nbt.func_74762_e("z")), nbt.func_74779_i("world")}).func_240700_a_(style -> style.func_240712_a_(TextFormatting.GREEN)));
        } else {
            tooltip.add((ITextComponent)new TranslationTextComponent("integratednbt:nbt_extractor_remote.tooltip.not_bound"));
        }
        tooltip.add((ITextComponent)new TranslationTextComponent("integratednbt:nbt_extractor_remote.tooltip"));
    }
}

