/*
 * Decompiled with CFR 0.152.
 */
package com.dannyandson.tinyredstone.network;

import com.dannyandson.tinyredstone.api.IPanelCell;
import com.dannyandson.tinyredstone.blocks.PanelCellPos;
import com.dannyandson.tinyredstone.blocks.PanelTile;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;

public class PanelCellSync {
    private final BlockPos pos;
    private final int cellIndex;
    private final CompoundNBT nbt;

    public PanelCellSync(BlockPos pos, int cellIndex, CompoundNBT nbt) {
        this.pos = pos;
        this.cellIndex = cellIndex;
        this.nbt = nbt;
    }

    public PanelCellSync(PacketBuffer buffer) {
        this.pos = buffer.func_179259_c();
        this.cellIndex = buffer.readInt();
        this.nbt = buffer.func_150793_b();
    }

    public void toBytes(PacketBuffer buf) {
        buf.func_179255_a(this.pos);
        buf.writeInt(this.cellIndex);
        buf.func_150786_a(this.nbt);
    }

    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            PanelCellPos cellPos;
            IPanelCell cell;
            TileEntity te = Minecraft.func_71410_x().field_71441_e.func_175625_s(this.pos);
            if (te instanceof PanelTile && (cell = (cellPos = PanelCellPos.fromIndex((PanelTile)te, this.cellIndex)).getIPanelCell()) != null) {
                cell.readNBT(this.nbt);
            }
            ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
        });
        return true;
    }
}

