/*
 * Decompiled with CFR 0.152.
 */
package com.dannyandson.tinyredstone.items;

import com.dannyandson.tinyredstone.Config;
import com.dannyandson.tinyredstone.TinyRedstone;
import com.dannyandson.tinyredstone.api.IPanelCell;
import com.dannyandson.tinyredstone.blocks.PanelBlock;
import com.dannyandson.tinyredstone.blocks.PanelTile;
import com.dannyandson.tinyredstone.blocks.Side;
import com.dannyandson.tinyredstone.blocks.panelcells.TinyBlock;
import com.dannyandson.tinyredstone.blocks.panelcells.TransparentBlock;
import com.dannyandson.tinyredstone.gui.BlueprintGUI;
import com.dannyandson.tinyredstone.setup.ModSetup;
import com.dannyandson.tinyredstone.setup.Registration;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class Blueprint
extends Item {
    public Blueprint() {
        super(new Item.Properties().func_200916_a(ModSetup.ITEM_GROUP));
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> list, ITooltipFlag flags) {
        if (stack.func_77978_p() != null && stack.func_77978_p().func_74764_b("blueprint")) {
            list.add((ITextComponent)new TranslationTextComponent("message.item.blueprint.full"));
            List<ItemStack> blueprintItems = Blueprint.getRequiredItemStacks(stack.func_179543_a("blueprint"));
            for (ItemStack item : blueprintItems) {
                ITextComponent itemNameComponent = item.func_200301_q();
                String itemName = itemNameComponent.getString();
                list.add(ITextComponent.func_244388_a((String)(itemName + " : " + item.func_190916_E())));
            }
        } else {
            list.add((ITextComponent)new TranslationTextComponent("message.item.blueprint.empty"));
        }
    }

    @Nonnull
    public ActionResultType func_195939_a(ItemUseContext context) {
        TileEntity te = context.func_195991_k().func_175625_s(context.func_195995_a());
        PanelTile panelTile = null;
        if (te instanceof PanelTile) {
            panelTile = (PanelTile)te;
        } else if (((Boolean)Config.ALLOW_WORLD_PLACEMENT.get()).booleanValue()) {
            ItemStack itemStackCopy = context.func_195996_i().func_77946_l();
            BlockItemUseContext bpContext = new BlockItemUseContext(context);
            ((BlockItem)Registration.REDSTONE_PANEL_ITEM.get()).func_195942_a(bpContext);
            context.func_195999_j().func_184611_a(context.func_221531_n(), itemStackCopy);
            te = context.func_195991_k().func_175625_s(bpContext.func_195995_a());
            if (te instanceof PanelTile) {
                panelTile = (PanelTile)te;
            }
        }
        if (panelTile != null) {
            CompoundNBT blueprintNBT;
            if (context.func_195996_i().func_77978_p() != null && context.func_195996_i().func_77978_p().func_74764_b("blueprint")) {
                PlayerEntity player = context.func_195999_j();
                if (panelTile.getCellCount() == 0 && player != null) {
                    blueprintNBT = context.func_195996_i().func_179543_a("blueprint");
                    List<ItemStack> items = Blueprint.getRequiredItemStacks(blueprintNBT);
                    if (player.func_184812_l_() || Blueprint.playerHasSufficientComponents(items, player)) {
                        panelTile.loadCellsFromNBT(blueprintNBT, false);
                        panelTile.updateSide(Side.FRONT);
                        panelTile.updateSide(Side.RIGHT);
                        panelTile.updateSide(Side.BACK);
                        panelTile.updateSide(Side.LEFT);
                        panelTile.updateSide(Side.TOP);
                        panelTile.func_70296_d();
                        if (!player.func_184812_l_()) {
                            block0: for (ItemStack item : items) {
                                int itemsToRemove = item.func_190916_E();
                                for (ItemStack invStack : player.field_71071_by.field_70462_a) {
                                    if (Blueprint.stacksAreMatchingItem(invStack, item)) {
                                        int removeCt = Math.min(invStack.func_190916_E(), itemsToRemove);
                                        invStack.func_190920_e(invStack.func_190916_E() - removeCt);
                                        itemsToRemove -= removeCt;
                                    }
                                    if (itemsToRemove != 0) continue;
                                    continue block0;
                                }
                            }
                        }
                    }
                    panelTile.removeOutOfRange(player);
                }
            } else {
                CompoundNBT nbt = new CompoundNBT();
                blueprintNBT = panelTile.saveToNbt(new CompoundNBT());
                nbt.func_74768_a("CustomModelData", 1);
                nbt.func_218657_a("blueprint", (INBT)blueprintNBT);
                context.func_195996_i().func_77982_d(nbt);
            }
        }
        return ActionResultType.SUCCESS;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        if (worldIn.field_72995_K && ((Boolean)Config.JSON_BLUEPRINT.get()).booleanValue()) {
            BlueprintGUI.open(playerIn.func_184586_b(handIn));
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    private static List<ItemStack> getRequiredItemStacks(CompoundNBT blueprintNBT) {
        ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>();
        if (blueprintNBT.func_74764_b("cells")) {
            CompoundNBT cellsNBT = blueprintNBT.func_74775_l("cells");
            for (String key : cellsNBT.func_150296_c()) {
                try {
                    CompoundNBT cellDataNBT;
                    Class<?> iPanelCellClass = Class.forName(cellsNBT.func_74775_l(key).func_74779_i("class"));
                    if (!IPanelCell.class.isAssignableFrom(iPanelCellClass)) continue;
                    Item item = PanelBlock.getPanelCellItemFromClass(iPanelCellClass);
                    ItemStack itemStack = item.func_190903_i();
                    if ((iPanelCellClass == TinyBlock.class || iPanelCellClass == TransparentBlock.class) && (cellDataNBT = cellsNBT.func_74775_l(key).func_74775_l("data")).func_74764_b("made_from_namespace")) {
                        CompoundNBT madeFromTag = new CompoundNBT();
                        madeFromTag.func_74778_a("namespace", cellDataNBT.func_74779_i("made_from_namespace"));
                        madeFromTag.func_74778_a("path", cellDataNBT.func_74779_i("made_from_path"));
                        CompoundNBT itemTag = new CompoundNBT();
                        itemTag.func_218657_a("made_from", (INBT)madeFromTag);
                        itemStack.func_77982_d(itemTag);
                    }
                    boolean addNeeded = true;
                    for (ItemStack stack : itemStacks) {
                        if (!Blueprint.stacksAreMatchingItem(stack, itemStack)) continue;
                        stack.func_190920_e(stack.func_190916_E() + 1);
                        addNeeded = false;
                        break;
                    }
                    if (!addNeeded) continue;
                    itemStacks.add(itemStack);
                }
                catch (ClassNotFoundException e) {
                    TinyRedstone.LOGGER.error("Class not found exception while attempting to read components from blueprint NBT: " + e.getLocalizedMessage());
                }
            }
        }
        return itemStacks;
    }

    private static boolean playerHasSufficientComponents(List<ItemStack> itemStacks, PlayerEntity player) {
        for (ItemStack itemStack : itemStacks) {
            int count = 0;
            for (ItemStack invStack : player.field_71071_by.field_70462_a) {
                if (!Blueprint.stacksAreMatchingItem(invStack, itemStack)) continue;
                count += invStack.func_190916_E();
            }
            if (count >= itemStack.func_190916_E()) continue;
            return false;
        }
        return true;
    }

    private static boolean stacksAreMatchingItem(ItemStack stack1, ItemStack stack2) {
        return stack1.func_77973_b() == stack2.func_77973_b() && (!stack1.func_77942_o() && !stack2.func_77942_o() || stack1.func_77942_o() && stack1.func_77978_p().equals((Object)stack2.func_77978_p()));
    }

    @Nullable
    public static CompoundNBT cleanUpBlueprintNBT(CompoundNBT nbt) {
        CompoundNBT blueprintNBT;
        if (nbt.func_74764_b("blueprint") && (blueprintNBT = nbt.func_74775_l("blueprint")).func_74764_b("cells")) {
            CompoundNBT newCellsNBT = new CompoundNBT();
            CompoundNBT cellsNBT = blueprintNBT.func_74775_l("cells");
            for (String key : cellsNBT.func_150296_c()) {
                try {
                    if (!IPanelCell.class.isAssignableFrom(Class.forName(cellsNBT.func_74775_l(key).func_74779_i("class")))) continue;
                    newCellsNBT.func_218657_a(key, (INBT)cellsNBT.func_74775_l(key));
                }
                catch (ClassNotFoundException e) {
                    TinyRedstone.LOGGER.error("Class not found exception while attempting to read components from blueprint NBT: " + e.getLocalizedMessage());
                }
            }
            CompoundNBT newNBT = new CompoundNBT();
            CompoundNBT newBlueprintNBT = new CompoundNBT();
            newNBT.func_74768_a("CustomModelData", 1);
            newBlueprintNBT.func_218657_a("cells", (INBT)newCellsNBT);
            newNBT.func_218657_a("blueprint", (INBT)newBlueprintNBT);
            if (nbt.func_74764_b("display")) {
                newNBT.func_218657_a("display", (INBT)nbt.func_74775_l("display"));
            }
            return newNBT;
        }
        return null;
    }
}

