/*
 * Decompiled with CFR 0.152.
 */
package com.dannyandson.tinyredstone.gui;

import com.dannyandson.tinyredstone.TinyRedstone;
import com.dannyandson.tinyredstone.gui.ModWidget;
import com.dannyandson.tinyredstone.items.Blueprint;
import com.dannyandson.tinyredstone.network.BlueprintSync;
import com.dannyandson.tinyredstone.network.ModNetworkHandler;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Scanner;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.util.tinyfd.TinyFileDialogs;

public class BlueprintGUI
extends Screen {
    private static final int WIDTH = 120;
    private static final int HEIGHT = 90;
    private final ResourceLocation GUI = new ResourceLocation("tinyredstone", "textures/gui/transparent.png");
    private final ItemStack blueprint;
    private boolean dialogOpen = false;
    private Widget button;

    protected BlueprintGUI(ItemStack blueprint) {
        super((ITextComponent)new TranslationTextComponent("tinyredstone.gui.blueprint.msg"));
        this.blueprint = blueprint;
    }

    protected void func_231160_c_() {
        int relX = (this.field_230708_k_ - 120) / 2;
        int relY = (this.field_230709_l_ - 90) / 2;
        this.func_230480_a_(new ModWidget(relX - 1, relY - 1, 122, 92, -1442840576));
        this.func_230480_a_(new ModWidget(relX, relY, 120, 90, -1997607186));
        this.func_230480_a_((Widget)new Button(relX + 20, relY + 50, 80, 20, (ITextComponent)new TranslationTextComponent("tinyredstone.close"), button -> this.close()));
        this.button = this.blueprint.func_77942_o() ? new Button(relX + 20, relY + 20, 80, 20, (ITextComponent)new TranslationTextComponent("tinyredstone.export"), button -> this.exportToFile()) : new Button(relX + 20, relY + 20, 80, 20, (ITextComponent)new TranslationTextComponent("tinyredstone.import"), button -> this.importFromFile());
        this.func_230480_a_(this.button);
    }

    private void close() {
        this.field_230706_i_.func_147108_a(null);
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        RenderSystem.blendColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_230706_i_.func_110434_K().func_110577_a(this.GUI);
        int relX = (this.field_230708_k_ - 120) / 2;
        int relY = (this.field_230709_l_ - 90) / 2;
        this.func_238474_b_(matrixStack, relX, relY, 0, 0, 120, 90);
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
    }

    public static void open(ItemStack blueprint) {
        Minecraft.func_71410_x().func_147108_a((Screen)new BlueprintGUI(blueprint));
    }

    public void exportToFile() {
        if (!this.dialogOpen) {
            this.dialogOpen = true;
            this.field_230710_m_.remove(this.button);
            this.field_230710_m_.add(new ModWidget((this.field_230708_k_ - 120) / 2 + 20, (this.field_230709_l_ - 90) / 2 + 20, 80, 20, -12303292));
            new Thread(() -> {
                MemoryStack stack = MemoryStack.stackPush();
                PointerBuffer filters = stack.mallocPointer(1);
                filters.put(stack.UTF8((CharSequence)"*.json"));
                filters.flip();
                String path = TinyFileDialogs.tinyfd_saveFileDialog((CharSequence)new TranslationTextComponent("tinyredstone.save_file").getString(), (CharSequence)"blueprint.json", (PointerBuffer)filters, null);
                this.dialogOpen = false;
                stack.pop();
                if (path != null) {
                    try {
                        File file = new File(path);
                        if (file.createNewFile()) {
                            FileWriter writer = new FileWriter(path);
                            writer.write(this.blueprint.func_77978_p().toString());
                            writer.close();
                        }
                    }
                    catch (IOException e) {
                        TinyRedstone.LOGGER.error("IOException attempting to save blueprint json to file: " + e.getLocalizedMessage());
                    }
                }
            }).start();
        }
    }

    public void importFromFile() {
        if (!this.dialogOpen) {
            this.dialogOpen = true;
            this.field_230710_m_.remove(this.button);
            this.field_230710_m_.add(new ModWidget((this.field_230708_k_ - 120) / 2 + 20, (this.field_230709_l_ - 90) / 2 + 20, 80, 20, -12303292));
            new Thread(() -> {
                MemoryStack stack = MemoryStack.stackPush();
                PointerBuffer filters = stack.mallocPointer(2);
                filters.put(stack.UTF8((CharSequence)""));
                filters.put(stack.UTF8((CharSequence)"*.json"));
                filters.flip();
                String path = TinyFileDialogs.tinyfd_openFileDialog((CharSequence)new TranslationTextComponent("tinyredstone.choose_file").getString(), null, (PointerBuffer)filters, (CharSequence)"JSON File (*.json)", (boolean)false);
                this.dialogOpen = false;
                stack.pop();
                if (path != null) {
                    StringBuilder data = new StringBuilder();
                    try {
                        File file = new File(path);
                        Scanner scanner = new Scanner(file);
                        while (scanner.hasNextLine()) {
                            data.append(scanner.nextLine());
                        }
                        scanner.close();
                    }
                    catch (FileNotFoundException e) {
                        TinyRedstone.LOGGER.error("FileNotFoundException attempting to load blueprint json to file: " + e.getLocalizedMessage());
                    }
                    try {
                        CompoundNBT nbt = JsonToNBT.func_180713_a((String)data.toString());
                        CompoundNBT cleanNBT = Blueprint.cleanUpBlueprintNBT(nbt);
                        if (cleanNBT != null) {
                            this.blueprint.func_77982_d(cleanNBT);
                            ModNetworkHandler.sendToServer(new BlueprintSync(cleanNBT));
                        }
                    }
                    catch (CommandSyntaxException e) {
                        TinyRedstone.LOGGER.error("CommandSyntaxException reading JSON from user file: " + e.getLocalizedMessage());
                    }
                }
            }).start();
        }
    }
}

