/*
 * Decompiled with CFR 0.152.
 */
package com.dannyandson.tinyredstone.compat.theoneprobe;

import com.dannyandson.tinyredstone.Config;
import com.dannyandson.tinyredstone.api.IPanelCell;
import com.dannyandson.tinyredstone.api.IPanelCellInfoProvider;
import com.dannyandson.tinyredstone.blocks.PanelBlock;
import com.dannyandson.tinyredstone.blocks.PanelCellPos;
import com.dannyandson.tinyredstone.blocks.PanelCellSegment;
import com.dannyandson.tinyredstone.blocks.PanelTile;
import com.dannyandson.tinyredstone.blocks.PosInPanelCell;
import com.dannyandson.tinyredstone.blocks.Side;
import com.dannyandson.tinyredstone.compat.CompatHandler;
import com.dannyandson.tinyredstone.compat.theoneprobe.OverlayBlockInfo;
import java.util.function.Function;
import mcjty.theoneprobe.Tools;
import mcjty.theoneprobe.api.CompoundText;
import mcjty.theoneprobe.api.ElementAlignment;
import mcjty.theoneprobe.api.IBlockDisplayOverride;
import mcjty.theoneprobe.api.ILayoutStyle;
import mcjty.theoneprobe.api.IProbeConfig;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.ITheOneProbe;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.api.TextStyleClass;
import mcjty.theoneprobe.apiimpl.styles.LayoutStyle;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class PanelProvider
implements IBlockDisplayOverride,
Function<ITheOneProbe, Void>,
IProbeInfoProvider {
    private IProbeConfig.ConfigMode redstoneMode;

    public String getID() {
        return "tinyredstone:panel";
    }

    @Override
    public Void apply(ITheOneProbe theOneProbe) {
        theOneProbe.registerBlockDisplayOverride((IBlockDisplayOverride)this);
        theOneProbe.registerProvider((IProbeInfoProvider)this);
        return null;
    }

    private boolean show(ProbeMode probeMode, PlayerEntity playerEntity) {
        switch ((Integer)Config.DISPLAY_MODE.get()) {
            case 0: {
                return probeMode == ProbeMode.DEBUG;
            }
            case 1: {
                break;
            }
            case 2: {
                if (probeMode != ProbeMode.NORMAL) break;
                return false;
            }
            case 3: {
                if (probeMode == ProbeMode.DEBUG) break;
                return CompatHandler.isMeasuringDevice(playerEntity.func_184614_ca().func_77973_b());
            }
            case 4: {
                if (probeMode == ProbeMode.DEBUG) break;
                return CompatHandler.isTinyComponent(playerEntity.func_184614_ca().func_77973_b());
            }
        }
        return true;
    }

    public boolean overrideStandardInfo(ProbeMode probeMode, IProbeInfo probeInfo, PlayerEntity playerEntity, World world, BlockState blockState, IProbeHitData probeHitData) {
        BlockPos pos = probeHitData.getPos();
        TileEntity tileEntity = world.func_175625_s(pos);
        IProbeConfig config = mcjty.theoneprobe.config.Config.getRealConfig();
        if (tileEntity instanceof PanelTile && this.show(probeMode, playerEntity)) {
            if (this.redstoneMode == null) {
                this.redstoneMode = config.getShowRedstone();
            }
            config.showRedstone(IProbeConfig.ConfigMode.NOT);
            PanelTile panelTile = (PanelTile)tileEntity;
            Block block = blockState.func_177230_c();
            if (!panelTile.isCovered() && block instanceof PanelBlock) {
                IPanelCell panelCell;
                PanelBlock panelBlock = (PanelBlock)block;
                BlockRayTraceResult result = panelTile.getPlayerCollisionHitResult(playerEntity);
                PanelCellPos panelCellPos = PanelCellPos.fromHitVec(panelTile, (Direction)blockState.func_177229_b((Property)BlockStateProperties.field_208155_H), result);
                if (panelCellPos != null && (panelCell = panelCellPos.getIPanelCell()) != null) {
                    String modName = Tools.getModName((IForgeRegistryEntry)block);
                    Item item = panelBlock.getItemByIPanelCell(panelCell.getClass());
                    ItemStack itemStack = item.func_190903_i();
                    CompoundNBT itemTag = panelCell.getItemTag();
                    if (itemTag != null) {
                        for (String key : itemTag.func_150296_c()) {
                            itemStack.func_77983_a(key, itemTag.func_74781_a(key));
                        }
                    }
                    if (Tools.show((ProbeMode)probeMode, (IProbeConfig.ConfigMode)config.getShowModName())) {
                        probeInfo.horizontal().item(itemStack).vertical().itemLabel(itemStack).text(CompoundText.create().style(TextStyleClass.MODNAME).text(modName));
                    } else {
                        probeInfo.horizontal(probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER)).item(itemStack).itemLabel(itemStack);
                    }
                    return true;
                }
            }
        } else if (this.redstoneMode != null) {
            config.showRedstone(this.redstoneMode);
            this.redstoneMode = null;
        }
        return false;
    }

    public void addProbeInfo(ProbeMode probeMode, IProbeInfo probeInfo, PlayerEntity playerEntity, World world, BlockState blockState, IProbeHitData probeHitData) {
        BlockPos pos = probeHitData.getPos();
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof PanelTile && this.show(probeMode, playerEntity)) {
            PanelTile panelTile = (PanelTile)tileEntity;
            if (!panelTile.isCovered()) {
                BlockRayTraceResult rtr = panelTile.getPlayerCollisionHitResult(playerEntity);
                PosInPanelCell posInPanelCell = PosInPanelCell.fromHitVec(panelTile, pos, rtr);
                if (posInPanelCell != null) {
                    IPanelCell panelCell;
                    if (probeMode == ProbeMode.DEBUG) {
                        int cellIndex = posInPanelCell.getIndex();
                        PanelCellSegment segment = posInPanelCell.getSegment();
                        probeInfo.vertical((ILayoutStyle)new LayoutStyle().borderColor(Integer.valueOf(-12255420)).spacing(2)).text(CompoundText.createLabelInfo((String)"X: ", (Object)posInPanelCell.getX())).text(CompoundText.createLabelInfo((String)"Z: ", (Object)posInPanelCell.getZ())).text(CompoundText.createLabelInfo((String)"Y: ", (Object)posInPanelCell.getY())).text(CompoundText.createLabelInfo((String)"Row: ", (Object)posInPanelCell.getRow())).text(CompoundText.createLabelInfo((String)"Column: ", (Object)posInPanelCell.getColumn())).text(CompoundText.createLabelInfo((String)"Level: ", (Object)posInPanelCell.getLevel())).text(CompoundText.createLabelInfo((String)"Index: ", (Object)cellIndex)).text(CompoundText.createLabelInfo((String)"Segment: ", (Object)((Object)segment))).text(CompoundText.createLabelInfo((String)"Facing: ", (Object)((Object)posInPanelCell.getCellFacing())));
                    }
                    if ((panelCell = posInPanelCell.getIPanelCell()) != null) {
                        boolean handled = false;
                        if (panelCell instanceof IPanelCellInfoProvider) {
                            OverlayBlockInfo overlayBlockInfo = new OverlayBlockInfo(probeInfo, probeMode);
                            ((IPanelCellInfoProvider)((Object)panelCell)).addInfo(overlayBlockInfo, panelTile, posInPanelCell);
                            if (overlayBlockInfo.power > -1) {
                                handled = true;
                                PanelProvider.showRedstonePower(probeInfo, overlayBlockInfo.power);
                            }
                        }
                        if (!handled) {
                            Side sideHit = panelTile.getPanelCellSide((PanelCellPos)posInPanelCell, panelTile.getSideFromDirection(probeHitData.getSideHit()));
                            PanelProvider.showRedstonePower(probeInfo, panelCell.getWeakRsOutput(sideHit));
                        }
                    }
                } else {
                    PanelProvider.showBlockRedstonePower(probeInfo, probeMode, this.redstoneMode, world, pos, probeHitData.getSideHit());
                }
            } else {
                PanelProvider.showBlockRedstonePower(probeInfo, probeMode, this.redstoneMode, world, pos, probeHitData.getSideHit());
            }
        }
    }

    private static void showBlockRedstonePower(IProbeInfo probeInfo, ProbeMode probeMode, IProbeConfig.ConfigMode redstoneMode, World world, BlockPos pos, Direction sideHit) {
        if (Tools.show((ProbeMode)probeMode, (IProbeConfig.ConfigMode)redstoneMode)) {
            PanelProvider.showRedstonePower(probeInfo, world.func_175651_c(pos, sideHit.func_176734_d()));
        }
    }

    private static void showRedstonePower(IProbeInfo probeInfo, int power) {
        if (power > 0) {
            probeInfo.horizontal().item(new ItemStack((IItemProvider)Items.field_151137_ax), probeInfo.defaultItemStyle().width(14).height(14)).text(CompoundText.createLabelInfo((String)"Power: ", (Object)power));
        }
    }
}

