/*
 * Decompiled with CFR 0.152.
 */
package com.dannyandson.tinyredstone.blocks.panelcovers;

import com.dannyandson.tinyredstone.api.IPanelCover;
import com.dannyandson.tinyredstone.blocks.PanelCellPos;
import com.dannyandson.tinyredstone.blocks.PanelTile;
import com.dannyandson.tinyredstone.blocks.RenderHelper;
import com.dannyandson.tinyredstone.blocks.panelcovers.DarkCover;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3f;

public class TrimCover
implements IPanelCover {
    private VoxelShape shape = null;
    private Float xMin = null;
    private Float xMax = null;
    private Float yMin = null;
    private Float yMax = null;
    private Float zMin = null;
    private Float zMax = null;
    private TextureAtlasSprite sprite;

    @Override
    public void onPlace(PanelTile panelTile, PlayerEntity player) {
        List<PanelCellPos> cellPosList = panelTile.getCellPositions();
        if (cellPosList.size() == 0) {
            this.setDefaultBoundaries();
        } else {
            Integer xMin = null;
            Integer xMax = null;
            Integer yMin = null;
            Integer yMax = null;
            Integer zMin = null;
            Integer zMax = null;
            boolean hasBase = panelTile.hasBase();
            for (PanelCellPos cellPos : cellPosList) {
                int y;
                if (xMin == null || cellPos.getRow() < xMin) {
                    xMin = cellPos.getRow();
                }
                if (xMax == null || cellPos.getRow() > xMax) {
                    xMax = cellPos.getRow();
                }
                int n = !hasBase ? cellPos.getLevel() : (y = cellPos.getLevel() == 0 ? 0 : cellPos.getLevel() + 1);
                if (yMin == null || y < yMin) {
                    yMin = y;
                }
                int n2 = y = !hasBase ? cellPos.getLevel() : cellPos.getLevel() + 1;
                if (yMax == null || y > yMax) {
                    yMax = y;
                }
                if (zMin == null || cellPos.getColumn() < zMin) {
                    zMin = cellPos.getColumn();
                }
                if (zMax != null && cellPos.getColumn() <= zMax) continue;
                zMax = cellPos.getColumn();
            }
            this.xMin = Float.valueOf((float)xMin.intValue() / 8.0f);
            this.xMax = Float.valueOf((float)(xMax + 1) / 8.0f);
            this.yMin = Float.valueOf((float)yMin.intValue() / 8.0f);
            this.yMax = Float.valueOf((float)(yMax + 1) / 8.0f);
            this.zMin = Float.valueOf((float)zMin.intValue() / 8.0f);
            this.zMax = Float.valueOf((float)(zMax + 1) / 8.0f);
        }
    }

    @Override
    public void render(MatrixStack matrixStack, IRenderTypeBuffer buffer, int combinedLight, int combinedOverlay, int color) {
        if (this.xMin == null) {
            this.setDefaultBoundaries();
        }
        if (this.sprite == null) {
            this.sprite = RenderHelper.getSprite(DarkCover.TEXTURE_DEFAULT_COVER);
        }
        matrixStack.func_227861_a_(0.0, 0.0, (double)this.zMax.floatValue());
        RenderHelper.drawRectangle(buffer.getBuffer(RenderType.func_228639_c_()), matrixStack, this.xMin.floatValue(), this.xMax.floatValue(), this.yMin.floatValue(), this.yMax.floatValue(), this.sprite, combinedLight, color, 1.0f);
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(90.0f));
        matrixStack.func_227861_a_(0.0, 0.0, (double)this.xMax.floatValue());
        RenderHelper.drawRectangle(buffer.getBuffer(RenderType.func_228639_c_()), matrixStack, 0.0f, this.zMax.floatValue() - this.zMin.floatValue(), this.yMin.floatValue(), this.yMax.floatValue(), this.sprite, combinedLight, color, 1.0f);
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(90.0f));
        matrixStack.func_227861_a_(0.0, 0.0, (double)(this.zMax.floatValue() - this.zMin.floatValue()));
        RenderHelper.drawRectangle(buffer.getBuffer(RenderType.func_228639_c_()), matrixStack, 0.0f, this.xMax.floatValue() - this.xMin.floatValue(), 0.0f, this.yMax.floatValue() - this.yMin.floatValue(), this.sprite, combinedLight, color, 1.0f);
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(90.0f));
        matrixStack.func_227861_a_(0.0, 0.0, (double)(this.xMax.floatValue() - this.xMin.floatValue()));
        RenderHelper.drawRectangle(buffer.getBuffer(RenderType.func_228639_c_()), matrixStack, 0.0f, this.zMax.floatValue() - this.zMin.floatValue(), 0.0f, this.yMax.floatValue() - this.yMin.floatValue(), this.sprite, combinedLight, color, 1.0f);
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(90.0f));
        matrixStack.func_227861_a_(0.0, (double)(this.xMin.floatValue() - this.xMax.floatValue()), 0.0);
        RenderHelper.drawRectangle(buffer.getBuffer(RenderType.func_228639_c_()), matrixStack, 0.0f, this.zMax.floatValue() - this.zMin.floatValue(), 0.0f, this.xMax.floatValue() - this.xMin.floatValue(), this.sprite, combinedLight, color, 1.0f);
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(180.0f));
        matrixStack.func_227861_a_(0.0, (double)(this.xMin.floatValue() - this.xMax.floatValue()), (double)(this.yMax.floatValue() - this.yMin.floatValue()));
        RenderHelper.drawRectangle(buffer.getBuffer(RenderType.func_228639_c_()), matrixStack, 0.0f, this.zMax.floatValue() - this.zMin.floatValue(), 0.0f, this.xMax.floatValue() - this.xMin.floatValue(), this.sprite, combinedLight, color, 1.0f);
    }

    @Override
    public boolean allowsLightOutput() {
        return false;
    }

    @Override
    public CompoundNBT writeNBT() {
        CompoundNBT tag = new CompoundNBT();
        tag.func_74776_a("xMin", this.xMin.floatValue());
        tag.func_74776_a("xMax", this.xMax.floatValue());
        tag.func_74776_a("yMin", this.yMin.floatValue());
        tag.func_74776_a("yMax", this.yMax.floatValue());
        tag.func_74776_a("zMin", this.zMin.floatValue());
        tag.func_74776_a("zMax", this.zMax.floatValue());
        return tag;
    }

    @Override
    public void readNBT(CompoundNBT compoundNBT) {
        this.xMin = Float.valueOf(compoundNBT.func_74760_g("xMin"));
        this.xMax = Float.valueOf(compoundNBT.func_74760_g("xMax"));
        this.yMin = Float.valueOf(compoundNBT.func_74760_g("yMin"));
        this.yMax = Float.valueOf(compoundNBT.func_74760_g("yMax"));
        this.zMin = Float.valueOf(compoundNBT.func_74760_g("zMin"));
        this.zMax = Float.valueOf(compoundNBT.func_74760_g("zMax"));
    }

    public void setDefaultBoundaries() {
        this.xMin = Float.valueOf(0.0f);
        this.xMax = Float.valueOf(1.0f);
        this.yMin = Float.valueOf(0.0f);
        this.yMax = Float.valueOf(1.0f);
        this.zMin = Float.valueOf(0.0f);
        this.zMax = Float.valueOf(1.0f);
    }

    @Override
    public VoxelShape getShape() {
        if (this.shape == null) {
            if (this.xMin == null) {
                this.setDefaultBoundaries();
            }
            this.shape = VoxelShapes.func_197873_a((double)this.xMin.floatValue(), (double)this.yMin.floatValue(), (double)this.zMin.floatValue(), (double)this.xMax.floatValue(), (double)this.yMax.floatValue(), (double)this.zMax.floatValue());
        }
        return this.shape;
    }
}

