/*
 * Decompiled with CFR 0.152.
 */
package com.dannyandson.tinyredstone.blocks.panelcovers;

import com.dannyandson.tinyredstone.api.IPanelCover;
import com.dannyandson.tinyredstone.blocks.PanelTile;
import com.dannyandson.tinyredstone.blocks.RenderHelper;
import com.dannyandson.tinyredstone.blocks.Side;
import com.dannyandson.tinyredstone.setup.Registration;
import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;

public class DarkCover
implements IPanelCover {
    public static ResourceLocation TEXTURE_DEFAULT_COVER = new ResourceLocation("tinyredstone", "block/dark_cover");
    protected ResourceLocation madeFrom;
    protected TextureAtlasSprite sprite_top;
    protected TextureAtlasSprite sprite_front;
    protected TextureAtlasSprite sprite_right;
    protected TextureAtlasSprite sprite_back;
    protected TextureAtlasSprite sprite_left;
    protected TextureAtlasSprite sprite_bottom;
    private float x1 = 0.0f;
    private float x2 = 1.0f;
    private float y1 = 0.0f;
    private float y2 = 1.0f;

    @Override
    public void render(MatrixStack matrixStack, IRenderTypeBuffer buffer, int combinedLight, int combinedOverlay, int color) {
        if (this.sprite_top == null) {
            if (this.madeFrom != null) {
                this.sprite_top = Registration.TINY_BLOCK_OVERRIDES.getSprite(this.madeFrom, Side.TOP);
                this.sprite_front = Registration.TINY_BLOCK_OVERRIDES.getSprite(this.madeFrom, Side.FRONT);
                this.sprite_right = Registration.TINY_BLOCK_OVERRIDES.getSprite(this.madeFrom, Side.RIGHT);
                this.sprite_back = Registration.TINY_BLOCK_OVERRIDES.getSprite(this.madeFrom, Side.BACK);
                this.sprite_left = Registration.TINY_BLOCK_OVERRIDES.getSprite(this.madeFrom, Side.LEFT);
                this.sprite_bottom = Registration.TINY_BLOCK_OVERRIDES.getSprite(this.madeFrom, Side.BOTTOM);
            } else {
                this.sprite_left = this.sprite_bottom = RenderHelper.getSprite(this.getDefaultResourceLocation());
                this.sprite_back = this.sprite_bottom;
                this.sprite_right = this.sprite_bottom;
                this.sprite_front = this.sprite_bottom;
                this.sprite_top = this.sprite_bottom;
            }
        }
        TextureAtlasSprite sprite = RenderHelper.getSprite(TEXTURE_DEFAULT_COVER);
        matrixStack.func_227861_a_(0.0, (double)this.y2, 1.0);
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(270.0f));
        RenderHelper.drawCube(matrixStack, buffer.getBuffer(RenderType.func_228639_c_()), this.sprite_top, this.sprite_front, this.sprite_right, this.sprite_back, this.sprite_left, this.sprite_bottom, combinedLight, combinedOverlay, this.madeFrom != null ? 0xFFFFFF : color, 1.0f);
    }

    protected ResourceLocation getDefaultResourceLocation() {
        return TEXTURE_DEFAULT_COVER;
    }

    @Override
    public void onPlace(PanelTile panelTile, PlayerEntity player) {
        CompoundNBT itemNBT;
        CompoundNBT madeFromTag;
        ItemStack stack = ItemStack.field_190927_a;
        if (player.func_184600_cs() != null) {
            stack = player.func_184586_b(player.func_184600_cs());
        }
        if (stack == ItemStack.field_190927_a) {
            stack = player.func_184614_ca();
        }
        if (stack.func_77942_o() && (madeFromTag = (itemNBT = stack.func_77978_p()).func_74775_l("made_from")).func_74764_b("namespace")) {
            this.madeFrom = new ResourceLocation(madeFromTag.func_74779_i("namespace"), madeFromTag.func_74779_i("path"));
        }
    }

    @Override
    public boolean allowsLightOutput() {
        return false;
    }

    @Override
    public CompoundNBT writeNBT() {
        CompoundNBT nbt = new CompoundNBT();
        if (this.madeFrom != null) {
            nbt.func_74778_a("made_from_namespace", this.madeFrom.func_110624_b());
            nbt.func_74778_a("made_from_path", this.madeFrom.func_110623_a());
        }
        return nbt;
    }

    @Override
    public void readNBT(CompoundNBT compoundNBT) {
        if (compoundNBT.func_74764_b("made_from_namespace")) {
            this.madeFrom = new ResourceLocation(compoundNBT.func_74779_i("made_from_namespace"), compoundNBT.func_74779_i("made_from_path"));
        }
    }

    @Override
    public CompoundNBT getItemTag() {
        if (this.madeFrom != null) {
            CompoundNBT madeFromTag = new CompoundNBT();
            madeFromTag.func_74778_a("namespace", this.madeFrom.func_110624_b());
            madeFromTag.func_74778_a("path", this.madeFrom.func_110623_a());
            CompoundNBT itemTag = new CompoundNBT();
            itemTag.func_218657_a("made_from", (INBT)madeFromTag);
            return itemTag;
        }
        return null;
    }
}

