/*
 * Decompiled with CFR 0.152.
 */
package com.dannyandson.tinyredstone.blocks;

import com.dannyandson.tinyredstone.TinyRedstone;
import com.dannyandson.tinyredstone.api.IPanelCell;
import com.dannyandson.tinyredstone.blocks.PanelBlock;
import com.dannyandson.tinyredstone.blocks.PanelCellGhostPos;
import com.dannyandson.tinyredstone.blocks.PanelCellPos;
import com.dannyandson.tinyredstone.blocks.PanelCellSegment;
import com.dannyandson.tinyredstone.blocks.PanelTile;
import com.dannyandson.tinyredstone.blocks.PosInPanelCell;
import com.dannyandson.tinyredstone.blocks.RenderHelper;
import com.dannyandson.tinyredstone.blocks.RotationLock;
import com.dannyandson.tinyredstone.blocks.Side;
import com.dannyandson.tinyredstone.blocks.panelcells.GhostRenderer;
import com.dannyandson.tinyredstone.blocks.panelcells.RedstoneDust;
import com.dannyandson.tinyredstone.setup.Registration;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import javax.annotation.CheckForNull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.fml.client.registry.ClientRegistry;

public class PanelTileRenderer
extends TileEntityRenderer<PanelTile> {
    public static ResourceLocation TEXTURE = new ResourceLocation("tinyredstone", "block/redstone_panel");
    public static ResourceLocation TEXTURE_CRASHED = new ResourceLocation("tinyredstone", "block/redstone_panel_crashed");
    private static final float scale = 0.125f;
    private static final float t2X = 0.0f;
    private static final float t2Y = -1.0f;
    private static final float t2Z = 0.0f;
    private static final float rotation1 = 270.0f;
    private double cellSize = 0.125;

    public PanelTileRenderer(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    public void render(PanelTile tileEntity, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer buffer, int combinedLight, int combinedOverlay) {
        Boolean hasBase = tileEntity.hasBase();
        matrixStack.func_227860_a_();
        switch ((Direction)tileEntity.func_195044_w().func_177229_b((Property)BlockStateProperties.field_208155_H)) {
            case UP: {
                matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(180.0f));
                matrixStack.func_227861_a_(0.0, -1.0, -1.0);
                break;
            }
            case NORTH: {
                matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(90.0f));
                matrixStack.func_227861_a_(0.0, 0.0, -1.0);
                break;
            }
            case EAST: {
                matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(90.0f));
                matrixStack.func_227861_a_(0.0, -1.0, 0.0);
                break;
            }
            case SOUTH: {
                matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(-90.0f));
                matrixStack.func_227861_a_(0.0, -1.0, 0.0);
                break;
            }
            case WEST: {
                matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(-90.0f));
                matrixStack.func_227861_a_(-1.0, 0.0, 0.0);
            }
        }
        TextureAtlasSprite sprite = RenderHelper.getSprite(TEXTURE);
        IVertexBuilder builder = buffer.getBuffer(RenderType.func_228639_c_());
        if (tileEntity.isCovered()) {
            matrixStack.func_227860_a_();
            tileEntity.panelCover.render(matrixStack, buffer, combinedLight, combinedOverlay, tileEntity.getColor());
            matrixStack.func_227865_b_();
        } else {
            if (hasBase.booleanValue()) {
                int color = tileEntity.getColor();
                matrixStack.func_227860_a_();
                matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(270.0f));
                matrixStack.func_227861_a_(0.0, -1.0, 0.125);
                RenderHelper.drawRectangle(builder, matrixStack, 0.0f, 1.0f, 0.0f, 1.0f, sprite, combinedLight, color, 1.0f);
                matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(90.0f));
                matrixStack.func_227861_a_(0.0, -0.125, 0.0);
                RenderHelper.drawRectangle(builder, matrixStack, 0.0f, 1.0f, 0.0f, 0.125f, sprite, combinedLight, color, 1.0f);
                matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(90.0f));
                matrixStack.func_227861_a_(0.0, 0.0, 1.0);
                RenderHelper.drawRectangle(builder, matrixStack, 0.0f, 1.0f, 0.0f, 0.125f, sprite, combinedLight, color, 1.0f);
                matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(90.0f));
                matrixStack.func_227861_a_(0.0, 0.0, 1.0);
                RenderHelper.drawRectangle(builder, matrixStack, 0.0f, 1.0f, 0.0f, 0.125f, sprite, combinedLight, color, 1.0f);
                matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(90.0f));
                matrixStack.func_227861_a_(0.0, 0.0, 1.0);
                RenderHelper.drawRectangle(builder, matrixStack, 0.0f, 1.0f, 0.0f, 0.125f, sprite, combinedLight, color, 1.0f);
                matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(90.0f));
                matrixStack.func_227861_a_(0.0, -1.0, 0.0);
                RenderHelper.drawRectangle(builder, matrixStack, 0.0f, 1.0f, 0.0f, 1.0f, sprite, combinedLight, color, 1.0f);
                matrixStack.func_227865_b_();
            }
            List<PanelCellPos> positions = tileEntity.getCellPositions();
            for (PanelCellPos pos : positions) {
                IPanelCell panelCell = pos.getIPanelCell();
                if (panelCell == null) continue;
                this.renderCell(matrixStack, pos, buffer, tileEntity.isCrashed() ? 0 : combinedLight, combinedOverlay, tileEntity.isCrashed() ? 0.5f : 1.0f, hasBase);
            }
            if (tileEntity.panelCellGhostPos != null) {
                this.renderCell(matrixStack, tileEntity.panelCellGhostPos, buffer, combinedLight, combinedOverlay, 0.5f, hasBase);
            }
        }
        if (tileEntity.isCrashed() || tileEntity.isOverflown()) {
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_(0.0, 0.126, 1.0);
            matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(270.0f));
            sprite = RenderHelper.getSprite(TEXTURE_CRASHED);
            RenderHelper.drawRectangle(buffer.getBuffer(Minecraft.func_238218_y_() ? RenderType.func_228639_c_() : RenderType.func_228645_f_()), matrixStack, 0.0f, 1.0f, 0.0f, 1.0f, sprite, combinedLight, combinedOverlay, 0.9f);
            matrixStack.func_227865_b_();
        }
        matrixStack.func_227865_b_();
    }

    private void renderCell(MatrixStack matrixStack, PanelCellPos pos, IRenderTypeBuffer buffer, int combinedLight, int combinedOverlay, float alpha, boolean hasBase) {
        alpha = Minecraft.func_238218_y_() ? 1.0f : alpha;
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(this.cellSize * (double)pos.getRow(), (hasBase ? 0.125 : 0.0) + (double)pos.getLevel() * 0.125, this.cellSize * (double)pos.getColumn());
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(270.0f));
        Side facing = pos.getCellFacing();
        if (facing == Side.LEFT) {
            matrixStack.func_227861_a_(0.0, -this.cellSize, 0.0);
            matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(90.0f));
        } else if (facing == Side.BACK) {
            matrixStack.func_227861_a_(this.cellSize, -this.cellSize, 0.0);
            matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(180.0f));
        } else if (facing == Side.RIGHT) {
            matrixStack.func_227861_a_(this.cellSize, 0.0, 0.0);
            matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(270.0f));
        } else if (pos.getCellFacing() == Side.BOTTOM) {
            matrixStack.func_227861_a_(0.0, -this.cellSize, 0.0);
            matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(-90.0f));
        } else if (pos.getCellFacing() == Side.TOP) {
            matrixStack.func_227861_a_(0.0, 0.0, this.cellSize);
            matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(90.0f));
        }
        matrixStack.func_227862_a_(0.125f, 0.125f, 0.125f);
        matrixStack.func_227861_a_(0.0, -1.0, 0.0);
        pos.getIPanelCell().render(matrixStack, buffer, combinedLight, combinedOverlay, alpha);
        matrixStack.func_227865_b_();
    }

    public static void register() {
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)Registration.REDSTONE_PANEL_TILE.get()), PanelTileRenderer::new);
    }

    @CheckForNull
    public static PanelCellGhostPos getPlayerLookingAtCell(PanelTile panelTile) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        BlockPos blockPos = panelTile.func_174877_v();
        if (player != null && panelTile.func_174877_v().func_218137_a((IPosition)player.func_213303_ch(), 4.0)) {
            BlockRayTraceResult blockHitResult = panelTile.getPlayerCollisionHitResult((PlayerEntity)player);
            PosInPanelCell cellPos1 = PosInPanelCell.fromHitVec(panelTile, panelTile.func_174877_v(), blockHitResult);
            panelTile.panelCellHovering = cellPos1;
            if (panelTile.func_174877_v().func_218137_a((IPosition)player.func_213303_ch(), 3.0)) {
                PosInPanelCell posInPanelCell;
                if (PanelBlock.isPanelCellItem(player.func_184614_ca().func_77973_b()) && cellPos1 != null) {
                    PanelCellPos cellPos = cellPos1;
                    if (cellPos.getIPanelCell() != null && (!cellPos.getIPanelCell().hasActivation((PlayerEntity)player) || player.func_213453_ef())) {
                        cellPos = cellPos.offset(panelTile.getSideFromDirection(blockHitResult.func_216354_b()));
                    }
                    if (cellPos != null && cellPos.getIPanelCell() == null) {
                        try {
                            Side cellFacing;
                            IPanelCell panelCell = (IPanelCell)PanelBlock.getPanelCellClassFromItem(player.func_184614_ca().func_77973_b()).getConstructors()[0].newInstance(new Object[0]);
                            Side rotationLock = RotationLock.getRotationLock();
                            Side side = cellFacing = rotationLock == null ? panelTile.getSideFromDirection(panelTile.getPlayerDirectionFacing((PlayerEntity)player, panelCell.canPlaceVertical())) : rotationLock;
                            if (panelCell.needsSolidBase()) {
                                Side attachingSideRel;
                                Side attachingSideDir = panelTile.getSideFromDirection(blockHitResult.func_216354_b()).getOpposite();
                                Side side2 = attachingSideRel = attachingSideDir == Side.TOP || attachingSideDir == Side.BOTTOM ? attachingSideDir : Side.FRONT;
                                if (!(panelCell.canAttachToBaseOnSide(attachingSideRel) && (cellPos1.equals(cellPos) || cellPos1.getIPanelCell() != null && cellPos1.getIPanelCell().isPushable()))) {
                                    return null;
                                }
                                panelCell.setBaseSide(attachingSideRel);
                                if (attachingSideRel == Side.FRONT) {
                                    cellFacing = attachingSideDir;
                                }
                            }
                            panelCell.onPlace(cellPos, (PlayerEntity)player);
                            return PanelCellGhostPos.fromPosInPanelCell(cellPos, panelCell, cellFacing);
                        }
                        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                            TinyRedstone.LOGGER.error("Exception thrown when attempting to draw ghost cell: " + e.getMessage());
                        }
                    }
                }
                if ((posInPanelCell = PosInPanelCell.fromHitVec(panelTile, blockPos, blockHitResult)) != null && posInPanelCell.getIPanelCell() instanceof RedstoneDust) {
                    PanelCellSegment segmentHovering = posInPanelCell.getSegment();
                    return PanelCellGhostPos.fromPosInPanelCell(posInPanelCell, new GhostRenderer(segmentHovering), posInPanelCell.getCellFacing());
                }
            }
        }
        return null;
    }
}

