/*
 * Decompiled with CFR 0.152.
 */
package codechicken.multipart.network;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.packet.ICustomPacketHandler;
import codechicken.lib.packet.PacketCustom;
import codechicken.multipart.api.part.TMultiPart;
import codechicken.multipart.block.TileMultiPart;
import codechicken.multipart.init.MultiPartRegistries;
import codechicken.multipart.util.MultiPartHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.network.play.IClientPlayNetHandler;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class MultiPartCPH
implements ICustomPacketHandler.IClientPacketHandler {
    public void handlePacket(PacketCustom packet, Minecraft mc, IClientPlayNetHandler handler) {
        switch (packet.getType()) {
            case 1: {
                MultiPartCPH.handleTileDescPacket((MCDataInput)packet, mc);
                break;
            }
            case 2: {
                MultiPartCPH.handleAddPart((MCDataInput)packet, mc);
                break;
            }
            case 3: {
                MultiPartCPH.handleRemPart((MCDataInput)packet, mc);
                break;
            }
            case 4: {
                MultiPartCPH.handleUpdatePacket((MCDataInput)packet, mc);
            }
        }
    }

    public static void handleTileDescPacket(MCDataInput packet, Minecraft mc) {
        int num = packet.readVarInt();
        for (int i = 0; i < num; ++i) {
            BlockPos pos = packet.readPos();
            TileMultiPart.handleDescPacket((World)mc.field_71441_e, pos, packet);
        }
    }

    public static void handleAddPart(MCDataInput packet, Minecraft mc) {
        BlockPos pos = packet.readPos();
        MultiPartHelper.addPart((World)mc.field_71441_e, pos, MultiPartRegistries.readPart(packet));
    }

    public static void handleRemPart(MCDataInput packet, Minecraft mc) {
        byte partIndex = packet.readByte();
        BlockPos pos = packet.readPos();
        TileEntity tileEntity = mc.field_71441_e.func_175625_s(pos);
        if (tileEntity instanceof TileMultiPart) {
            TileMultiPart tile = (TileMultiPart)tileEntity;
            tile.remPart_impl(tile.getPartList().get(partIndex));
        }
    }

    public static void handleUpdatePacket(MCDataInput packet, Minecraft mc) {
        TileMultiPart tile;
        TMultiPart part;
        byte partIndex = packet.readByte();
        BlockPos pos = packet.readPos();
        TileEntity tileEntity = mc.field_71441_e.func_175625_s(pos);
        if (tileEntity instanceof TileMultiPart && (part = (tile = (TileMultiPart)tileEntity).getPartList().get(partIndex)) != null) {
            part.readUpdate(packet);
        }
    }
}

