/*
 * Decompiled with CFR 0.152.
 */
package codechicken.multipart.init;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.util.CrashLock;
import codechicken.lib.util.SneakyUtils;
import codechicken.multipart.api.MultiPartType;
import codechicken.multipart.api.PartConverter;
import codechicken.multipart.api.part.TMultiPart;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MultiPartRegistries {
    private static final Logger logger = LogManager.getLogger();
    private static final CrashLock LOCK = new CrashLock("Already initialized.");
    private static ForgeRegistry<MultiPartType<?>> MULTIPART_TYPES;
    private static IForgeRegistry<PartConverter> PART_CONVERTERS;

    public static void init(IEventBus eventBus) {
        LOCK.lock();
        eventBus.addListener(MultiPartRegistries::createRegistries);
    }

    private static void createRegistries(RegistryEvent.NewRegistry event) {
        MULTIPART_TYPES = (ForgeRegistry)SneakyUtils.unsafeCast((Object)new RegistryBuilder().setName(new ResourceLocation("cb_multipart", "multipart_types")).setType((Class)SneakyUtils.unsafeCast(MultiPartType.class)).disableSaving().create());
        PART_CONVERTERS = (IForgeRegistry)SneakyUtils.unsafeCast((Object)new RegistryBuilder().setName(new ResourceLocation("cb_multipart", "part_converters")).setType(PartConverter.class).disableOverrides().disableSaving().disableSync().create());
    }

    public static void writePart(MCDataOutput data, TMultiPart part) {
        MultiPartType<?> type = Objects.requireNonNull(part.getType());
        ResourceLocation name = Objects.requireNonNull(type.getRegistryName());
        if (!MULTIPART_TYPES.containsKey(name)) {
            throw new RuntimeException("MultiPartType with name '" + name + "' is not registered.");
        }
        data.writeVarInt(MULTIPART_TYPES.getID(name));
        part.writeDesc(data);
    }

    public static TMultiPart readPart(MCDataInput data) {
        int id = data.readVarInt();
        MultiPartType type = (MultiPartType)MULTIPART_TYPES.getValue(id);
        Object part = type.createPartClient(data);
        ((TMultiPart)part).readDesc(data);
        return part;
    }

    public static CompoundNBT savePart(CompoundNBT nbt, TMultiPart part) {
        MultiPartType<?> type = Objects.requireNonNull(part.getType());
        ResourceLocation name = Objects.requireNonNull(type.getRegistryName());
        nbt.func_74778_a("id", name.toString());
        part.save(nbt);
        return nbt;
    }

    @Nullable
    public static TMultiPart loadPart(CompoundNBT nbt) {
        ResourceLocation name = new ResourceLocation(nbt.func_74779_i("id"));
        MultiPartType type = (MultiPartType)MULTIPART_TYPES.getValue(name);
        if (type == null) {
            logger.error("Missing mapping for MultiPartType with ID: {}", (Object)name);
            return null;
        }
        Object part = type.createPartServer(nbt);
        if (part != null) {
            ((TMultiPart)part).load(nbt);
        }
        return part;
    }

    public static Collection<TMultiPart> convertBlock(IWorld world, BlockPos pos, BlockState state) {
        return PART_CONVERTERS.getValues().stream().map(c -> c.convert(world, pos, state)).filter(e -> e.func_188397_a() == ActionResultType.SUCCESS).findFirst().map(ActionResult::func_188398_b).orElse(Collections.emptyList());
    }

    public static TMultiPart convertItem(ItemUseContext context) {
        return PART_CONVERTERS.getValues().stream().map(c -> c.convert(context)).filter(e -> e.func_188397_a() == ActionResultType.SUCCESS).findFirst().map(ActionResult::func_188398_b).orElse(null);
    }
}

