/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.quest.task;

import dev.ftb.mods.ftblibrary.ui.Button;
import dev.ftb.mods.ftbquests.net.SubmitTaskMessage;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.QuestObjectBase;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.task.Task;
import dev.ftb.mods.ftbquests.quest.task.TaskType;
import dev.ftb.mods.ftbquests.quest.task.TaskTypes;
import java.util.function.Predicate;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class CustomTask
extends Task {
    public static final Predicate<QuestObjectBase> PREDICATE = object -> object instanceof CustomTask;
    public Check check = null;
    public int checkTimer = 1;
    public long maxProgress = 1L;
    public boolean enableButton = false;

    public CustomTask(Quest quest) {
        super(quest);
    }

    @Override
    public TaskType getType() {
        return TaskTypes.CUSTOM;
    }

    @Override
    public long getMaxProgress() {
        return this.maxProgress;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onButtonClicked(Button button, boolean canClick) {
        if (this.enableButton && canClick) {
            button.playClickSound();
            new SubmitTaskMessage(this.id).sendToServer();
        }
    }

    @Override
    public int autoSubmitOnPlayerTick() {
        return this.check == null ? 0 : this.checkTimer;
    }

    @Override
    public void writeNetData(PacketBuffer buffer) {
        super.writeNetData(buffer);
        buffer.func_150787_b(this.checkTimer);
        buffer.func_179254_b(this.maxProgress);
        buffer.writeBoolean(this.enableButton);
    }

    @Override
    public void readNetData(PacketBuffer buffer) {
        super.readNetData(buffer);
        this.checkTimer = buffer.func_150792_a();
        this.maxProgress = buffer.func_179260_f();
        this.enableButton = buffer.readBoolean();
    }

    @Override
    public void submitTask(TeamData teamData, ServerPlayerEntity player, ItemStack craftedItem) {
        if (this.check != null && !teamData.isCompleted(this)) {
            this.check.check(new Data(this, teamData), player);
        }
    }

    @Override
    public boolean checkOnLogin() {
        return false;
    }

    public static class Data {
        public final CustomTask task;
        public final TeamData teamData;

        public Data(CustomTask t, TeamData d) {
            this.task = t;
            this.teamData = d;
        }

        public long getProgress() {
            return this.teamData.getProgress(this.task);
        }

        public void setProgress(long l) {
            this.teamData.setProgress(this.task, l);
        }

        public void addProgress(long l) {
            this.teamData.addProgress(this.task, l);
        }
    }

    @FunctionalInterface
    public static interface Check {
        public void check(Data var1, ServerPlayerEntity var2);
    }
}

