/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.quest.reward;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.ItemIcon;
import dev.ftb.mods.ftblibrary.util.WrappedIngredient;
import dev.ftb.mods.ftbquests.net.DisplayItemRewardToastMessage;
import dev.ftb.mods.ftbquests.net.FTBQuestsNetHandler;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.reward.Reward;
import dev.ftb.mods.ftbquests.quest.reward.RewardType;
import dev.ftb.mods.ftbquests.quest.reward.RewardTypes;
import dev.ftb.mods.ftbquests.util.NBTUtils;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import me.shedaniel.architectury.hooks.ItemStackHooks;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class ItemReward
extends Reward {
    public ItemStack item;
    public int count;
    public int randomBonus;
    public boolean onlyOne;

    public ItemReward(Quest quest, ItemStack is) {
        super(quest);
        this.item = is;
        this.count = 1;
        this.randomBonus = 0;
        this.onlyOne = false;
    }

    public ItemReward(Quest quest) {
        this(quest, new ItemStack((IItemProvider)Items.field_151034_e));
    }

    @Override
    public RewardType getType() {
        return RewardTypes.ITEM;
    }

    @Override
    public void writeData(CompoundNBT nbt) {
        super.writeData(nbt);
        NBTUtils.write(nbt, "item", this.item);
        if (this.count > 1) {
            nbt.func_74768_a("count", this.count);
        }
        if (this.randomBonus > 0) {
            nbt.func_74768_a("random_bonus", this.randomBonus);
        }
        if (this.onlyOne) {
            nbt.func_74757_a("only_one", true);
        }
    }

    @Override
    public void readData(CompoundNBT nbt) {
        super.readData(nbt);
        this.item = NBTUtils.read(nbt, "item");
        this.count = nbt.func_74762_e("count");
        if (this.count == 0) {
            this.count = this.item.func_190916_E();
            this.item.func_190920_e(1);
        }
        this.randomBonus = nbt.func_74762_e("random_bonus");
        this.onlyOne = nbt.func_74767_n("only_one");
    }

    @Override
    public void writeNetData(PacketBuffer buffer) {
        super.writeNetData(buffer);
        FTBQuestsNetHandler.writeItemType(buffer, this.item);
        buffer.func_150787_b(this.count);
        buffer.func_150787_b(this.randomBonus);
        buffer.writeBoolean(this.onlyOne);
    }

    @Override
    public void readNetData(PacketBuffer buffer) {
        super.readNetData(buffer);
        this.item = FTBQuestsNetHandler.readItemType(buffer);
        this.count = buffer.func_150792_a();
        this.randomBonus = buffer.func_150792_a();
        this.onlyOne = buffer.readBoolean();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void getConfig(ConfigGroup config) {
        super.getConfig(config);
        config.addItemStack("item", this.item, v -> {
            this.item = v;
        }, ItemStack.field_190927_a, true, false).setNameKey("ftbquests.reward.ftbquests.item");
        config.addInt("count", this.count, v -> {
            this.count = v;
        }, 1, 1, 8192);
        config.addInt("random_bonus", this.randomBonus, v -> {
            this.randomBonus = v;
        }, 0, 0, 8192).setNameKey("ftbquests.reward.random_bonus");
        config.addBool("only_one", this.onlyOne, v -> {
            this.onlyOne = v;
        }, false);
    }

    @Override
    public void claim(ServerPlayerEntity player, boolean notify) {
        int size;
        int s;
        if (this.onlyOne && player.field_71071_by.func_70431_c(this.item)) {
            return;
        }
        for (size = this.count + player.field_70170_p.field_73012_v.nextInt(this.randomBonus + 1); size > 0; size -= s) {
            s = Math.min(size, this.item.func_77976_d());
            ItemStackHooks.giveItem((ServerPlayerEntity)player, (ItemStack)ItemStackHooks.copyWithCount((ItemStack)this.item, (int)s));
        }
        if (notify) {
            new DisplayItemRewardToastMessage(this.item, size).sendTo(player);
        }
    }

    @Override
    public boolean automatedClaimPre(TileEntity tileEntity, List<ItemStack> items, Random random, UUID playerId, @Nullable ServerPlayerEntity player) {
        int s;
        for (int size = this.count + random.nextInt(this.randomBonus + 1); size > 0; size -= s) {
            s = Math.min(size, this.item.func_77976_d());
            ItemStack copy = this.item.func_77946_l();
            copy.func_190920_e(s);
            items.add(copy);
        }
        return true;
    }

    @Override
    public void automatedClaimPost(TileEntity tileEntity, UUID playerId, @Nullable ServerPlayerEntity player) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public IFormattableTextComponent getAltTitle() {
        return new StringTextComponent(this.count > 1 ? (this.randomBonus > 0 ? this.count + "-" + (this.count + this.randomBonus) + "x " : this.count + "x ") : "").func_230529_a_(this.item.func_200301_q());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Icon getAltIcon() {
        if (this.item.func_190926_b()) {
            return super.getAltIcon();
        }
        ItemStack copy = this.item.func_77946_l();
        copy.func_190920_e(1);
        return ItemIcon.getItemIcon((ItemStack)copy);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean addTitleInMouseOverText() {
        return !this.getTitle().getString().equals(this.getAltTitle().getString());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public Object getIngredient() {
        return new WrappedIngredient((Object)this.item).tooltip();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public String getButtonText() {
        if (this.randomBonus > 0) {
            return this.count + "-" + (this.count + this.randomBonus);
        }
        return Integer.toString(this.count);
    }
}

