/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.quest;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.ConfigValue;
import dev.ftb.mods.ftblibrary.config.ItemStackConfig;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.math.MathUtils;
import dev.ftb.mods.ftblibrary.snbt.SNBT;
import dev.ftb.mods.ftblibrary.snbt.SNBTCompoundTag;
import dev.ftb.mods.ftbquests.FTBQuests;
import dev.ftb.mods.ftbquests.events.ClearFileCacheEvent;
import dev.ftb.mods.ftbquests.events.CustomTaskEvent;
import dev.ftb.mods.ftbquests.events.ObjectCompletedEvent;
import dev.ftb.mods.ftbquests.events.ObjectStartedEvent;
import dev.ftb.mods.ftbquests.events.QuestProgressEventData;
import dev.ftb.mods.ftbquests.integration.jei.FTBQuestsJEIHelper;
import dev.ftb.mods.ftbquests.item.MissingItem;
import dev.ftb.mods.ftbquests.net.DisplayCompletionToastMessage;
import dev.ftb.mods.ftbquests.net.FTBQuestsNetHandler;
import dev.ftb.mods.ftbquests.quest.Chapter;
import dev.ftb.mods.ftbquests.quest.ChapterGroup;
import dev.ftb.mods.ftbquests.quest.DefaultChapterGroup;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.QuestObject;
import dev.ftb.mods.ftbquests.quest.QuestObjectBase;
import dev.ftb.mods.ftbquests.quest.QuestObjectType;
import dev.ftb.mods.ftbquests.quest.QuestShape;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.loot.EntityWeight;
import dev.ftb.mods.ftbquests.quest.loot.LootCrate;
import dev.ftb.mods.ftbquests.quest.loot.RewardTable;
import dev.ftb.mods.ftbquests.quest.reward.CustomReward;
import dev.ftb.mods.ftbquests.quest.reward.Reward;
import dev.ftb.mods.ftbquests.quest.reward.RewardAutoClaim;
import dev.ftb.mods.ftbquests.quest.reward.RewardType;
import dev.ftb.mods.ftbquests.quest.reward.RewardTypes;
import dev.ftb.mods.ftbquests.quest.task.CustomTask;
import dev.ftb.mods.ftbquests.quest.task.Task;
import dev.ftb.mods.ftbquests.quest.task.TaskType;
import dev.ftb.mods.ftbquests.quest.task.TaskTypes;
import dev.ftb.mods.ftbquests.quest.theme.property.ThemeProperties;
import dev.ftb.mods.ftbquests.util.NetUtils;
import dev.ftb.mods.ftbteams.FTBTeamsAPI;
import dev.ftb.mods.ftbteams.data.TeamBase;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Predicate;
import me.shedaniel.architectury.core.RegistryEntry;
import me.shedaniel.architectury.event.EventActor;
import me.shedaniel.architectury.utils.Env;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NumberNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jetbrains.annotations.Nullable;

public abstract class QuestFile
extends QuestObject {
    public static int VERSION = 13;
    public final DefaultChapterGroup defaultChapterGroup;
    public final List<ChapterGroup> chapterGroups;
    public final List<RewardTable> rewardTables;
    protected final Map<UUID, TeamData> teamDataMap;
    private final Long2ObjectOpenHashMap<QuestObjectBase> map;
    public final Int2ObjectOpenHashMap<TaskType> taskTypeIds;
    public final Int2ObjectOpenHashMap<RewardType> rewardTypeIds;
    public final List<ItemStack> emergencyItems;
    public int emergencyItemsCooldown;
    public int fileVersion;
    public boolean defaultRewardTeam;
    public boolean defaultTeamConsumeItems;
    public RewardAutoClaim defaultRewardAutoClaim;
    public String defaultQuestShape;
    public boolean defaultQuestDisableJEI;
    public boolean dropLootCrates;
    public final EntityWeight lootCrateNoDrop;
    public boolean disableGui;
    public double gridScale;
    public boolean pauseGame;
    public String lockMessage;
    private List<Task> allTasks;
    private List<Task> submitTasks;

    public QuestFile() {
        this.id = 1L;
        this.fileVersion = 0;
        this.defaultChapterGroup = new DefaultChapterGroup(this);
        this.chapterGroups = new ArrayList<ChapterGroup>();
        this.chapterGroups.add(this.defaultChapterGroup);
        this.rewardTables = new ArrayList<RewardTable>();
        this.teamDataMap = new HashMap<UUID, TeamData>();
        this.map = new Long2ObjectOpenHashMap();
        this.taskTypeIds = new Int2ObjectOpenHashMap();
        this.rewardTypeIds = new Int2ObjectOpenHashMap();
        this.emergencyItems = new ArrayList<ItemStack>();
        this.emergencyItemsCooldown = 300;
        this.defaultRewardTeam = false;
        this.defaultTeamConsumeItems = false;
        this.defaultRewardAutoClaim = RewardAutoClaim.DISABLED;
        this.defaultQuestShape = "circle";
        this.defaultQuestDisableJEI = false;
        this.dropLootCrates = false;
        this.lootCrateNoDrop = new EntityWeight();
        this.lootCrateNoDrop.passive = 4000;
        this.lootCrateNoDrop.monster = 600;
        this.lootCrateNoDrop.boss = 0;
        this.disableGui = false;
        this.gridScale = 0.5;
        this.pauseGame = false;
        this.lockMessage = "";
        this.allTasks = null;
    }

    public abstract Env getSide();

    public final boolean isServerSide() {
        return this.getSide() == Env.SERVER;
    }

    @Override
    public QuestFile getQuestFile() {
        return this;
    }

    @Override
    public QuestObjectType getObjectType() {
        return QuestObjectType.FILE;
    }

    public boolean isLoading() {
        return false;
    }

    public boolean canEdit() {
        return false;
    }

    public Path getFolder() {
        throw new IllegalStateException("This quest file doesn't have a folder!");
    }

    public void load() {
        throw new IllegalStateException("This method can only be called from client quest file!");
    }

    @Override
    public int getRelativeProgressFromChildren(TeamData data) {
        int progress = 0;
        int chapters = 0;
        for (ChapterGroup group : this.chapterGroups) {
            for (Chapter chapter : group.chapters) {
                progress += data.getRelativeProgress(chapter);
                ++chapters;
            }
        }
        return QuestFile.getRelativeProgressFromChildren(progress, chapters);
    }

    @Override
    public void onStarted(QuestProgressEventData<?> data) {
        data.teamData.setStarted(this.id, data.time);
        ((EventActor)ObjectStartedEvent.FILE.invoker()).act((Object)new ObjectStartedEvent.FileEvent(data.withObject(this)));
    }

    @Override
    public void onCompleted(QuestProgressEventData<?> data) {
        data.teamData.setCompleted(this.id, data.time);
        ((EventActor)ObjectCompletedEvent.FILE.invoker()).act((Object)new ObjectCompletedEvent.FileEvent(data.withObject(this)));
        if (!this.disableToast) {
            for (ServerPlayerEntity player : data.notifiedPlayers) {
                new DisplayCompletionToastMessage(this.id).sendTo(player);
            }
        }
    }

    @Override
    public void deleteSelf() {
        this.invalid = true;
    }

    @Override
    public void deleteChildren() {
        for (ChapterGroup group : this.chapterGroups) {
            for (Chapter chapter : group.chapters) {
                chapter.deleteChildren();
                chapter.invalid = true;
            }
        }
        this.defaultChapterGroup.chapters.clear();
        this.chapterGroups.clear();
        this.chapterGroups.add(this.defaultChapterGroup);
        for (RewardTable table : this.rewardTables) {
            table.deleteChildren();
            table.invalid = true;
        }
        this.rewardTables.clear();
    }

    @Nullable
    public QuestObjectBase getBase(long id) {
        if (id <= 0L) {
            return null;
        }
        if (id == 1L) {
            return this;
        }
        QuestObjectBase object = (QuestObjectBase)this.map.get(id);
        return object == null || object.invalid ? null : object;
    }

    @Nullable
    public QuestObject get(long id) {
        QuestObjectBase object = this.getBase(id);
        return object instanceof QuestObject ? (QuestObject)object : null;
    }

    @Nullable
    public QuestObjectBase remove(long id) {
        QuestObjectBase object = (QuestObjectBase)this.map.remove(id);
        if (object != null) {
            if (object instanceof QuestObject) {
                QuestObject o = (QuestObject)object;
                for (ChapterGroup group : this.chapterGroups) {
                    for (Chapter chapter : group.chapters) {
                        for (Quest quest : chapter.quests) {
                            quest.dependencies.remove(o);
                        }
                    }
                }
            }
            object.invalid = true;
            this.refreshIDMap();
            return object;
        }
        return null;
    }

    @Nullable
    public Chapter getChapter(long id) {
        QuestObjectBase object = this.getBase(id);
        return object instanceof Chapter ? (Chapter)object : null;
    }

    @Nullable
    public Quest getQuest(long id) {
        QuestObjectBase object = this.getBase(id);
        return object instanceof Quest ? (Quest)object : null;
    }

    @Nullable
    public Task getTask(long id) {
        QuestObjectBase object = this.getBase(id);
        return object instanceof Task ? (Task)object : null;
    }

    @Nullable
    public Reward getReward(long id) {
        QuestObjectBase object = this.getBase(id);
        return object instanceof Reward ? (Reward)object : null;
    }

    @Nullable
    public RewardTable getRewardTable(long id) {
        QuestObjectBase object = this.getBase(id);
        return object instanceof RewardTable ? (RewardTable)object : null;
    }

    @Nullable
    public LootCrate getLootCrate(String id) {
        RewardTable table;
        if (!id.startsWith("#")) {
            for (RewardTable table2 : this.rewardTables) {
                if (table2.lootCrate == null || !table2.lootCrate.stringID.equals(id)) continue;
                return table2.lootCrate;
            }
        }
        return (table = this.getRewardTable(this.getID(id))) == null ? null : table.lootCrate;
    }

    public ChapterGroup getChapterGroup(long id) {
        QuestObjectBase object = this.getBase(id);
        return object instanceof ChapterGroup ? (ChapterGroup)object : this.defaultChapterGroup;
    }

    public void refreshIDMap() {
        this.clearCachedData();
        this.map.clear();
        for (ChapterGroup group : this.chapterGroups) {
            this.map.put(group.id, (Object)group);
        }
        for (RewardTable table : this.rewardTables) {
            this.map.put(table.id, (Object)table);
        }
        for (ChapterGroup group : this.chapterGroups) {
            for (Chapter chapter : group.chapters) {
                this.map.put(chapter.id, (Object)chapter);
                for (Quest quest : chapter.quests) {
                    this.map.put(quest.id, (Object)quest);
                    for (Task task : quest.tasks) {
                        this.map.put(task.id, (Object)task);
                    }
                    for (Reward reward : quest.rewards) {
                        this.map.put(reward.id, (Object)reward);
                    }
                }
            }
        }
        this.clearCachedData();
    }

    public QuestObjectBase create(QuestObjectType type, long parent, CompoundNBT extra) {
        switch (type) {
            case CHAPTER: {
                return new Chapter(this, this.getChapterGroup(extra.func_74763_f("group")));
            }
            case QUEST: {
                Chapter chapter = this.getChapter(parent);
                if (chapter != null) {
                    return new Quest(chapter);
                }
                throw new IllegalArgumentException("Parent chapter not found!");
            }
            case TASK: {
                Quest quest = this.getQuest(parent);
                if (quest != null) {
                    Task task = TaskType.createTask(quest, extra.func_74779_i("type"));
                    if (task != null) {
                        return task;
                    }
                    throw new IllegalArgumentException("Unknown task type!");
                }
                throw new IllegalArgumentException("Parent quest not found!");
            }
            case REWARD: {
                Quest quest = this.getQuest(parent);
                if (quest != null) {
                    Reward reward = RewardType.createReward(quest, extra.func_74779_i("type"));
                    if (reward != null) {
                        return reward;
                    }
                    throw new IllegalArgumentException("Unknown reward type!");
                }
                throw new IllegalArgumentException("Parent quest not found!");
            }
            case REWARD_TABLE: {
                return new RewardTable(this);
            }
            case CHAPTER_GROUP: {
                return new ChapterGroup(this);
            }
        }
        throw new IllegalArgumentException("Unknown type: " + type);
    }

    @Override
    public final void writeData(CompoundNBT nbt) {
        super.writeData(nbt);
        nbt.func_74757_a("default_reward_team", this.defaultRewardTeam);
        nbt.func_74757_a("default_consume_items", this.defaultTeamConsumeItems);
        nbt.func_74778_a("default_autoclaim_rewards", this.defaultRewardAutoClaim.id);
        nbt.func_74778_a("default_quest_shape", this.defaultQuestShape);
        nbt.func_74757_a("default_quest_disable_jei", this.defaultQuestDisableJEI);
        if (!this.emergencyItems.isEmpty()) {
            ListNBT list = new ListNBT();
            for (ItemStack stack : this.emergencyItems) {
                list.add((Object)MissingItem.writeItem(stack));
            }
            nbt.func_218657_a("emergency_items", (INBT)list);
        }
        nbt.func_74768_a("emergency_items_cooldown", this.emergencyItemsCooldown);
        nbt.func_74757_a("drop_loot_crates", this.dropLootCrates);
        SNBTCompoundTag lootCrateNoDropTag = new SNBTCompoundTag();
        this.lootCrateNoDrop.writeData((CompoundNBT)lootCrateNoDropTag);
        nbt.func_218657_a("loot_crate_no_drop", (INBT)lootCrateNoDropTag);
        nbt.func_74757_a("disable_gui", this.disableGui);
        nbt.func_74780_a("grid_scale", this.gridScale);
        nbt.func_74757_a("pause_game", this.pauseGame);
        nbt.func_74778_a("lock_message", this.lockMessage);
    }

    @Override
    public final void readData(CompoundNBT nbt) {
        super.readData(nbt);
        this.defaultRewardTeam = nbt.func_74767_n("default_reward_team");
        this.defaultTeamConsumeItems = nbt.func_74767_n("default_consume_items");
        this.defaultRewardAutoClaim = (RewardAutoClaim)((Object)RewardAutoClaim.NAME_MAP_NO_DEFAULT.get(nbt.func_74779_i("default_autoclaim_rewards")));
        this.defaultQuestShape = nbt.func_74779_i("default_quest_shape");
        if (this.defaultQuestShape.equals("default")) {
            this.defaultQuestShape = "";
        }
        this.defaultQuestDisableJEI = nbt.func_74767_n("default_quest_disable_jei");
        this.emergencyItems.clear();
        ListNBT emergencyItemsTag = nbt.func_150295_c("emergency_items", 10);
        for (int i = 0; i < emergencyItemsTag.size(); ++i) {
            ItemStack stack = MissingItem.readItem(emergencyItemsTag.func_150305_b(i));
            if (stack.func_190926_b()) continue;
            this.emergencyItems.add(stack);
        }
        this.emergencyItemsCooldown = nbt.func_74762_e("emergency_items_cooldown");
        this.dropLootCrates = nbt.func_74767_n("drop_loot_crates");
        if (nbt.func_74764_b("loot_crate_no_drop")) {
            this.lootCrateNoDrop.readData(nbt.func_74775_l("loot_crate_no_drop"));
        }
        this.disableGui = nbt.func_74767_n("disable_gui");
        this.gridScale = nbt.func_74764_b("grid_scale") ? nbt.func_74769_h("grid_scale") : 0.5;
        this.pauseGame = nbt.func_74767_n("pause_game");
        this.lockMessage = nbt.func_74779_i("lock_message");
    }

    public final void writeDataFull(Path folder) {
        SNBTCompoundTag fileNBT = new SNBTCompoundTag();
        fileNBT.func_74768_a("version", VERSION);
        this.writeData((CompoundNBT)fileNBT);
        SNBT.write((Path)folder.resolve("data.snbt"), (CompoundNBT)fileNBT);
        for (ChapterGroup group : this.chapterGroups) {
            for (int ci = 0; ci < group.chapters.size(); ++ci) {
                Chapter chapter = group.chapters.get(ci);
                SNBTCompoundTag chapterNBT = new SNBTCompoundTag();
                chapterNBT.func_74778_a("id", chapter.getCodeString());
                chapterNBT.func_74778_a("group", group.isDefaultGroup() ? "" : group.getCodeString());
                chapterNBT.func_74768_a("order_index", ci);
                chapter.writeData((CompoundNBT)chapterNBT);
                ListNBT questList = new ListNBT();
                for (Quest quest : chapter.quests) {
                    SNBTCompoundTag nbt3;
                    RegistryEntry type;
                    if (quest.invalid) continue;
                    SNBTCompoundTag questNBT = new SNBTCompoundTag();
                    quest.writeData((CompoundNBT)questNBT);
                    questNBT.func_74778_a("id", quest.getCodeString());
                    if (!quest.tasks.isEmpty()) {
                        ListNBT t = new ListNBT();
                        for (Task task : quest.tasks) {
                            type = task.getType();
                            nbt3 = new SNBTCompoundTag();
                            nbt3.func_74778_a("id", task.getCodeString());
                            nbt3.func_74778_a("type", type.getTypeForNBT());
                            task.writeData((CompoundNBT)nbt3);
                            t.add((Object)nbt3);
                        }
                        if (!t.isEmpty()) {
                            questNBT.func_218657_a("tasks", (INBT)t);
                        }
                    }
                    if (!quest.rewards.isEmpty()) {
                        ListNBT r = new ListNBT();
                        for (Reward reward : quest.rewards) {
                            type = reward.getType();
                            nbt3 = new SNBTCompoundTag();
                            nbt3.func_74778_a("id", reward.getCodeString());
                            nbt3.func_74778_a("type", type.getTypeForNBT());
                            reward.writeData((CompoundNBT)nbt3);
                            r.add((Object)nbt3);
                        }
                        if (!r.isEmpty()) {
                            questNBT.func_218657_a("rewards", (INBT)r);
                        }
                    }
                    questList.add((Object)questNBT);
                }
                chapterNBT.func_218657_a("quests", (INBT)questList);
                SNBT.write((Path)folder.resolve("chapters/" + chapter.getFilename() + ".snbt"), (CompoundNBT)chapterNBT);
            }
        }
        for (int ri = 0; ri < this.rewardTables.size(); ++ri) {
            RewardTable table = this.rewardTables.get(ri);
            SNBTCompoundTag tableNBT = new SNBTCompoundTag();
            tableNBT.func_74778_a("id", table.getCodeString());
            tableNBT.func_74768_a("order_index", ri);
            table.writeData((CompoundNBT)tableNBT);
            SNBT.write((Path)folder.resolve("reward_tables/" + table.getFilename() + ".snbt"), (CompoundNBT)tableNBT);
        }
        ListNBT chapterGroupTag = new ListNBT();
        for (ChapterGroup group : this.chapterGroups) {
            if (group.isDefaultGroup()) continue;
            SNBTCompoundTag groupTag = new SNBTCompoundTag();
            groupTag.singleLine();
            groupTag.func_74778_a("id", group.getCodeString());
            group.writeData((CompoundNBT)groupTag);
            chapterGroupTag.add((Object)groupTag);
        }
        SNBTCompoundTag groupNBT = new SNBTCompoundTag();
        groupNBT.func_218657_a("chapter_groups", (INBT)chapterGroupTag);
        SNBT.write((Path)folder.resolve("chapter_groups.snbt"), (CompoundNBT)groupNBT);
    }

    public final void readDataFull(Path folder) {
        Path rewardTableFolder;
        SNBTCompoundTag chapterGroupsTag;
        Path groupsFile;
        this.clearCachedData();
        this.map.clear();
        this.defaultChapterGroup.chapters.clear();
        this.chapterGroups.clear();
        this.chapterGroups.add(this.defaultChapterGroup);
        this.rewardTables.clear();
        MutableInt chapterCounter = new MutableInt();
        MutableInt questCounter = new MutableInt();
        Long2ObjectOpenHashMap dataCache = new Long2ObjectOpenHashMap();
        SNBTCompoundTag fileNBT = SNBT.read((Path)folder.resolve("data.snbt"));
        if (fileNBT != null) {
            this.fileVersion = fileNBT.func_74762_e("version");
            this.map.put(1L, (Object)this);
            this.readData((CompoundNBT)fileNBT);
        }
        if (Files.exists(groupsFile = folder.resolve("chapter_groups.snbt"), new LinkOption[0]) && (chapterGroupsTag = SNBT.read((Path)groupsFile)) != null) {
            ListNBT groupListTag = chapterGroupsTag.func_150295_c("chapter_groups", 10);
            for (int i = 0; i < groupListTag.size(); ++i) {
                CompoundNBT groupNBT = groupListTag.func_150305_b(i);
                ChapterGroup chapterGroup = new ChapterGroup(this);
                chapterGroup.id = this.readID(groupNBT.func_74781_a("id"));
                this.map.put(chapterGroup.id, (Object)chapterGroup);
                dataCache.put(chapterGroup.id, (Object)groupNBT);
                this.chapterGroups.add(chapterGroup);
            }
        }
        Path chaptersFolder = folder.resolve("chapters");
        Long2IntOpenHashMap objectOrderMap = new Long2IntOpenHashMap();
        objectOrderMap.defaultReturnValue(-1);
        if (Files.exists(chaptersFolder, new LinkOption[0])) {
            try {
                Files.list(chaptersFolder).forEach(path -> {
                    SNBTCompoundTag chapterNBT = SNBT.read((Path)path);
                    if (chapterNBT != null) {
                        Chapter chapter = new Chapter(this, this.getChapterGroup(this.getID(chapterNBT.func_74781_a("group"))));
                        chapter.id = this.readID(chapterNBT.func_74781_a("id"));
                        chapter.filename = path.getFileName().toString().replace(".snbt", "");
                        objectOrderMap.put(chapter.id, chapterNBT.func_74762_e("order_index"));
                        this.map.put(chapter.id, (Object)chapter);
                        dataCache.put(chapter.id, (Object)chapterNBT);
                        chapter.group.chapters.add(chapter);
                        ListNBT questList = chapterNBT.func_150295_c("quests", 10);
                        for (int i = 0; i < questList.size(); ++i) {
                            CompoundNBT questNBT = questList.func_150305_b(i);
                            Quest quest = new Quest(chapter);
                            quest.id = this.readID(questNBT.func_74781_a("id"));
                            this.map.put(quest.id, (Object)quest);
                            dataCache.put(quest.id, (Object)questNBT);
                            chapter.quests.add(quest);
                            ListNBT taskList = questNBT.func_150295_c("tasks", 10);
                            for (int j = 0; j < taskList.size(); ++j) {
                                CompoundNBT taskNBT = taskList.func_150305_b(j);
                                Task task = TaskType.createTask(quest, taskNBT.func_74779_i("type"));
                                if (task == null) {
                                    task = new CustomTask(quest);
                                    task.title = "Unknown type: " + taskNBT.func_74779_i("type");
                                }
                                task.id = this.readID(taskNBT.func_74781_a("id"));
                                this.map.put(task.id, (Object)task);
                                dataCache.put(task.id, (Object)taskNBT);
                                quest.tasks.add(task);
                            }
                            ListNBT rewardList = questNBT.func_150295_c("rewards", 10);
                            for (int j = 0; j < rewardList.size(); ++j) {
                                CompoundNBT rewardNBT = rewardList.func_150305_b(j);
                                Reward reward = RewardType.createReward(quest, rewardNBT.func_74779_i("type"));
                                if (reward == null) {
                                    reward = new CustomReward(quest);
                                    reward.title = "Unknown type: " + rewardNBT.func_74779_i("type");
                                }
                                reward.id = this.readID(rewardNBT.func_74781_a("id"));
                                this.map.put(reward.id, (Object)reward);
                                dataCache.put(reward.id, (Object)rewardNBT);
                                quest.rewards.add(reward);
                            }
                            questCounter.increment();
                        }
                        chapterCounter.increment();
                    }
                });
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (Files.exists(rewardTableFolder = folder.resolve("reward_tables"), new LinkOption[0])) {
            try {
                Files.list(rewardTableFolder).forEach(path -> {
                    SNBTCompoundTag tableNBT = SNBT.read((Path)path);
                    if (tableNBT != null) {
                        RewardTable table = new RewardTable(this);
                        table.id = this.readID(tableNBT.func_74781_a("id"));
                        table.filename = path.getFileName().toString().replace(".snbt", "");
                        objectOrderMap.put(table.id, tableNBT.func_74762_e("order_index"));
                        this.map.put(table.id, (Object)table);
                        dataCache.put(table.id, (Object)tableNBT);
                        this.rewardTables.add(table);
                    }
                });
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        for (QuestObjectBase object : this.map.values()) {
            CompoundNBT data = (CompoundNBT)dataCache.get(object.id);
            if (data == null) continue;
            object.readData(data);
        }
        for (ChapterGroup group : this.chapterGroups) {
            group.chapters.sort(Comparator.comparingInt(c -> objectOrderMap.get(c.id)));
            for (Chapter chapter : group.chapters) {
                for (Quest quest : chapter.quests) {
                    quest.removeInvalidDependencies();
                }
            }
        }
        this.rewardTables.sort(Comparator.comparingInt(c -> objectOrderMap.get(c.id)));
        this.updateLootCrates();
        for (QuestObjectBase object : this.getAllObjects()) {
            if (!(object instanceof CustomTask)) continue;
            ((EventActor)CustomTaskEvent.EVENT.invoker()).act((Object)new CustomTaskEvent((CustomTask)object));
        }
        if (this.fileVersion != VERSION) {
            this.save();
        }
        FTBQuests.LOGGER.info("Loaded " + this.chapterGroups.size() + " chapter groups, " + chapterCounter + " chapters, " + questCounter + " quests, " + this.rewardTables.size() + " reward tables");
    }

    public void updateLootCrates() {
        LootCrate.LOOT_CRATES.clear();
        for (RewardTable table : this.rewardTables) {
            if (table.lootCrate == null) continue;
            LootCrate.LOOT_CRATES.put(table.lootCrate.getStringID(), table.lootCrate);
        }
        FTBQuests.LOGGER.debug("Updated " + LootCrate.LOOT_CRATES.size() + " loot crates");
    }

    public void save() {
    }

    @Override
    public final void writeNetData(PacketBuffer buffer) {
        super.writeNetData(buffer);
        NetUtils.write(buffer, this.emergencyItems, FTBQuestsNetHandler::writeItemType);
        buffer.func_150787_b(this.emergencyItemsCooldown);
        buffer.writeBoolean(this.defaultRewardTeam);
        buffer.writeBoolean(this.defaultTeamConsumeItems);
        RewardAutoClaim.NAME_MAP_NO_DEFAULT.write(buffer, (Object)this.defaultRewardAutoClaim);
        buffer.func_211400_a(this.defaultQuestShape, Short.MAX_VALUE);
        buffer.writeBoolean(this.defaultQuestDisableJEI);
        buffer.writeBoolean(this.dropLootCrates);
        this.lootCrateNoDrop.writeNetData(buffer);
        buffer.writeBoolean(this.disableGui);
        buffer.writeDouble(this.gridScale);
        buffer.writeBoolean(this.pauseGame);
        buffer.func_211400_a(this.lockMessage, Short.MAX_VALUE);
    }

    @Override
    public final void readNetData(PacketBuffer buffer) {
        super.readNetData(buffer);
        NetUtils.read(buffer, this.emergencyItems, FTBQuestsNetHandler::readItemType);
        this.emergencyItemsCooldown = buffer.func_150792_a();
        this.defaultRewardTeam = buffer.readBoolean();
        this.defaultTeamConsumeItems = buffer.readBoolean();
        this.defaultRewardAutoClaim = (RewardAutoClaim)((Object)RewardAutoClaim.NAME_MAP_NO_DEFAULT.read(buffer));
        this.defaultQuestShape = buffer.func_150789_c(Short.MAX_VALUE);
        this.defaultQuestDisableJEI = buffer.readBoolean();
        this.dropLootCrates = buffer.readBoolean();
        this.lootCrateNoDrop.readNetData(buffer);
        this.disableGui = buffer.readBoolean();
        this.gridScale = buffer.readDouble();
        this.pauseGame = buffer.readBoolean();
        this.lockMessage = buffer.func_150789_c(Short.MAX_VALUE);
    }

    public final void writeNetDataFull(PacketBuffer buffer) {
        int pos = buffer.writerIndex();
        buffer.func_150787_b(TaskTypes.TYPES.size());
        for (TaskType taskType : TaskTypes.TYPES.values()) {
            buffer.func_192572_a(taskType.id);
            buffer.func_150787_b(taskType.intId);
        }
        buffer.func_150787_b(RewardTypes.TYPES.size());
        for (RewardType rewardType : RewardTypes.TYPES.values()) {
            buffer.func_192572_a(rewardType.id);
            buffer.func_150787_b(rewardType.intId);
        }
        this.writeNetData(buffer);
        buffer.func_150787_b(this.rewardTables.size());
        for (RewardTable rewardTable : this.rewardTables) {
            buffer.writeLong(rewardTable.id);
        }
        buffer.func_150787_b(this.chapterGroups.size() - 1);
        for (ChapterGroup chapterGroup : this.chapterGroups) {
            if (chapterGroup.isDefaultGroup()) continue;
            buffer.writeLong(chapterGroup.id);
        }
        for (ChapterGroup chapterGroup : this.chapterGroups) {
            buffer.func_150787_b(chapterGroup.chapters.size());
            for (Chapter chapter : chapterGroup.chapters) {
                buffer.writeLong(chapter.id);
                buffer.func_150787_b(chapter.quests.size());
                for (Quest quest : chapter.quests) {
                    buffer.writeLong(quest.id);
                    buffer.func_150787_b(quest.tasks.size());
                    for (Task task : quest.tasks) {
                        buffer.func_150787_b(task.getType().intId);
                        buffer.writeLong(task.id);
                    }
                    buffer.func_150787_b(quest.rewards.size());
                    for (Reward reward : quest.rewards) {
                        buffer.func_150787_b(reward.getType().intId);
                        buffer.writeLong(reward.id);
                    }
                }
            }
        }
        for (RewardTable rewardTable : this.rewardTables) {
            rewardTable.writeNetData(buffer);
        }
        for (ChapterGroup chapterGroup : this.chapterGroups) {
            if (chapterGroup.isDefaultGroup()) continue;
            chapterGroup.writeNetData(buffer);
        }
        for (ChapterGroup chapterGroup : this.chapterGroups) {
            for (Chapter chapter : chapterGroup.chapters) {
                chapter.writeNetData(buffer);
                for (Quest quest : chapter.quests) {
                    quest.writeNetData(buffer);
                    for (Task task : quest.tasks) {
                        task.writeNetData(buffer);
                    }
                    for (Reward reward : quest.rewards) {
                        reward.writeNetData(buffer);
                    }
                }
            }
        }
        FTBQuests.LOGGER.debug("Wrote " + (buffer.writerIndex() - pos) + " bytes, " + this.map.size() + " objects");
    }

    /*
     * WARNING - void declaration
     */
    public final void readNetDataFull(PacketBuffer buffer) {
        void var4_9;
        int pos = buffer.readerIndex();
        this.taskTypeIds.clear();
        this.rewardTypeIds.clear();
        for (TaskType taskType : TaskTypes.TYPES.values()) {
            taskType.intId = 0;
        }
        for (RewardType rewardType : RewardTypes.TYPES.values()) {
            rewardType.intId = 0;
        }
        int taskTypesSize = buffer.func_150792_a();
        boolean bl = false;
        while (var4_9 < taskTypesSize) {
            TaskType type = TaskTypes.TYPES.get(buffer.func_192575_l());
            int id = buffer.func_150792_a();
            if (type != null) {
                type.intId = id;
                this.taskTypeIds.put(type.intId, (Object)type);
            }
            ++var4_9;
        }
        int n = buffer.func_150792_a();
        for (int i = 0; i < n; ++i) {
            RewardType type = RewardTypes.TYPES.get(buffer.func_192575_l());
            int id = buffer.func_150792_a();
            if (type == null) continue;
            type.intId = id;
            this.rewardTypeIds.put(type.intId, (Object)type);
        }
        this.readNetData(buffer);
        this.rewardTables.clear();
        int rtl = buffer.func_150792_a();
        for (int i = 0; i < rtl; ++i) {
            RewardTable table = new RewardTable(this);
            table.id = buffer.readLong();
            this.rewardTables.add(table);
        }
        this.chapterGroups.clear();
        this.chapterGroups.add(this.defaultChapterGroup);
        int cgl = buffer.func_150792_a();
        for (int i = 0; i < cgl; ++i) {
            ChapterGroup group = new ChapterGroup(this);
            group.id = buffer.readLong();
            this.chapterGroups.add(group);
        }
        for (ChapterGroup group : this.chapterGroups) {
            int c = buffer.func_150792_a();
            for (int i = 0; i < c; ++i) {
                Chapter chapter = new Chapter(this, group);
                chapter.id = buffer.readLong();
                group.chapters.add(chapter);
                int q = buffer.func_150792_a();
                for (int j = 0; j < q; ++j) {
                    Quest quest = new Quest(chapter);
                    quest.id = buffer.readLong();
                    chapter.quests.add(quest);
                    int t = buffer.func_150792_a();
                    for (int k = 0; k < t; ++k) {
                        TaskType type = (TaskType)((Object)this.taskTypeIds.get(buffer.func_150792_a()));
                        Task task = type.provider.create(quest);
                        task.id = buffer.readLong();
                        quest.tasks.add(task);
                    }
                    int r = buffer.func_150792_a();
                    for (int k = 0; k < r; ++k) {
                        RewardType type = (RewardType)((Object)this.rewardTypeIds.get(buffer.func_150792_a()));
                        Reward reward = type.provider.create(quest);
                        reward.id = buffer.readLong();
                        quest.rewards.add(reward);
                    }
                }
            }
        }
        this.refreshIDMap();
        for (RewardTable table : this.rewardTables) {
            table.readNetData(buffer);
        }
        for (ChapterGroup group : this.chapterGroups) {
            if (group.isDefaultGroup()) continue;
            group.readNetData(buffer);
        }
        for (ChapterGroup group : this.chapterGroups) {
            for (Chapter chapter : group.chapters) {
                chapter.readNetData(buffer);
                for (Quest quest : chapter.quests) {
                    quest.readNetData(buffer);
                    for (Task task : quest.tasks) {
                        task.readNetData(buffer);
                    }
                    for (Reward reward : quest.rewards) {
                        reward.readNetData(buffer);
                    }
                }
            }
        }
        this.updateLootCrates();
        FTBQuests.LOGGER.info("Read " + (buffer.readerIndex() - pos) + " bytes, " + this.map.size() + " objects");
    }

    @Override
    public long getParentID() {
        return 0L;
    }

    @Nullable
    public TeamData getNullableTeamData(UUID id) {
        return this.teamDataMap.get(id);
    }

    public TeamData getData(UUID teamId) {
        TeamData teamData = this.teamDataMap.get(teamId);
        if (teamData == null) {
            teamData = new TeamData(teamId);
            teamData.file = this;
            this.teamDataMap.put(teamData.uuid, teamData);
        }
        return teamData;
    }

    public TeamData getData(TeamBase team) {
        return this.getData(Objects.requireNonNull(team, "Non-null team required!").getId());
    }

    public TeamData getData(Entity player) {
        return this.getData(FTBTeamsAPI.getPlayerTeamID((UUID)player.func_110124_au()));
    }

    public Collection<TeamData> getAllData() {
        return this.teamDataMap.values();
    }

    public abstract void deleteObject(long var1);

    @OnlyIn(value=Dist.CLIENT)
    public IFormattableTextComponent getAltTitle() {
        return new TranslationTextComponent("ftbquests.file");
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Icon getAltIcon() {
        return (Icon)ThemeProperties.MODPACK_ICON.get(this);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void getConfig(ConfigGroup config) {
        super.getConfig(config);
        config.addList("emergency_items", this.emergencyItems, (ConfigValue)new ItemStackConfig(false, false), (Object)ItemStack.field_190927_a);
        config.addInt("emergency_items_cooldown", this.emergencyItemsCooldown, v -> {
            this.emergencyItemsCooldown = v;
        }, 300, 0, Integer.MAX_VALUE);
        config.addBool("drop_loot_crates", this.dropLootCrates, v -> {
            this.dropLootCrates = v;
        }, false);
        config.addBool("disable_gui", this.disableGui, v -> {
            this.disableGui = v;
        }, false);
        config.addDouble("grid_scale", this.gridScale, v -> {
            this.gridScale = v;
        }, 0.5, 0.03125, 8.0);
        config.addString("lock_message", this.lockMessage, v -> {
            this.lockMessage = v;
        }, "");
        ConfigGroup defaultsGroup = config.getGroup("defaults");
        defaultsGroup.addBool("reward_team", this.defaultRewardTeam, v -> {
            this.defaultRewardTeam = v;
        }, false);
        defaultsGroup.addBool("consume_items", this.defaultTeamConsumeItems, v -> {
            this.defaultTeamConsumeItems = v;
        }, false);
        defaultsGroup.addEnum("autoclaim_rewards", (Object)this.defaultRewardAutoClaim, v -> {
            this.defaultRewardAutoClaim = v;
        }, RewardAutoClaim.NAME_MAP_NO_DEFAULT);
        defaultsGroup.addEnum("quest_shape", (Object)this.defaultQuestShape, v -> {
            this.defaultQuestShape = v;
        }, QuestShape.idMap);
        defaultsGroup.addBool("quest_disable_jei", this.defaultQuestDisableJEI, v -> {
            this.defaultQuestDisableJEI = v;
        }, false);
        ConfigGroup d = config.getGroup("loot_crate_no_drop");
        d.addInt("passive", this.lootCrateNoDrop.passive, v -> {
            this.lootCrateNoDrop.passive = v;
        }, 0, 0, Integer.MAX_VALUE).setNameKey("ftbquests.loot.entitytype.passive");
        d.addInt("monster", this.lootCrateNoDrop.monster, v -> {
            this.lootCrateNoDrop.monster = v;
        }, 0, 0, Integer.MAX_VALUE).setNameKey("ftbquests.loot.entitytype.monster");
        d.addInt("boss", this.lootCrateNoDrop.boss, v -> {
            this.lootCrateNoDrop.boss = v;
        }, 0, 0, Integer.MAX_VALUE).setNameKey("ftbquests.loot.entitytype.boss");
    }

    @Override
    public void clearCachedData() {
        super.clearCachedData();
        this.allTasks = null;
        this.submitTasks = null;
        for (ChapterGroup group : this.chapterGroups) {
            group.clearCachedData();
        }
        this.clearCachedProgress();
        ((Consumer)ClearFileCacheEvent.EVENT.invoker()).accept(new ClearFileCacheEvent(this));
    }

    public void clearCachedProgress() {
        for (TeamData data : this.getAllData()) {
            data.clearCachedProgress();
        }
    }

    public long newID() {
        return this.readID(0L);
    }

    public long readID(long id) {
        while (id == 0L || id == 1L || this.map.get(id) != null) {
            id = Math.abs(MathUtils.RAND.nextLong());
            this.save();
        }
        return id;
    }

    public long readID(@Nullable INBT tag) {
        if (tag instanceof NumberNBT) {
            this.save();
            return this.readID(((NumberNBT)tag).func_150291_c());
        }
        if (tag instanceof StringNBT) {
            try {
                String id = tag.func_150285_a_();
                return this.readID(Long.parseLong(id.charAt(0) == '#' ? id.substring(1) : id, 16));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.newID();
    }

    public long getID(@Nullable Object o) {
        if (o == null) {
            return 0L;
        }
        if (o instanceof Number) {
            return ((Number)o).longValue();
        }
        if (o instanceof NumberNBT) {
            return ((NumberNBT)o).func_150291_c();
        }
        if (o instanceof StringNBT) {
            return this.getID(((StringNBT)o).func_150285_a_());
        }
        String id = o.toString();
        long idl = QuestFile.parseCodeString(id);
        if (idl == 0L && id.length() >= 2 && id.charAt(0) == '#') {
            String t = id.substring(1);
            for (QuestObjectBase b : this.map.values()) {
                if (!b.hasTag(t)) continue;
                return b.id;
            }
        }
        return idl;
    }

    @Nullable
    public LootCrate getRandomLootCrate(Entity entity, Random random) {
        int totalWeight = this.lootCrateNoDrop.getWeight(entity);
        for (RewardTable table : this.rewardTables) {
            if (table.lootCrate == null) continue;
            totalWeight += table.lootCrate.drops.getWeight(entity);
        }
        if (totalWeight <= 0) {
            return null;
        }
        int number = random.nextInt(totalWeight) + 1;
        int currentWeight = this.lootCrateNoDrop.getWeight(entity);
        if (currentWeight < number) {
            for (RewardTable table : this.rewardTables) {
                if (table.lootCrate == null || (currentWeight += table.lootCrate.drops.getWeight(entity)) < number) continue;
                return table.lootCrate;
            }
        }
        return null;
    }

    @Override
    public final int refreshJEI() {
        return FTBQuestsJEIHelper.QUESTS | FTBQuestsJEIHelper.LOOTCRATES;
    }

    public final Collection<QuestObjectBase> getAllObjects() {
        return this.map.values();
    }

    @Override
    public boolean isVisible(TeamData data) {
        for (ChapterGroup group : this.chapterGroups) {
            if (!group.isVisible(data)) continue;
            return true;
        }
        return false;
    }

    public List<Chapter> getAllChapters() {
        ArrayList<Chapter> list = new ArrayList<Chapter>();
        for (ChapterGroup g : this.chapterGroups) {
            list.addAll(g.chapters);
        }
        return list;
    }

    public List<Task> getAllTasks() {
        if (this.allTasks == null) {
            this.allTasks = new ArrayList<Task>();
            for (ChapterGroup g : this.chapterGroups) {
                for (Chapter c : g.chapters) {
                    for (Quest q : c.quests) {
                        this.allTasks.addAll(q.tasks);
                    }
                }
            }
        }
        return this.allTasks;
    }

    public List<Task> getSubmitTasks() {
        if (this.submitTasks == null) {
            this.submitTasks = new ArrayList<Task>();
            for (Task task : this.getAllTasks()) {
                if (!task.submitItemsOnInventoryChange()) continue;
                this.submitTasks.add(task);
            }
        }
        return this.submitTasks;
    }

    public List<Chapter> getVisibleChapters(TeamData data) {
        ArrayList<Chapter> list = new ArrayList<Chapter>();
        for (ChapterGroup group : this.chapterGroups) {
            list.addAll(group.getVisibleChapters(data));
        }
        return list;
    }

    @Nullable
    public Chapter getFirstVisibleChapter(TeamData data) {
        for (ChapterGroup group : this.chapterGroups) {
            Chapter c = group.getFirstVisibleChapter(data);
            if (c == null) continue;
            return c;
        }
        return null;
    }

    public <T extends QuestObjectBase> List<T> collect(Predicate<QuestObjectBase> filter) {
        ArrayList<QuestObjectBase> list = new ArrayList<QuestObjectBase>();
        for (QuestObjectBase base : this.getAllObjects()) {
            if (!filter.test(base)) continue;
            list.add(base);
        }
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        if (list.size() == 1) {
            return Collections.singletonList((QuestObjectBase)list.get(0));
        }
        return list;
    }

    public <T extends QuestObjectBase> List<T> collect(Class<T> clazz) {
        return this.collect((QuestObjectBase o) -> clazz.isAssignableFrom(o.getClass()));
    }

    public String getDefaultQuestShape() {
        return this.defaultQuestShape;
    }

    public void addData(TeamData data, boolean override) {
        if (override || !this.teamDataMap.containsKey(data.uuid)) {
            this.teamDataMap.put(data.uuid, data);
        }
    }

    public void refreshGui() {
        this.clearCachedData();
    }

    @Override
    public Collection<? extends QuestObject> getChildren() {
        return this.chapterGroups;
    }

    @Override
    public boolean hasUnclaimedRewardsRaw(TeamData teamData, UUID player) {
        for (ChapterGroup group : this.chapterGroups) {
            if (!teamData.hasUnclaimedRewards(player, group)) continue;
            return true;
        }
        return false;
    }
}

