/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.client;

import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftblibrary.ui.BaseScreen;
import dev.ftb.mods.ftblibrary.util.ClientTextComponentUtils;
import dev.ftb.mods.ftblibrary.util.ClientUtils;
import dev.ftb.mods.ftbquests.gui.CustomToast;
import dev.ftb.mods.ftbquests.gui.quests.QuestScreen;
import dev.ftb.mods.ftbquests.integration.jei.FTBQuestsJEIHelper;
import dev.ftb.mods.ftbquests.net.DeleteObjectMessage;
import dev.ftb.mods.ftbquests.quest.Movable;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.QuestFile;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.theme.QuestTheme;
import dev.ftb.mods.ftbteams.data.ClientTeamManager;
import java.util.Objects;
import java.util.UUID;
import me.shedaniel.architectury.utils.Env;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.toasts.IToast;
import net.minecraft.entity.Entity;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class ClientQuestFile
extends QuestFile {
    public static ClientQuestFile INSTANCE;
    public TeamData self;
    public QuestScreen questScreen;
    public BaseScreen questGui;

    public static boolean exists() {
        return INSTANCE != null && !ClientQuestFile.INSTANCE.invalid;
    }

    @Override
    public void load() {
        if (INSTANCE != null) {
            INSTANCE.deleteChildren();
            INSTANCE.deleteSelf();
        }
        this.self = new TeamData(Util.field_240973_b_);
        this.self.file = this;
        this.self.name = "Loading...";
        this.self.setLocked(true);
        INSTANCE = this;
        this.refreshGui();
        FTBQuestsJEIHelper.refresh(this);
    }

    @Override
    public boolean canEdit() {
        return this.self.getCanEdit();
    }

    @Override
    public void refreshGui() {
        this.clearCachedData();
        boolean hasPrev = false;
        boolean guiOpen = false;
        int zoom = 0;
        double scrollX = 0.0;
        double scrollY = 0.0;
        long selectedChapter = 0L;
        long[] selectedQuests = new long[]{};
        boolean chaptersExpanded = false;
        if (this.questScreen != null) {
            hasPrev = true;
            zoom = this.questScreen.zoom;
            scrollX = this.questScreen.questPanel.centerQuestX;
            scrollY = this.questScreen.questPanel.centerQuestY;
            selectedChapter = this.questScreen.selectedChapter == null ? 0L : this.questScreen.selectedChapter.id;
            selectedQuests = new long[this.questScreen.selectedObjects.size()];
            int i = 0;
            for (Movable m : this.questScreen.selectedObjects) {
                if (m instanceof Quest) {
                    selectedQuests[i] = ((Quest)m).id;
                }
                ++i;
            }
            if (ClientUtils.getCurrentGuiAs(QuestScreen.class) != null) {
                guiOpen = true;
            }
            chaptersExpanded = this.questScreen.chapterPanel.expanded;
        }
        this.questScreen = new QuestScreen(this);
        this.questGui = this.questScreen;
        if (hasPrev) {
            this.questScreen.zoom = zoom;
            this.questScreen.selectChapter(this.getChapter(selectedChapter));
            for (long i : selectedQuests) {
                Quest q = this.getQuest(i);
                if (q == null) continue;
                this.questScreen.selectedObjects.add(q);
            }
            if (guiOpen) {
                this.questScreen.openGui();
            }
        }
        this.questScreen.refreshWidgets();
        if (hasPrev) {
            this.questScreen.questPanel.scrollTo(scrollX, scrollY);
        }
        this.questScreen.chapterPanel.setExpanded(chaptersExpanded);
    }

    public void openQuestGui() {
        if (ClientQuestFile.exists()) {
            if (this.disableGui && !this.canEdit()) {
                Minecraft.func_71410_x().func_193033_an().func_192988_a((IToast)new CustomToast((ITextComponent)new TranslationTextComponent("item.ftbquests.book.disabled"), Icons.BARRIER, StringTextComponent.field_240750_d_));
            } else if (this.self.isLocked()) {
                Minecraft.func_71410_x().func_193033_an().func_192988_a((IToast)new CustomToast((ITextComponent)(this.lockMessage.isEmpty() ? new StringTextComponent("Quests locked!") : ClientTextComponentUtils.parse((String)this.lockMessage)), Icons.BARRIER, StringTextComponent.field_240750_d_));
            } else {
                this.questGui.openGui();
            }
        }
    }

    @Override
    public Env getSide() {
        return Env.CLIENT;
    }

    @Override
    public void deleteObject(long id) {
        new DeleteObjectMessage(id).sendToServer();
    }

    @Override
    public void clearCachedData() {
        super.clearCachedData();
        QuestTheme.instance.clearCache();
    }

    @Override
    public TeamData getData(Entity player) {
        return player == Minecraft.func_71410_x().field_71439_g ? this.self : this.getData(Objects.requireNonNull(ClientTeamManager.INSTANCE.getKnownPlayer((UUID)player.func_110124_au()), (String)"Non-null team required!").teamId);
    }
}

