/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.scuba_gear;

import com.google.common.collect.ImmutableList;
import com.legacy.scuba_gear.ScubaConfig;
import com.legacy.scuba_gear.ScubaRegistry;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.monster.DrownedEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ScubaEvents {
    private static final List<Item> SCUBA_GEAR = ImmutableList.of((Object)ScubaRegistry.SCUBA_HELMET, (Object)ScubaRegistry.SCUBA_CHESTPLATE, (Object)ScubaRegistry.SCUBA_LEGGINGS, (Object)ScubaRegistry.SCUBA_BOOTS);
    private static final AttributeModifier HELMET_SPEED_MODIFIER = new AttributeModifier("scuba helmet land speed reduction", (double)-0.003f, AttributeModifier.Operation.ADDITION);
    private static final AttributeModifier CHESTPLATE_SPEED_MODIFIER = new AttributeModifier("scuba chestplate land speed reduction", (double)-0.005f, AttributeModifier.Operation.ADDITION);
    private static final AttributeModifier LEGGINGS_SPEED_MODIFIER = new AttributeModifier("scuba leggings land speed reduction", (double)-0.002f, AttributeModifier.Operation.ADDITION);
    private static final AttributeModifier BOOTS_SPEED_MODIFIER = new AttributeModifier("scuba boots land speed reduction", (double)-0.001f, AttributeModifier.Operation.ADDITION);
    private static final AttributeModifier SWIM_SPEED_MODIFIER = new AttributeModifier("scuba swim speed addition", (double)0.3f, AttributeModifier.Operation.ADDITION);
    private static final AttributeModifier UNDERWATER_WALK_SPEED_MODIFIER = new AttributeModifier("scuba underwater walk speed addition", (double)0.8f, AttributeModifier.Operation.ADDITION);

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        Entity entity = event.getEntity();
        if (event.getEntity() instanceof DrownedEntity && this.isRuinOrWreckNearby(event.getEntity())) {
            float chance = entity.field_70170_p.field_73012_v.nextFloat();
            if (chance < 0.5f) {
                event.getEntity().func_184201_a(EquipmentSlotType.HEAD, new ItemStack((IItemProvider)ScubaRegistry.SCUBA_HELMET));
            }
            if (chance < 0.4f) {
                event.getEntity().func_184201_a(EquipmentSlotType.FEET, new ItemStack((IItemProvider)ScubaRegistry.SCUBA_BOOTS));
            }
            if (chance < 0.3f) {
                event.getEntity().func_184201_a(EquipmentSlotType.LEGS, new ItemStack((IItemProvider)ScubaRegistry.SCUBA_LEGGINGS));
            }
            if (chance < 0.2f) {
                event.getEntity().func_184201_a(EquipmentSlotType.CHEST, new ItemStack((IItemProvider)ScubaRegistry.SCUBA_CHESTPLATE));
            }
        }
    }

    @SubscribeEvent
    public void onLivingAttack(LivingAttackEvent event) {
        if (event.getSource().func_76347_k() && ScubaEvents.isWearingFullScuba(event.getEntityLiving())) {
            event.getEntityLiving().func_241209_g_(0);
            event.setCanceled(true);
            event.getEntityLiving().func_184193_aE().forEach(armor -> {
                if (event.getEntityLiving() instanceof ServerPlayerEntity && event.getEntityLiving().field_70173_aa % 10 == 0 && !event.getEntityLiving().field_70170_p.field_72995_K) {
                    armor.func_222118_a(1, event.getEntityLiving(), living -> {});
                }
            });
        }
    }

    @SubscribeEvent
    public void onLivingTick(LivingEvent.LivingUpdateEvent event) {
        LivingEntity living = event.getEntityLiving();
        if (living instanceof PlayerEntity || living instanceof DrownedEntity) {
            this.checkAddAndRemoveModifier(living, ScubaEvents.isWearingScubaOnSlot(living, EquipmentSlotType.HEAD) && !living.func_203005_aq(), Attributes.field_233821_d_, HELMET_SPEED_MODIFIER);
            this.checkAddAndRemoveModifier(living, ScubaEvents.isWearingScubaOnSlot(living, EquipmentSlotType.CHEST) && !living.func_203005_aq(), Attributes.field_233821_d_, CHESTPLATE_SPEED_MODIFIER);
            this.checkAddAndRemoveModifier(living, ScubaEvents.isWearingScubaOnSlot(living, EquipmentSlotType.LEGS) && !living.func_203005_aq(), Attributes.field_233821_d_, LEGGINGS_SPEED_MODIFIER);
            this.checkAddAndRemoveModifier(living, ScubaEvents.isWearingScubaOnSlot(living, EquipmentSlotType.FEET) && !living.func_203005_aq(), Attributes.field_233821_d_, BOOTS_SPEED_MODIFIER);
            this.checkAddAndRemoveModifier(living, living.func_213314_bj() && ScubaEvents.isWearingScubaOnSlot(living, EquipmentSlotType.LEGS), (Attribute)ForgeMod.SWIM_SPEED.get(), SWIM_SPEED_MODIFIER);
            this.checkAddAndRemoveModifier(living, !living.func_203007_ba() && ScubaEvents.isWearingScubaOnSlot(living, EquipmentSlotType.FEET), (Attribute)ForgeMod.SWIM_SPEED.get(), UNDERWATER_WALK_SPEED_MODIFIER);
            if (ScubaEvents.isWearingScubaOnSlot(living, EquipmentSlotType.HEAD) && living.func_208600_a((ITag)FluidTags.field_206959_a) && !living.field_70170_p.field_72995_K) {
                living.func_195064_c(new EffectInstance(Effects.field_76427_o, 5, 0, false, false, false));
            }
            if (living instanceof PlayerEntity && living.func_203005_aq() && !living.field_70170_p.field_72995_K && living.field_70173_aa % 80 == 0) {
                if (ScubaEvents.isWearingScubaOnSlot(living, EquipmentSlotType.HEAD)) {
                    living.func_184582_a(EquipmentSlotType.HEAD).func_222118_a(1, living, entity -> entity.func_213361_c(EquipmentSlotType.HEAD));
                }
                if (ScubaEvents.isWearingScubaOnSlot(living, EquipmentSlotType.CHEST)) {
                    living.func_184582_a(EquipmentSlotType.CHEST).func_222118_a(1, living, entity -> entity.func_213361_c(EquipmentSlotType.CHEST));
                }
                if (ScubaEvents.isWearingScubaOnSlot(living, EquipmentSlotType.LEGS)) {
                    living.func_184582_a(EquipmentSlotType.LEGS).func_222118_a(1, living, entity -> entity.func_213361_c(EquipmentSlotType.LEGS));
                }
                if (ScubaEvents.isWearingScubaOnSlot(living, EquipmentSlotType.FEET)) {
                    living.func_184582_a(EquipmentSlotType.FEET).func_222118_a(1, living, entity -> entity.func_213361_c(EquipmentSlotType.FEET));
                }
            }
        }
    }

    @SubscribeEvent
    public void breakSpeed(PlayerEvent.BreakSpeed event) {
        if (ScubaEvents.isWearingScubaOnSlot(event.getEntityLiving(), EquipmentSlotType.CHEST) && event.getEntityLiving().func_208600_a((ITag)FluidTags.field_206959_a) && !event.getEntityLiving().func_70644_a(Effects.field_76419_f)) {
            event.setNewSpeed(event.getOriginalSpeed() + 0.7f);
        }
    }

    public static boolean isWearingScuba(LivingEntity living) {
        return ScubaEvents.isWearingScubaOnSlot(living, EquipmentSlotType.HEAD) || ScubaEvents.isWearingScubaOnSlot(living, EquipmentSlotType.CHEST) || ScubaEvents.isWearingScubaOnSlot(living, EquipmentSlotType.LEGS) || ScubaEvents.isWearingScubaOnSlot(living, EquipmentSlotType.FEET);
    }

    public static boolean isWearingFullScuba(LivingEntity living) {
        return ScubaEvents.isWearingScubaOnSlot(living, EquipmentSlotType.HEAD) && ScubaEvents.isWearingScubaOnSlot(living, EquipmentSlotType.CHEST) && ScubaEvents.isWearingScubaOnSlot(living, EquipmentSlotType.LEGS) && ScubaEvents.isWearingScubaOnSlot(living, EquipmentSlotType.FEET);
    }

    public static boolean isWearingScubaOnSlot(LivingEntity living, EquipmentSlotType pieceValue) {
        return SCUBA_GEAR.contains(living.func_184582_a(pieceValue).func_77973_b());
    }

    public void checkAddAndRemoveModifier(LivingEntity living, boolean condition, Attribute attribute, AttributeModifier modifier) {
        if (condition) {
            if (!living.func_110148_a(attribute).func_180374_a(modifier)) {
                living.func_110148_a(attribute).func_233767_b_(modifier);
            }
        } else {
            this.removeModifier(living, attribute, modifier);
        }
    }

    public void removeModifier(LivingEntity living, Attribute attribute, AttributeModifier modifier) {
        if (living.func_110148_a(attribute).func_180374_a(modifier)) {
            living.func_110148_a(attribute).func_111124_b(modifier);
        }
    }

    public boolean isRuinOrWreckNearby(Entity entity) {
        BlockPos pos = entity.func_233580_cy_();
        World world = entity.field_70170_p;
        if (world instanceof ServerWorld && ((ServerWorld)world).func_241112_a_().func_235010_a_(pos, true, Structure.field_236377_m_).func_75069_d()) {
            return true;
        }
        int radius = ScubaConfig.COMMON.getMaxDistanceFromRuin();
        BlockPos min = pos.func_177982_a(-radius, -radius, -radius);
        BlockPos max = pos.func_177982_a(radius, radius, radius);
        for (BlockPos posAround : BlockPos.Mutable.func_218278_a((BlockPos)min, (BlockPos)max)) {
            if (!(world instanceof ServerWorld) || !((ServerWorld)world).func_241112_a_().func_235010_a_(posAround, true, Structure.field_236377_m_).func_75069_d()) continue;
            return true;
        }
        return false;
    }
}

