/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.proxy;

import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.settings.PointOfView;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import ovh.corail.tombstone.block.SoulType;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.PlayerPreference;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.item.CastingType;
import ovh.corail.tombstone.network.PacketHandler;
import ovh.corail.tombstone.network.UpdateServerMessage;
import ovh.corail.tombstone.particle.ParticleCasting;
import ovh.corail.tombstone.particle.ParticleGraveSmoke;
import ovh.corail.tombstone.particle.ParticleGraveSoul;
import ovh.corail.tombstone.particle.ParticleMagicCircle;
import ovh.corail.tombstone.particle.ParticleRounding;
import ovh.corail.tombstone.particle.ParticleShadowStep;
import ovh.corail.tombstone.particle.ParticleSmokeColumn;
import ovh.corail.tombstone.proxy.IProxy;
import ovh.corail.tombstone.registry.ModBlocks;
import ovh.corail.tombstone.registry.ModEntities;
import ovh.corail.tombstone.render.CloudRenderer;
import ovh.corail.tombstone.render.GraveGuardianRenderer;
import ovh.corail.tombstone.render.RenderWritableGrave;

@OnlyIn(value=Dist.CLIENT)
public final class ClientProxy
implements IProxy {
    private boolean isConfigDirty = false;
    private PlayerPreference lastPlayerPreference;

    @Override
    public void preInit() {
        ClientRegistry.bindTileEntityRenderer(ModBlocks.tile_decorative_grave, RenderWritableGrave::new);
        ClientRegistry.bindTileEntityRenderer(ModBlocks.tile_grave, RenderWritableGrave::new);
        EntityRendererManager entityRenderDispatcher = Minecraft.func_71410_x().func_175598_ae();
        entityRenderDispatcher.func_229087_a_(ModEntities.grave_guardian, (EntityRenderer)new GraveGuardianRenderer(entityRenderDispatcher));
        entityRenderDispatcher.func_229087_a_(ModEntities.cloud, (EntityRenderer)new CloudRenderer(entityRenderDispatcher));
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public void produceGraveSmoke(World level, double x, double y, double z) {
        this.produceGraveSmoke(level, x, y, z, TimeHelper.isDateAroundHalloween() ? 0xFFFFFF : (Integer)ConfigTombstone.client.fogColor.get());
    }

    @Override
    public void produceGraveSmoke(World level, double x, double y, double z, int color) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.func_147113_T() || ((ConfigTombstone.Client.FogDensity)((Object)ConfigTombstone.client.fogDensity.get())).ordinal() == 0) {
            return;
        }
        if (mc.field_71460_t.func_215316_n().func_216785_c().func_186679_c(x, y, z) <= 1024.0 && Helper.RANDOM.nextBoolean()) {
            mc.field_71452_i.func_78873_a((Particle)new ParticleGraveSmoke((ClientWorld)level, x + Helper.RANDOM.nextGaussian(), y, z + Helper.RANDOM.nextGaussian(), (double)(Helper.RANDOM.nextFloat() - 0.5f) * 0.01, 0.0, (double)(Helper.RANDOM.nextFloat() - 0.5f) * 0.01).withColor(color));
        }
    }

    @Override
    public void produceShadowStep(LivingEntity entity) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.func_147113_T()) {
            return;
        }
        if (mc.field_71439_g != null && mc.field_71439_g.equals((Object)entity) && mc.field_71474_y.func_243230_g() == PointOfView.FIRST_PERSON) {
            return;
        }
        if (mc.field_71441_e != null && !entity.func_184218_aH() && !entity.func_70608_bn()) {
            mc.field_71452_i.func_78873_a((Particle)new ParticleShadowStep(mc.field_71441_e, entity));
        }
    }

    @Override
    public void produceShield(LivingEntity entity) {
        Minecraft mc = Minecraft.func_71410_x();
        if (!(mc.func_147113_T() || mc.field_71441_e == null || entity.func_184218_aH() || entity.func_70608_bn())) {
            mc.field_71452_i.func_78873_a((Particle)new ParticleRounding(mc.field_71441_e, entity, ParticleRounding.Type.SHIELD));
        }
    }

    @Override
    public void producePray(LivingEntity entity, int type, Predicate<LivingEntity> predic) {
        Minecraft mc = Minecraft.func_71410_x();
        if (!mc.func_147113_T() && mc.field_71441_e != null) {
            mc.field_71452_i.func_78873_a((Particle)new ParticleRounding(mc.field_71441_e, entity, ParticleRounding.Type.byId(type), predic));
            mc.field_71452_i.func_78873_a((Particle)new ParticleCasting(mc.field_71441_e, entity, predic));
        }
    }

    @Override
    public void produceBoneShield(LivingEntity entity) {
        Minecraft mc = Minecraft.func_71410_x();
        if (!(mc.func_147113_T() || mc.field_71441_e == null || entity.func_184218_aH() || entity.func_70608_bn())) {
            mc.field_71452_i.func_78873_a((Particle)new ParticleRounding(mc.field_71441_e, entity, ParticleRounding.Type.BONE));
        }
    }

    @Override
    public void produceGraveSoul(World level, BlockPos pos, SoulType soulType, int part) {
        Minecraft mc = Minecraft.func_71410_x();
        if (!mc.func_147113_T() && mc.field_71460_t.func_215316_n().func_216785_c().func_186679_c((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()) <= 1024.0) {
            mc.field_71452_i.func_78873_a((Particle)new ParticleGraveSoul((ClientWorld)level, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.85, (double)pos.func_177952_p() + 0.5, soulType.ordinal(), part));
        }
    }

    @Override
    public void produceParticleCasting(CastingType castingType, LivingEntity entity, Predicate<LivingEntity> predic) {
        Minecraft mc = Minecraft.func_71410_x();
        if (!mc.func_147113_T() && entity != null && mc.field_71441_e != null) {
            if (((Boolean)ConfigTombstone.client.showMagicCircle.get()).booleanValue()) {
                mc.field_71452_i.func_78873_a((Particle)new ParticleMagicCircle(mc.field_71441_e, castingType, entity, predic));
            }
            mc.field_71452_i.func_78873_a((Particle)new ParticleCasting(mc.field_71441_e, entity, predic));
        }
    }

    @Override
    public void produceSmokeColumn(World level, Vector3d vec) {
        Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)new ParticleSmokeColumn((ClientWorld)level, vec.field_72450_a, vec.field_72448_b, vec.field_72449_c));
    }

    @Override
    public void markConfigDirty() {
        this.isConfigDirty = true;
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END && this.isConfigDirty) {
            this.isConfigDirty = false;
            if (Minecraft.func_71410_x().field_71439_g == null) {
                this.lastPlayerPreference = PlayerPreference.fromClientConfig();
            } else if (this.lastPlayerPreference.hasChangedFromConfig()) {
                LangKey.sendMessage((ITextComponent)new StringTextComponent("Syncing Preferences on Server"), (PlayerEntity)Minecraft.func_71410_x().field_71439_g);
                this.lastPlayerPreference = PlayerPreference.fromClientConfig();
                PacketHandler.sendToServer(new UpdateServerMessage(this.lastPlayerPreference, false));
            }
        }
    }

    @Override
    public PlayerPreference initPlayerPreference() {
        this.lastPlayerPreference = PlayerPreference.fromClientConfig();
        return this.lastPlayerPreference;
    }

    @Override
    @Nullable
    public PlayerEntity getClientPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }
}

