/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.perk;

import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import ovh.corail.tombstone.api.capability.Perk;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.TimeHelper;

public class PerkVoodooPoppet
extends Perk {
    public PerkVoodooPoppet() {
        super("voodoo_poppet", new ResourceLocation("tombstone", "textures/item/voodoo_poppet.png"));
    }

    @Override
    public int getLevelMax() {
        return 5;
    }

    @Override
    public boolean isDisabled(@Nullable PlayerEntity player) {
        return (Boolean)SharedConfigTombstone.allowed_magic_items.allowVoodooPoppet.get() == false;
    }

    @Override
    public String getTranslationKey() {
        return "tombstone.item.voodoo_poppet";
    }

    @Override
    public ITextComponent getTooltip(int level, int actualLevel, int levelWithBonus) {
        if (level == actualLevel || actualLevel == 0 && level == 1 || level == levelWithBonus) {
            return new StringTextComponent("+" + level * 10 + "% ").func_230529_a_(this.getDescription());
        }
        if (level == actualLevel + 1) {
            return new StringTextComponent("+" + level * 10 + "%");
        }
        return StringTextComponent.field_240750_d_;
    }

    @Override
    public int getLevelBonus(PlayerEntity player) {
        return TimeHelper.isDateAroundHalloween() ? 5 : 0;
    }

    @Override
    public ITextComponent getSpecialInfo(int levelWithBonus) {
        return LangKey.TOOLTIP_CHANCE_TRIGGER.getText(50 + levelWithBonus * 10);
    }
}

