/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.perk;

import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import ovh.corail.tombstone.api.capability.Perk;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.TimeHelper;

public class PerkGhostlyShape
extends Perk {
    public PerkGhostlyShape() {
        super("ghostly_shape", new ResourceLocation("tombstone", "textures/mob_effect/ghostly_shape.png"));
    }

    @Override
    public int getLevelMax() {
        return 5;
    }

    @Override
    public boolean isDisabled(@Nullable PlayerEntity player) {
        return (Integer)SharedConfigTombstone.general.ghostlyShapeDuration.get() <= 0;
    }

    @Override
    public String getTranslationKey() {
        return "effect.tombstone.ghostly_shape";
    }

    @Override
    public ITextComponent getTooltip(int level, int actualLevel, int levelWithBonus) {
        if (level == 1) {
            return new TranslationTextComponent("effect.tombstone.feather_fall");
        }
        if (level == 2) {
            return LangKey.MESSAGE_BREATHING.getText(new Object[0]);
        }
        if (level == 3) {
            return new TranslationTextComponent("effect.tombstone.purification");
        }
        if (level == 4) {
            return new TranslationTextComponent("effect.tombstone.true_sight");
        }
        if (level == 5) {
            return LangKey.MESSAGE_INVULNERABLE.getText(new Object[0]);
        }
        return StringTextComponent.field_240750_d_;
    }

    @Override
    public boolean isEncrypted() {
        return true;
    }

    @Override
    public int getLevelBonus(PlayerEntity player) {
        return TimeHelper.isDateAroundHalloween() ? 5 : 0;
    }

    @Override
    public ITextComponent getSpecialInfo(int levelWithBonus) {
        return this.getDescription();
    }
}

