/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.particle;

import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.particle.BoundParticle;
import ovh.corail.tombstone.particle.ParticleBlinkingAura;

@OnlyIn(value=Dist.CLIENT)
public final class ParticleRounding
extends BoundParticle {
    private static final EnumMap<Type, ResourceLocation> COMMON_TEXTURE = new EnumMap(Arrays.stream(Type.values()).collect(Collectors.toMap(Function.identity(), type -> Type.access$300(type))));
    private final Type type;
    private final int count;
    private final double height;
    @Nullable
    private final Predicate<LivingEntity> requireRemoval;

    public ParticleRounding(ClientWorld level, LivingEntity entity, Type type) {
        this(level, entity, type, null);
    }

    public ParticleRounding(ClientWorld level, LivingEntity entity, Type type, @Nullable Predicate<LivingEntity> requireRemoval) {
        super(level, entity, entity.func_213311_cf());
        this.type = type;
        this.count = MathHelper.func_76143_f((double)((double)entity.func_213311_cf() * (Math.PI * 2)));
        this.height = (Double)type.heightProvider.apply(entity);
        this.requireRemoval = requireRemoval;
        if (this.type.rolling) {
            this.setRolling(0.31415927f);
        }
        this.setSolid(true);
    }

    @Override
    protected void addParticleDatas(List<BoundParticle.ParticleData> datas) {
        IntStream.range(0, this.count).forEach(part -> datas.add(new BoundParticle.ParticleData(this.type.size, (double)part / (double)this.count, this.height, this.type.rolling ? (part % 2 == 0 ? 0.0f : (float)Math.PI) : 0.0f)));
    }

    @Override
    protected boolean requireRemoval() {
        return this.requireRemoval != null ? Optional.ofNullable(this.entityWeakReference.get()).map(this.requireRemoval::test).orElse(true).booleanValue() : super.requireRemoval();
    }

    @Override
    protected ResourceLocation getTexture() {
        return COMMON_TEXTURE.get((Object)this.type);
    }

    @Override
    protected void onParticleDataUpdate(BoundParticle.ParticleData data, double ratio) {
        super.onParticleDataUpdate(data, ratio);
        if (this.type == Type.BONE) {
            ParticleBlinkingAura part = new ParticleBlinkingAura(this.field_187122_b, data.pos.field_72450_a, data.pos.field_72448_b, data.pos.field_72449_c, 1.0f, 0.8f, Helper.RANDOM.nextFloat() + 0.5f);
            part.func_82338_g(0.15f);
            part.func_70541_f(2.5f);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)part);
        }
    }

    public static enum Type {
        HEART(new ResourceLocation("minecraft", "textures/particle/heart.png"), 0.6f, false),
        SHIELD(new ResourceLocation("tombstone", "textures/item/pray_of_protection.png"), 1.0f, false, entity -> 0.3),
        BONE(new ResourceLocation("minecraft", "textures/item/bone.png"), 1.0f, true, entity -> 0.3),
        ANKH(new ResourceLocation("tombstone", "textures/item/ankh.png"), 1.0f, false);

        private final ResourceLocation rl;
        private final float size;
        private final boolean rolling;
        private final Function<LivingEntity, Double> heightProvider;

        private Type(ResourceLocation rl, float size, boolean rolling) {
            this(rl, size, rolling, entity -> (double)entity.func_213302_cg() / 4.0);
        }

        private Type(ResourceLocation rl, float size, boolean rolling, Function<LivingEntity, Double> heightProvider) {
            this.rl = rl;
            this.size = size;
            this.rolling = rolling;
            this.heightProvider = heightProvider;
        }

        public static Type byId(int id) {
            return Type.values()[MathHelper.func_76125_a((int)id, (int)0, (int)(Type.values().length - 1))];
        }
    }
}

