/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.particle;

import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import ovh.corail.tombstone.block.SoulType;
import ovh.corail.tombstone.particle.CustomParticle;
import ovh.corail.tombstone.particle.ParticleBlinkingAura;

@OnlyIn(value=Dist.CLIENT)
public final class ParticleGraveSoul
extends CustomParticle {
    private static final ResourceLocation COMMON_TEXTURE = new ResourceLocation("tombstone", "textures/particle/soul.png");
    private static final double RADIUS = 0.3;
    private static final double SECTION = 1.5707963267948966;
    private final double centerX;
    private final double centerY;
    private final double centerZ;
    private final int part;

    public ParticleGraveSoul(ClientWorld world, double centerX, double centerY, double centerZ, int soulTypeId, int part) {
        super(world, centerX, centerY, centerZ);
        this.centerX = centerX;
        this.centerY = centerY;
        this.centerZ = centerZ;
        this.part = part;
        this.func_187114_a(25);
        this.func_70541_f(soulTypeId > 1 ? 0.2f : 0.15f);
        this.withColor(SoulType.byId(soulTypeId).getColorCode());
        this.func_82338_g(0.5f);
        this.updatePosition();
        this.updateLastPos();
    }

    @Override
    protected void updatePosition() {
        this.field_187131_k = 0.0;
        this.field_187130_j = 0.0;
        this.field_187129_i = 0.0;
        double ratio = (double)this.field_70546_d / (double)this.field_70547_e;
        Vector3d vec = new Vector3d(this.centerX + 0.3 * Math.cos(1.5707963267948966 * (ratio + (double)this.part)), this.centerY, this.centerZ + 0.3 * Math.sin(1.5707963267948966 * (ratio + (double)this.part)));
        this.func_187109_b(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
    }

    @Override
    public void update() {
        super.update();
        Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)new ParticleBlinkingAura(this.field_187122_b, this.field_187126_f, this.field_187127_g + 0.02, this.field_187128_h, this.field_70552_h, this.field_70553_i, this.field_70551_j));
    }

    @Override
    protected ResourceLocation getTexture() {
        return COMMON_TEXTURE;
    }
}

