/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.particle;

import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import ovh.corail.tombstone.particle.CustomParticle;

@OnlyIn(value=Dist.CLIENT)
abstract class BoundParticle
extends CustomParticle {
    private boolean initialized = false;
    protected final WeakReference<LivingEntity> entityWeakReference;
    private final double radius;
    private final List<ParticleData> particleDatas = new ArrayList<ParticleData>();

    BoundParticle(ClientWorld level, LivingEntity entity, double radius) {
        super(level, entity.func_213303_ch());
        this.entityWeakReference = new WeakReference<LivingEntity>(entity);
        this.radius = radius;
        this.func_187114_a(20);
        this.func_187115_a(4.0f, 2.0f);
    }

    protected abstract void addParticleDatas(List<ParticleData> var1);

    protected void onParticleDataUpdate(ParticleData data, double ratio) {
        Vector3d newPos = new Vector3d(this.field_187126_f, this.field_187127_g, this.field_187128_h).func_72441_c(this.radius * Math.cos(Math.PI * 2 * (data.angle + ratio)), data.yHeight, this.radius * Math.sin(Math.PI * 2 * (data.angle + ratio)));
        data.oPos = data.pos == null ? newPos : data.pos;
        data.pos = newPos;
    }

    @Override
    @Deprecated
    public Particle func_70541_f(float scale) {
        return this;
    }

    @Override
    public void setRolling(float rollIncrement) {
        this.setRolling(0.0f, rollIncrement);
    }

    @Override
    protected boolean requireRemoval() {
        return this.field_70546_d >= this.field_70547_e + 1;
    }

    @Override
    public void func_189213_a() {
        LivingEntity entity = (LivingEntity)this.entityWeakReference.get();
        if (entity == null) {
            this.func_187112_i();
            return;
        }
        if (!this.initialized) {
            this.updateLastPos();
            this.addParticleDatas(this.particleDatas);
            this.initialized = true;
        }
        if (this.requireRemoval()) {
            this.func_187112_i();
        } else {
            ++this.field_70546_d;
            double ratio = (double)(entity.field_70173_aa % 100) / 100.0;
            this.updateLastPos();
            this.func_187109_b(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_());
            this.update();
            this.particleDatas.forEach(data -> this.onParticleDataUpdate((ParticleData)data, ratio));
        }
    }

    @Override
    public void func_225606_a_(IVertexBuilder buffer, ActiveRenderInfo renderInfo, float partialTicks) {
        if (this.field_70546_d <= 1) {
            return;
        }
        this.beginRender();
        float rot = MathHelper.func_219799_g((float)partialTicks, (float)this.field_190015_G, (float)this.field_190014_F);
        for (ParticleData data : this.particleDatas) {
            Quaternion rollTransform;
            Vector3d vecFromCamera = new Vector3d(MathHelper.func_219803_d((double)partialTicks, (double)data.oPos.field_72450_a, (double)data.pos.field_72450_a), MathHelper.func_219803_d((double)partialTicks, (double)data.oPos.field_72448_b, (double)data.pos.field_72448_b), MathHelper.func_219803_d((double)partialTicks, (double)data.oPos.field_72449_c, (double)data.pos.field_72449_c)).func_178788_d(renderInfo.func_216785_c());
            int light = this.func_189214_a(partialTicks);
            if (this.field_190014_F == 0.0f) {
                rollTransform = renderInfo.func_227995_f_();
            } else {
                rollTransform = new Quaternion(renderInfo.func_227995_f_());
                rollTransform.func_195890_a(Vector3f.field_229183_f_.func_229193_c_(rot + data.startRoll));
            }
            Vector3f[] vecFaceQuad = this.getFaceQuad();
            Arrays.stream(vecFaceQuad).forEach(v -> {
                v.func_214905_a(rollTransform);
                v.func_195898_a(data.size);
                v.func_195904_b((float)vecFromCamera.field_72450_a, (float)vecFromCamera.field_72448_b, (float)vecFromCamera.field_72449_c);
            });
            this.addQuad(buffer, vecFaceQuad, light);
        }
        this.endRender();
    }

    protected class ParticleData {
        protected float size;
        protected float startRoll;
        protected double angle;
        protected double yHeight;
        protected Vector3d oPos;
        protected Vector3d pos;

        protected ParticleData(float size, double angle, double yHeight) {
            this(size, angle, yHeight, 0.0f);
        }

        protected ParticleData(float size, double angle, double yHeight, float startRoll) {
            this.size = size * 0.2f;
            this.angle = angle;
            this.yHeight = yHeight;
            this.startRoll = startRoll;
        }
    }
}

