/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.network;

import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;
import ovh.corail.tombstone.api.capability.Perk;
import ovh.corail.tombstone.api.capability.TBCapabilityProvider;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.network.PacketHandler;
import ovh.corail.tombstone.network.SyncCapClientMessage;
import ovh.corail.tombstone.perk.PerkRegistry;
import ovh.corail.tombstone.registry.ModTriggers;

public class UpgradePerkServerMessage {
    private final SyncType syncType;
    private final Perk perk;

    public UpgradePerkServerMessage(SyncType syncType, Perk perk) {
        this.syncType = syncType;
        this.perk = perk;
    }

    static UpgradePerkServerMessage fromBytes(PacketBuffer buf) {
        return new UpgradePerkServerMessage(SyncType.values()[buf.readShort()], (Perk)PerkRegistry.perkRegistry.getValue(buf.readInt()));
    }

    static void toBytes(UpgradePerkServerMessage msg, PacketBuffer buf) {
        buf.writeShort(msg.syncType.ordinal());
        buf.writeInt(PerkRegistry.perkRegistry.getID((IForgeRegistryEntry)msg.perk));
    }

    public static class Handler {
        static void handle(UpgradePerkServerMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context ctx = contextSupplier.get();
            if (Helper.isPacketToServer(ctx)) {
                ctx.enqueueWork(() -> {
                    ServerPlayerEntity player = ctx.getSender();
                    if (player != null) {
                        player.getCapability(TBCapabilityProvider.TB_CAPABILITY).ifPresent(cap -> {
                            int levelPerk = cap.getPerkLevel((PlayerEntity)player, message.perk);
                            int totalPerkPoints = cap.getTotalPerkPoints();
                            if (message.syncType == SyncType.UPGRADE_PERK && levelPerk < Math.min(message.perk.getLevelMax(), EntityHelper.getPerkLevelMaxForKnowledge(totalPerkPoints)) && totalPerkPoints - cap.getUsedPerkPoints((PlayerEntity)player) >= message.perk.getCost(levelPerk + 1)) {
                                cap.setPerk(message.perk, levelPerk + 1);
                                ModTriggers.SELECTED_PERKS.trigger(player);
                                PacketHandler.sendToPlayer(new SyncCapClientMessage(SyncCapClientMessage.SyncType.SET_PERK, message.perk, levelPerk + 1), player);
                            } else if (message.syncType == SyncType.DOWNGRADE_PERK && levelPerk > 0 && player.func_184812_l_()) {
                                cap.setPerk(message.perk, levelPerk - 1);
                                PacketHandler.sendToPlayer(new SyncCapClientMessage(SyncCapClientMessage.SyncType.SET_PERK, message.perk, levelPerk - 1), player);
                            }
                        });
                    }
                });
            }
            ctx.setPacketHandled(true);
        }
    }

    public static enum SyncType {
        UPGRADE_PERK,
        DOWNGRADE_PERK;

    }
}

