/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.network;

import java.util.function.Supplier;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import ovh.corail.tombstone.api.cooldown.CooldownType;
import ovh.corail.tombstone.helper.CooldownHandler;
import ovh.corail.tombstone.helper.Helper;

public class SyncCooldownMessage {
    private final boolean isFullSync;
    private CooldownType type;
    private long worldTime;
    private ListNBT cooldownTagList;

    public SyncCooldownMessage(CooldownType type, long worldTime) {
        this.isFullSync = false;
        this.type = type;
        this.worldTime = worldTime;
    }

    public SyncCooldownMessage(ListNBT cooldownTagList) {
        this.isFullSync = true;
        this.cooldownTagList = cooldownTagList;
    }

    static SyncCooldownMessage fromBytes(PacketBuffer buf) {
        if (buf.readBoolean()) {
            CompoundNBT compound = buf.func_150793_b();
            return new SyncCooldownMessage(compound != null ? compound.func_150295_c("tb_cooldowns", 10) : new ListNBT());
        }
        return new SyncCooldownMessage(CooldownType.values()[buf.readByte() & 0xFF], buf.readLong());
    }

    static void toBytes(SyncCooldownMessage msg, PacketBuffer buf) {
        buf.writeBoolean(msg.isFullSync);
        if (msg.isFullSync) {
            CompoundNBT compound = new CompoundNBT();
            compound.func_218657_a("tb_cooldowns", (INBT)msg.cooldownTagList);
            buf.func_150786_a(compound);
        } else {
            buf.writeByte(msg.type.ordinal());
            buf.writeLong(msg.worldTime);
        }
    }

    public static class Handler {
        static void handle(SyncCooldownMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context ctx = contextSupplier.get();
            if (Helper.isPacketToClient(ctx)) {
                ctx.enqueueWork(() -> {
                    if (message.isFullSync) {
                        CooldownHandler.INSTANCE.updateAllClientCooldowns(message.cooldownTagList);
                    } else {
                        CooldownHandler.INSTANCE.updateClientCooldown(message.type, message.worldTime);
                    }
                });
            }
            ctx.setPacketHandled(true);
        }
    }
}

