/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.loot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.Collections;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootFunction;
import net.minecraft.loot.LootFunctionType;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.loot.functions.ILootFunction;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import ovh.corail.tombstone.ModTombstone;
import ovh.corail.tombstone.enchantment.TombstoneEnchantment;

public class PreciseEnchantFunction
extends LootFunction {
    public static final ResourceLocation RL = new ResourceLocation("tombstone", "precise_enchant");
    public static final Serializer SERIALIZER = new Serializer();
    private final String id;
    private final int level;

    private PreciseEnchantFunction(ILootCondition[] conditionsIn, String id, int level) {
        super(conditionsIn);
        this.id = id;
        this.level = level;
    }

    public ItemStack func_215859_a(ItemStack stack, LootContext context) {
        ResourceLocation rl = new ResourceLocation(this.id);
        Enchantment enchant = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(rl);
        if (enchant != null && (!"tombstone".equals(rl.func_110624_b()) || ((TombstoneEnchantment)enchant).isEnabled())) {
            EnchantmentHelper.func_82782_a(Collections.singletonMap(enchant, this.level), (ItemStack)stack);
            return stack;
        }
        return stack.func_77973_b() == Items.field_151134_bR ? ItemStack.field_190927_a : stack;
    }

    public LootFunctionType func_230425_b_() {
        return ModTombstone.PRECISE_ENCHANT;
    }

    public static class Serializer
    extends LootFunction.Serializer<PreciseEnchantFunction> {
        public PreciseEnchantFunction deserialize(JsonObject json, JsonDeserializationContext deserializationContext, ILootCondition[] conditionsIn) {
            return new PreciseEnchantFunction(conditionsIn, JSONUtils.func_151219_a((JsonObject)json, (String)"id", (String)"tombstone:soulbound"), JSONUtils.func_151208_a((JsonObject)json, (String)"level", (int)1));
        }

        public void serialize(JsonObject json, PreciseEnchantFunction fct, JsonSerializationContext serializationContext) {
            super.func_230424_a_(json, (LootFunction)fct, serializationContext);
            json.addProperty("id", fct.id);
            json.addProperty("level", (Number)fct.level);
        }
    }

    public static class Builder
    extends LootFunction.Builder<Builder> {
        private final String id;
        private final int level;

        public Builder(Enchantment enchantment) {
            this(enchantment, 1);
        }

        public Builder(Enchantment enchantment, int level) {
            this.id = enchantment.getRegistryName().toString();
            this.level = level;
        }

        protected Builder getThis() {
            return this;
        }

        public ILootFunction func_216052_b() {
            return new PreciseEnchantFunction(this.func_216053_g(), this.id, this.level);
        }
    }
}

